<?php
/**
 * Home Experts Custom functions and definitions
 *
 * @package Home Experts
 */
if ( ! function_exists( 'home_experts_site_logo' ) ) :
	/**
	 * Site Logo
	 */
	function home_experts_site_logo() {
		if ( function_exists( 'has_custom_logo' ) && has_custom_logo() ) {
			the_custom_logo();
		}
	}
endif;

if ( ! function_exists( 'home_experts_site_title' ) ) :
	/**
	 * Displays the site title with appropriate heading tag.
	 *
	 * Uses h1 on front page for desktop, h2 for mobile, and p tag on other pages.
	 *
	 * @since 1.0.0
	 * @param bool $is_desktop Whether this is the desktop version.
	 * @return void
	 */
	function home_experts_site_title( $is_desktop = false ) {		
		if ( is_front_page() ) {
			if ( $is_desktop ) { ?>
				<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></a></h1>
			<?php } else { ?>
				<h2 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></a></h2>
				<?php
			}
		} else {
			?>
			<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_html( get_bloginfo( 'name' ) ); ?></a></p>
			<?php
		}
	}
endif;

if ( ! function_exists( 'home_experts_site_description' ) ) :
	/**
	 * Site Description
	 */
	function home_experts_site_description() {
		$description = get_bloginfo( 'description', 'display' );
		if ( $description || is_customize_preview() ) :
			?>
			<p class="site-description">
				<?php echo wp_kses_post( $description ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
			</p>
			<?php
		endif;
	}
endif;

if ( ! function_exists( 'home_experts_mobile_header' ) ) {
	/**
	 * Displays the mobile header with branding and navigation.
	 *
	 * Outputs the mobile header markup including site branding,
	 * hamburger menu button, and mobile sidebar trigger.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function home_experts_mobile_header() {
		?>
		<div class="mobile-header">
			<div class="header-wrapper">
				<div class="header-left">
					<?php home_experts_site_branding( false ); ?>
				</div>
				<div class="header-right">
					<?php home_experts_mobile_ham_wrapper(); ?>
				</div>
			</div>
		</div>

		<div class="sidebar" id="mobileSideMenu">
			<div class="sidebar-body">
				<div class="sidebar-top-wrap">
					<?php home_experts_site_branding( false ); ?>
					<?php home_experts_mobile_close_sidebar_btn(); ?>
				</div>
				<?php home_experts_primary_navigation(); ?>
			</div>
			<div class="sidebar-footer">
				<?php home_experts_front_header_get_started(); ?>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'home_experts_breadcrumbs' ) ) :
	/**
	 * Displays breadcrumb navigation trail.
	 *
	 * Wraps the breadcrumb trail in a container div with schema.org markup.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function home_experts_breadcrumbs() {
		?>
		<div id="crumbs" class="breadcrumb-nav" itemscope="" itemtype="http://schema.org/BreadcrumbList">
			<?php home_experts_breadcrumb_trail(); ?>
		</div>
		<?php
	}
endif;

function home_experts_breadcrumb_trail( $args = array() ) {
	$breadcrumb = apply_filters( 'breadcrumb_trail_object', null, $args );

	if ( ! is_object( $breadcrumb ) ) {
		$breadcrumb = new Home_Experts_Breadcrumb_Trail( $args );
	}

	return $breadcrumb->trail();
}