<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Home Experts
 */
	/**
	 * Doctype Hook
	 *
	 * @hooked home_experts_doctype
	 */
	do_action( 'home_experts_doctype' );
?>
<head itemscope itemtype="http://schema.org/WebSite">
	<?php
	/**
	 * Before wp_head
	 *
	 * @hooked home_experts_head
	 */
	do_action( 'home_experts_before_wp_head' );

	wp_head();
	?>
</head>

<body <?php body_class(); ?> itemscope itemtype="http://schema.org/WebPage">
	<?php wp_body_open(); ?>
	<?php
	/**
	 * Before Header
	 *
	 * @hooked home_experts_page_start - 20
	 */
	do_action( 'home_experts_before_header' );

	/**
	 * Header
	 *
	 * @hooked home_experts_header_inclusion - 10
	*/
	do_action( 'home_experts_header' );

	/**
	 * Before Content
	 *
	 * @hooked home_experts_background_header   -10
	*/
	do_action( 'home_experts_after_header' );
