<?php
/**
 * Home Experts functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Home Experts
 */
if ( ! defined( 'HOME_EXPERTS_VERSION' ) ) {
	$theme = wp_get_theme();
	$theme_version = $theme->get( 'Version' );
	define( 'HOME_EXPERTS_VERSION', $theme_version );
}

/**
 * Load Breadcrumb Trail
 */
require get_template_directory() . '/inc/class-breadcrumb-trail.php';

/**
 * Load Google Fonts Locally
 */
require get_template_directory() . '/inc/local-google-font-loader.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';
/**
 * Custom Functions.
 */
require get_template_directory() . '/inc/custom-functions.php';

/**
 * User Metas
 */
require get_template_directory() . '/inc/meta/cptmeta.php';

/**
 * WordPress Hooks for this theme.
 */
require get_template_directory() . '/inc/wp-hooked.php';
/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer/customizer.php';

/**
 * Template Functions
 */
require get_template_directory() . '/inc/template-functions.php';
/**
 * Plugin Recommendation
*/
require get_template_directory() . '/inc/tgmpa/recommended-plugins.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

/**
 *  WooCommerce compatibility file.
 */
if ( home_experts_woo_boolean() ) {
	require get_template_directory() . '/inc/woo.php';
}