(function () {
    'use strict';

    //mobile-header
    const sideBar = document.getElementById('mobileSideMenu');
    const hambutton = document.getElementById('sideMenuOpener');
    const overlay = document.getElementById('overlay');
    const closeButton = document.querySelector('.close-sidebar-btn');

    // Function to disable body scroll
    function disableBodyScroll() {
        document.body.style.overflow = 'hidden';
    }

    // Function to enable body scroll
    function enableBodyScroll() {
        document.body.style.overflow = '';
    }

    // Check if mobile menu elements exist before adding event listeners
    if (hambutton && overlay && sideBar) {
        hambutton.addEventListener('click', function () {
            overlay.style.opacity = 1;
            overlay.style.visibility = 'visible';
            sideBar.style.opacity = 1;
            sideBar.style.visibility = 'visible';
            sideBar.style.left = 0;
            sideBar.classList.add('active');
            disableBodyScroll();
        });
    }

    if (overlay && sideBar) {
        overlay.addEventListener('click', function () {
            overlay.style.opacity = 0;
            overlay.style.visibility = 'hidden';
            sideBar.style.opacity = 0;
            sideBar.style.visibility = 'hidden';
            sideBar.style.left = '-100%';
            sideBar.classList.remove('active');
            enableBodyScroll();
        });
    }

    if (closeButton && overlay && sideBar) {
        closeButton.addEventListener('click', function () {
            overlay.style.opacity = 0;
            overlay.style.visibility = 'hidden';
            sideBar.style.opacity = 0;
            sideBar.style.visibility = 'hidden';
            sideBar.style.left = '-100%';
            sideBar.classList.remove('active');
            enableBodyScroll();
        });
    }

})();
