<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Home Experts
 */

get_header();

/**
 * Before Posts hook
 *
 * @hooked home_experts_content_wrapper_start
*/
do_action( 'home_experts_before_posts_content' );
?>
	<main id="main" class="site-main">
		<section class="error-404 not-found">
			<figure>
				<img src="<?php echo esc_url( apply_filters( 'home_experts_404_image', get_template_directory_uri() . '/assets/images/404-image.png' ) ); ?>" alt="">
			</figure>

			<div class="error-content">
				<h2>
					<?php esc_html_e( 'Something went wrong', 'home-experts' ); ?>
				</h2>
				<p class="error-paragraph">
					<?php esc_html_e( 'The page you are looking for might have been removed, had its name changed, or is temporarily unavailable.', 'home-experts' ); ?>
				</p>
			</div>

			<div class="error-link">
				<a href="<?php echo esc_url( get_home_url() ); ?>" class="btn btn-secondary">
					<?php echo esc_html( __( 'Back to Homepage', 'home-experts' ) ); ?>
				</a>
			</div>
		</section>
	</main>
<?php

/**
 * After Posts hook
 *
 * @hooked home_experts_content_wrapper_end - 10
 */
do_action( 'home_experts_after_posts_content' );

get_footer();

