<?php if ( post_password_required() ) : ?>
<?php return;endif; ?>

<?php if ( comments_open() ) : ?>
<div class="commentlist commentlist-<?php the_ID(); ?> index-commentlist index-commentlist-<?php the_ID(); ?>" id="comments">

<p style="display: flex;flex-flow: row nowrap;justify-content: space-between; align-items: center;" class="hmd_comments-<?php the_ID(); ?>">
    <span style="margin-left: 10px;">
        <?php
            if ( have_comments() ) {
            // 获取当前文章的所有评论
            $comments = get_comments(array(
                'post_id' => get_the_ID(), // 当前文章的ID
                'status' => 'approve', // 只获取已经被批准的评论
                'order' => 'ASC'
            ));
             
            // 遍历评论并输出头像
            $commentusers=array();
            foreach ($comments as $comment) {
                if ( !in_array($comment->comment_author_email, $commentusers) ) {
                    $commentusers[] = $comment->comment_author_email;
                    echo get_avatar( $comment->comment_author_email, 32, $default="", $comment->comment_author, array( 'width'=>32, 'height'=>32, 'class'=>array('index_avatar'),'extra_attr'=>'title="'.$comment->comment_author.'"','scheme'=>'https' ) );
                }
            }
            }else{
                _e('No Comment yet, Come On!', 'hmd');
            }
            
        ?>
    </span>
    <span><a style="text-decoration: none; display: flex;flex-flow: row nowrap;justify-content: flex-end; align-items: center; cursor: pointer;" id="show-comments-<?php the_ID(); ?>" class="hmd_index_comment" data-postid="<?php the_ID(); ?>"><i class="hmd_circle"></i><i class="hmd_circle"></i><i class="hmd_circle"></i></a></span>
</p>
<?php
    $commenter = wp_get_current_commenter();
    $req = get_option( 'require_name_email' );
    $aria_req = ( $req ? " aria-required='true'" : '' );
    $fields =  array(
        'author' => '<div id="comment-author-info" class="row screen-reader-text"><p class="comment-form-author"><label for="author" class="screen-reader-text">'.__( 'Name*', 'hmd' ).'</label><input class="form-control" id="author" name="author" type="text" value="'.esc_attr( $commenter['comment_author'] ) . '" size="24"' . $aria_req . 'placeholder="'.__( 'Name*', 'hmd' ).'" /></p>',
        'email'  => '<p class="comment-form-email"><label for="email" class="screen-reader-text">'.__( 'Email*', 'hmd' ).'</label><input class="form-control" id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="24"' . $aria_req . ' placeholder="'.__( 'Email*', 'hmd' ).'" /></p>',
        'url'    => '<p class="comment-form-url"><label for="url" class="screen-reader-text">'.__( 'Website*', 'hmd' ).'</label><input class="form-control" id="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="24" placeholder="'.__( 'Website', 'hmd' ).'" /></p></div>',
    );
    $comment_form_args = array(
        'fields'               => apply_filters( 'comment_form_default_fields', $fields ),
        'comment_field'        => '<p class="comment-form-comment" data-postid="' . get_the_ID() . '"><textarea class="form-control" ' . $aria_req . ' rows="1" cols="10" name="comment" id="comment" placeholder="'.__('Click and Reply...', 'hmd').'"></textarea></p>',
        'must_log_in'          => '<p class="must-log-in">' .  sprintf( __( 'You must be <a href="%s">logged in</a> to post a comment.', 'hmd' ), wp_login_url( apply_filters( 'the_permalink', get_permalink( ) ) ) ) . '</p>',
        'logged_in_as'         => null,
        'comment_notes_before' => null,
        'comment_notes_after'  => null,
        'class_container'      => 'comment-respond-'.get_the_ID(),
        'id_form'              => 'commentform',
        'class_form'              => 'commentform-'.get_the_ID(),
        'id_submit'            => 'submit',
        'class_submit'            => 'btn btn-danger',
        'title_reply'          => null,
        'title_reply_to'       => __( 'Leave a Reply to %s', 'hmd'),
        'cancel_reply_link'    => __( 'Cancel reply', 'hmd'),
        'label_submit'         => __( 'Post Comment', 'hmd'),
        'submit_field'         => '<p class="form-submit form-submit-'.get_the_ID().' screen-reader-text">%1$s %2$s</p>',
    );
    comment_form($comment_form_args);
?>
</div>
<?php endif; ?>