<?php
/**
 * 文章格式:状态
 *
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<div class="status-avatar"><a href="<?php echo esc_url( the_permalink() ); ?>" title="<?php the_title_attribute( array( 'before' => '', 'after' => '' ) ); ?>" rel="bookmark"><?php echo get_avatar(get_the_author_meta('user_email'), '48');?></a></div>
		<div class="header-meta">
			<span class="last-updated" title="<?php
				if (get_the_time( 'U' ) !== get_the_modified_time( 'U' )) :
					echo sprintf(__('Posted on %1$s Updated on %2$s', 'hmd'), esc_attr(get_the_time('Y-m-d H:i')), esc_attr(get_the_modified_time('Y-m-d H:i')));
				else :
					echo sprintf(__('Posted on %s', 'hmd'), esc_attr(get_the_time('Y-m-d H:i')));
				endif;
			?>">
				<?php echo timeago(get_gmt_from_date(get_the_time('Y-m-d H:i'))); ?>	
			</span>
			<?php 
				if(function_exists('getCity') && !empty(get_post_meta($post->ID,"authorIP", true))) {
					echo 'φ';
					echo getCity(get_post_meta($post->ID,"authorIP", true));
				}//支持文章作者IP归属地
			?>
			<span class="comments-views">
				<?php comments_popup_link( '', __( '<b>1</b>', 'hmd' ), __( '<b>%</b>', 'hmd' ),'comments-views' ,'' ); ?>
			</span>
			<?php edit_post_link( __( 'Edit', 'hmd' ), '<span class="edit-link">', '</span>' ); ?>
		</div>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
			the_content( 
				sprintf( 
					__( 'Continue reading%s', 'hmd' ), 
					'<span class="screen-reader-text">  '.get_the_title().'</span>' 
				) 
			);
			wp_link_pages( array( 'before' => '<nav class="page-link"><i class="hjylfont hjyl-feed1"></i><span>' . __( 'Pages:', 'hmd' ) . '</span>', 'after' => '</nav>' ) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php 
			if(is_single()) {
				the_author_posts_link();
				the_tags('<span class="tags">', ', ', '</span>');
			 }
		?>
		<?php
			if(is_home()){
				global $withcomments; $withcomments = 1;
				comments_template("/parts/index-comments.php",true);
			}
		?>
	</footer><!-- .entry-footer -->

</article><!-- #post-<?php the_ID(); ?> -->
<div class="clear"></div>
