<?php
/**
 * 文章格式:图片
 *
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
		if (is_singular()) {
			if ( is_sticky() ) {
			the_title( sprintf( '<h2 class="entry-title"><span class="sticky-title">'.__('TOP', 'hmd').'</span> <a href="%1$s" title="%2$s" rel="bookmark">', esc_url( get_permalink()), esc_html(get_the_title()) ), '</a></h2>' );
			}else{
			the_title( sprintf( '<h2 class="entry-title"><a href="%1$s" title="%2$s" rel="bookmark">', esc_url( get_permalink()), esc_html(get_the_title()) ), '</a></h2>' );
			}
		}else{
			echo sprintf( '<span class="header-image"><a href="%1$s" title="%2$s" rel="bookmark">', esc_url( get_permalink()), esc_html(get_the_title()) ).'</a></span>';
		}
		?>
		<div class="header-meta">
			<span class="last-updated" title="<?php
				if (get_the_time( 'U' ) !== get_the_modified_time( 'U' )) :
					echo sprintf(__('Posted on %1$s Updated on %2$s', 'hmd'), esc_attr(get_the_time('Y-m-d H:i')), esc_attr(get_the_modified_time('Y-m-d H:i')));
				else :
					echo sprintf(__('Posted on %s', 'hmd'), esc_attr(get_the_time('Y-m-d H:i')));
				endif;
			?>">
				<?php echo timeago(get_gmt_from_date(get_the_time('Y-m-d H:i'))); ?>	
			</span>
			<?php if(!is_singular()) { ?>
			<span class="cat-links">
				<?php _e( "#", "hmd" ); ?><?php the_category(', '); ?>
			</span>
			<?php } ?>
			<?php 
				if(function_exists('getCity') && !empty(get_post_meta($post->ID,"authorIP", true))) {
					echo 'φ';
					echo getCity(get_post_meta($post->ID,"authorIP", true));
				}//支持文章作者IP归属地
			?>
			<span class="comments-views">
				<?php comments_popup_link( '', __( '<b>1</b>', 'hmd' ), __( '<b>%</b>', 'hmd' ),'comments-views' ,'' ); ?>
			</span>
			<?php edit_post_link( __( 'Edit', 'hmd' ), '<span class="edit-link">', '</span>' ); ?>
		</div>
	</header><!-- .entry-header -->

	<div class="entry-content <?php if(!is_singular()){ ?>image-entry-content<?php } ?>">	
		<?php
			if(!is_singular()){
				$args = array(
					'posts_per_page' => 1,
					'order'          => 'ASC',
					'post_mime_type' => 'image',
					'post_parent'    => get_the_ID(),
					'post_status'    => null,
					'post_type'      => 'attachment',
				);

				$attachments = get_children( $args );
				echo '<figure class="wp-block-image">';
				if ( $attachments ) {
					foreach ( $attachments as $attachment ) {
						$image_attributes = wp_get_attachment_image_src( $attachment->ID, 'thumbnail' ) ? wp_get_attachment_image_src( $attachment->ID, 'thumbnail' ) : wp_get_attachment_image_src( $attachment->ID, 'full' );
						echo '<img src="' . esc_url( wp_get_attachment_thumb_url( $attachment->ID ) ) . '" class="wp-image-'.$attachment->ID.'" />';
					}
				}
				the_title( sprintf( '<p><a href="%1$s" title="%2$s" rel="bookmark">', esc_url( get_permalink()), esc_html(get_the_title()) ), '</a></p>' );
				echo '</figure><!-- .wp-block-image -->';
			}else{
				the_content( 
					sprintf( 
						__( 'Continue reading%s', 'hmd' ), 
						'<span class="screen-reader-text">  '.get_the_title().'</span>' 
					) 
				);
				wp_link_pages( array( 'before' => '<nav class="page-link"><i class="hjylfont hjyl-feed1"></i><span>' . __( 'Pages:', 'hmd' ) . '</span>', 'after' => '</nav>' ) );
			}
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php 
			if(is_single()) {
				the_author_posts_link();
				the_tags('<span class="tags">', ', ', '</span>');
			 }
		?>
		<?php
			if(is_home()){
				global $withcomments; $withcomments = 1;
				comments_template("/parts/index-comments.php",true);
			}
		?>
	</footer><!-- .entry-footer -->

</article><!-- #post-<?php the_ID(); ?> -->