<?php
/**
 * 文章格式:音频
 *
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
			if ( is_sticky() ) {
			the_title( sprintf( '<h2 class="entry-title"><span class="sticky-title">'.__('TOP', 'hmd').'</span> <a href="%1$s" title="%2$s" rel="bookmark">', esc_url( get_permalink()), esc_html(get_the_title()) ), '</a></h2>' );
			}else{
			the_title( sprintf( '<h2 class="entry-title"><a href="%1$s" title="%2$s" rel="bookmark">', esc_url( get_permalink()), esc_html(get_the_title()) ), '</a></h2>' );
			}
		?>
		<div class="header-meta">
			<span class="last-updated" title="<?php
				if (get_the_time( 'U' ) !== get_the_modified_time( 'U' )) :
					echo sprintf(__('Posted on %1$s Updated on %2$s', 'hmd'), esc_attr(get_the_time('Y-m-d H:i')), esc_attr(get_the_modified_time('Y-m-d H:i')));
				else :
					echo sprintf(__('Posted on %s', 'hmd'), esc_attr(get_the_time('Y-m-d H:i')));
				endif;
			?>">
				<?php echo timeago(get_gmt_from_date(get_the_time('Y-m-d H:i'))); ?>	
			</span>
			<?php if(!is_singular()) { ?>
			<span class="cat-links">
				<?php _e( "#", "hmd" ); ?><?php the_category(', '); ?>
			</span>
			<?php } ?>
			<?php 
				if(function_exists('getCity') && !empty(get_post_meta($post->ID,"authorIP", true))) {
					echo 'φ';
					echo getCity(get_post_meta($post->ID,"authorIP", true));
				}//支持文章作者IP归属地
			?>
			<span class="comments-views">
				<?php comments_popup_link( '', __( '<b>1</b>', 'hmd' ), __( '<b>%</b>', 'hmd' ),'comments-views' ,'' ); ?>
			</span>
			<?php edit_post_link( __( 'Edit', 'hmd' ), '<span class="edit-link">', '</span>' ); ?>
		</div>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php if(has_post_thumbnail() && is_home()){ ?>
		<div class="post-thumbnail" style="background-image: url(<?php the_post_thumbnail_url(array(1000,200)); ?>); width: 100%; height: 200px;"></div>
	<?php } ?>
		<?php
			the_content( 
				sprintf( 
					__( 'Continue reading%s', 'hmd' ), 
					'<span class="screen-reader-text">  '.get_the_title().'</span>' 
				) 
			);
			wp_link_pages( array( 'before' => '<nav class="page-link"><span>' . __( 'Pages:', 'hmd' ) . '</span>', 'after' => '</nav>' ) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php 
			if(is_single()) {
				the_author_posts_link();
				the_tags('<span class="tags">', ', ', '</span>');
			 }
		 ?>
		<?php
			if(is_home()){
				global $withcomments; $withcomments = 1;
				comments_template("/parts/index-comments.php",true);
			}
		?>
	</footer><!-- .entry-footer -->

</article><!-- #post-<?php the_ID(); ?> -->