<?php
/**
 * Block Styles
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_style/
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

if ( function_exists( 'register_block_style' ) ) {
	/**
	 * Register block styles.
	 *
	 * @since Twenty Twenty-One 1.0
	 *
	 * @return void
	 */
	function twenty_one_register_block_styles() {
		// Columns: Overlap.
		register_block_style(
			'core/columns',
			array(
				'name'  => 'hmd-columns-overlap',
				'label' => esc_html__( 'Overlap', 'hmd' ),
			)
		);

		// Cover: Borders.
		register_block_style(
			'core/cover',
			array(
				'name'  => 'hmd-border',
				'label' => esc_html__( 'Borders', 'hmd' ),
			)
		);

		// Group: Borders.
		register_block_style(
			'core/group',
			array(
				'name'  => 'hmd-border',
				'label' => esc_html__( 'Borders', 'hmd' ),
			)
		);

		// Image: Borders.
		register_block_style(
			'core/image',
			array(
				'name'  => 'hmd-border',
				'label' => esc_html__( 'Borders', 'hmd' ),
			)
		);

		// Image: Frame.
		register_block_style(
			'core/image',
			array(
				'name'  => 'hmd-image-frame',
				'label' => esc_html__( 'Frame', 'hmd' ),
			)
		);

		// Latest Posts: Dividers.
		register_block_style(
			'core/latest-posts',
			array(
				'name'  => 'hmd-latest-posts-dividers',
				'label' => esc_html__( 'Dividers', 'hmd' ),
			)
		);

		// Latest Posts: Borders.
		register_block_style(
			'core/latest-posts',
			array(
				'name'  => 'hmd-latest-posts-borders',
				'label' => esc_html__( 'Borders', 'hmd' ),
			)
		);

		// Media & Text: Borders.
		register_block_style(
			'core/media-text',
			array(
				'name'  => 'hmd-border',
				'label' => esc_html__( 'Borders', 'hmd' ),
			)
		);

		// Separator: Thick.
		register_block_style(
			'core/separator',
			array(
				'name'  => 'hmd-separator-thick',
				'label' => esc_html__( 'Thick', 'hmd' ),
			)
		);

		// Social icons: Dark gray color.
		register_block_style(
			'core/social-links',
			array(
				'name'  => 'hmd-social-icons-color',
				'label' => esc_html__( 'Dark gray', 'hmd' ),
			)
		);
	}
	add_action( 'init', 'twenty_one_register_block_styles' );
}
