<?php
/**
 * Block Patterns
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_pattern/
 * @link https://developer.wordpress.org/reference/functions/register_block_pattern_category/
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

/**
 * Register Block Pattern Category.
 */
function twenty_one_register_block_pattern() {
	if ( function_exists( 'register_block_pattern_category' ) ) {

		register_block_pattern_category(
			'ffhmd',
			array( 'label' => esc_html__( 'hmd', 'hmd' ) )
		);
	}

	/**
	 * Register Block Patterns.
	 */
	if ( function_exists( 'register_block_pattern' ) ) {
		// Links Area.
		register_block_pattern(
			'ffhmd/links-area',
			array(
				'title'         => esc_html__( 'Links area', 'hmd' ),
				'categories'    => array( 'hmd' ),
				'viewportWidth' => 1440,
				'description'   => esc_html_x( 'A huge text followed by social networks and email address links.', 'Block pattern description', 'hmd' ),
				'content'       => '<!-- wp:cover {"overlayColor":"green","contentPosition":"center center","align":"wide","className":"is-style-hmd-border"} --><div class="wp-block-cover alignwide has-green-background-color has-background-dim is-style-hmd-border"><div class="wp-block-cover__inner-container"><!-- wp:spacer {"height":20} --><div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div><!-- /wp:spacer --><!-- wp:paragraph {"fontSize":"huge"} --><p class="has-huge-font-size">' . wp_kses_post( __( 'Let&#8217;s Connect.', 'hmd' ) ) . '</p><!-- /wp:paragraph --><!-- wp:spacer {"height":75} --><div style="height:75px" aria-hidden="true" class="wp-block-spacer"></div><!-- /wp:spacer --><!-- wp:columns --><div class="wp-block-columns"><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph --><p><a href="#" data-type="URL">' . esc_html__( 'Twitter', 'hmd' ) . '</a> / <a href="#" data-type="URL">' . esc_html__( 'Instagram', 'hmd' ) . '</a> / <a href="#" data-type="URL">' . esc_html__( 'Dribbble', 'hmd' ) . '</a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph --><p><a href="#">' . esc_html__( 'example@example.com', 'hmd' ) . '</a></p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:spacer {"height":20} --><div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div><!-- /wp:spacer --></div></div><!-- /wp:cover --><!-- wp:paragraph --><p></p><!-- /wp:paragraph -->',
			)
		);
	}
}
add_action( 'init', 'twenty_one_register_block_pattern' );