<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page">
	<a class="skip-link screen-reader-text" href="#content">
		<?php _e( 'Skip to content', 'hmd' ); ?>
	</a>
	<div id="hjyl" class="screen-reader-text">
		<span><?php bloginfo( "name" ); ?></span>
	</div>

	<header id="header" role="banner" <?php if ( get_header_image() ) { ?> style="background-image: url(<?php header_image(); ?>);" <?php } ?>>
		<nav id="hjyl_menu" rol="navigation">
		<?php
			if(!wp_is_mobile()) {
				wp_nav_menu( array( 'theme_location' => 'primary', 'fallback_cb' => 'hjyl_wp_list_pages', 'container' => false ) );
			}else{
				wp_nav_menu( array( 'theme_location' => 'mobile', 'fallback_cb' => 'hjyl_wp_list_pages', 'container' => false ) );
			}
		?>
		</nav>
		<div class="clear"></div>
		<h1 id="logo">
			<?php if (has_custom_logo()) { the_custom_logo(); }else{?>
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php bloginfo('name'); ?>"><?php bloginfo('name'); ?></a>
		<?php } ?>
		</h1>
		<div id="darkroll"></div>
		<?php get_search_form(); ?>

		<div class="header-footer">
			<div class="position">
				<ul>
					<li>
						<a href="<?php echo esc_url(home_url()); ?>"><?php _e( "Home", "hmd" )?></a>
					</li>
					
					<?php if(is_single()) {?>
					<li>
						<?php the_category(', '); ?>
					</li>
					<?php } ?>						
					
					<?php
					/* If this is a tag archive */
					if(is_category()) {
						echo "<li>";
						single_cat_title();
						echo "</li>";
					/* If this is a search result */
					} elseif (is_search()) {
						echo "<li>";
						printf( __( 'Search Results for: %s', 'hmd' ), get_search_query() );
						echo "</li>";
					/* If this is a tag archive */
					} elseif(is_tag()) {
						echo "<li>";
						single_tag_title();
						echo "</li>";
					/* If this is a daily archive */
					} elseif (is_day()) {
						echo "<li>";
						the_time( 'Y, F jS' );
						echo "</li>";
					/* If this is a monthly archive */
					} elseif (is_month()) {
						echo "<li>";
						the_time( 'Y, F' );
						echo "</li>";
					/* If this is a yearly archive */
					} elseif (is_year()) {
						echo "<li>";
						the_time( 'Y' );
						echo "</li>";
					/* If this is a single */
					} elseif (is_singular()) {
						echo "<li>";
						if(""!==get_the_title() ) {
							the_title();
						}else{
							printf(__('Untitled #%s', 'hmd'),get_the_date('Y-m-d'));
						}
						echo "</li>";
					/* If this is Error 404 */
					} elseif (is_404()) {
						echo "<li>";
						_e('404 Error', 'hmd');	
						echo "</li>";
					} elseif ( is_author() ) {
						echo "<li>";
						printf(__( 'Author "%s" as followed', 'hmd' ), get_the_author_meta( 'display_name' ));
						echo "</li>";
					}
					$paged = get_query_var('paged'); if ( $paged > 1 ){
						echo "<li>";
						printf(__(' - Page %s - ', 'hmd'), $paged);
						echo "</li>";
					}
					?>
				</ul>
			</div>
		</div>
		
	</header>