<?php
// 此主题仅支持5.3版本以后.
if ( version_compare( $GLOBALS['wp_version'], '5.3', '<' ) ) {
	require get_template_directory() . '/parts/back-compat.php';
}

if ( ! function_exists( 'hjyl_setup' ) ) {
	function hjyl_setup() {
		// 支持语言包
		load_theme_textdomain('hmd', get_template_directory() . '/languages');

		// 在头部添加默认文章和评论链接
		add_theme_support( 'automatic-feed-links' );

		// 标题
		add_theme_support( 'title-tag' );

		// 评论回复添加@某人
		add_filter( 'comment_text' , 'hjyl_comment_add_at', 20, 2);

		// 文章底部版权说明
		add_filter('the_content', 'hjyl_copyright');

		// 文章格式
		add_theme_support(
			'post-formats',
			array(
				'gallery',
				'image',
				'quote',
				'status',
				'video',
				'audio',
			)
		);

		// 文章缩略图
		add_theme_support( 'post-thumbnails' );

		// 菜单
		register_nav_menus(
			array(
				'primary' => esc_html__( 'Primary menu', 'hmd' ),
				'mobile'  => esc_html__( 'Mobile menu', 'hmd' ),
			)
		);

		//支持HTML5
		$args = array(
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
				'navigation-widgets',
		);
		add_theme_support('html5', $args);

		// 自定义logo
		$args = array(
				'height'               => 100,
				'width'                => 100,
				'flex-width'           => true,
				'flex-height'          => true,
				'header-text'		   => array( 'site-title'),
		);
		add_theme_support('custom-logo', $args);

		//Add custom-header for AD
		$hmd_logo = array(
			'default-image'          => null,
			'random-default'         => false,
			'width'                  => 1000,
			'height'                 => 330,
			'header-text'            => false,
			'uploads'                => true,
	        'flex-width'			 => true,
	        'flex-height'			 => true,
		);
		add_theme_support( 'custom-header', $hmd_logo );

		//Add background for theme
		add_theme_support('custom-background');

		//editor style
		add_editor_style('styles/edit.css');

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );


	}
}
add_action( 'after_setup_theme', 'hjyl_setup' );

// 标题自定义
function hjyl_title_separator_to_line(){
    return '|';
}
function hjyl_document_title_parts( $title ){
	if( is_home() && isset( $title['tagline'] ) ) unset( $title['tagline'] );
	if(is_singular() && '' === get_the_title()) { 
		$title['title'] = sprintf(esc_html__('Untitled #%s', 'hmd'),get_the_date('Y-m-d'));
	};
	return $title;
}
add_filter( 'document_title_separator', 'hjyl_title_separator_to_line' );
add_filter( 'document_title_parts', 'hjyl_document_title_parts' );

// 评论回复添加@某人
function hjyl_comment_add_at( $comment_text, $comment = '') {
  if( $comment->comment_parent > 0) {
    $comment_text = '@<a href="#comment-' . $comment->comment_parent . '">'.get_comment_author( $comment->comment_parent ) . '</a> ' . $comment_text;
  }

  return $comment_text;
}

// 自定义菜单链接
function hjyl_wp_list_pages(){
	echo "<ul>";
	echo wp_list_pages('title_li=&depth=1');
	echo "</ul>";
}

// 文章底部版权说明
function hjyl_copyright($content) {
  if (is_singular() || is_feed()) {
    $content .=
      '<div id="content-copyright"><span style="font-weight:bold;text-shadow:0 1px 0 #ddd;font-size: 13px;">'.
	  esc_html__('CopyRights: ','hmd').
	  '</span><span style="font-size: 13px;">'.
	  esc_html__('The Post by ','hmd').
	  '<a rel="nofollow" href="'.esc_url("https://creativecommons.org/licenses/by-nc-sa/3.0/").'" title="'.
	  esc_html__('CC BY-NC-SA 3.0','hmd').
	  '">BY-NC-SA</a> '.
	  esc_html__('For Authorization，Original If Not Noted，Reprint Please Indicate From ','hmd').
	  '<a href="' .
      home_url() .
      '">' .
      get_bloginfo('name') .
      '</a><br>'.
	  esc_html__('Post Link: ','hmd').
	  '<a rel="bookmark" title="' .
      get_the_title() .
      '" href="' .
      get_permalink() .
      '">' .
      get_the_title() .
      '</a></span></div>';
  }
	return $content;
}

//时间格式 "xxxx 前"
function time_ago($type = 'commennt', $day = 365) {
    $d = $type == 'post' ? 'get_post_time' : 'get_comment_time';
    //if (time() - $d('U') > 60 * 60 * 24) return get_comment_time('Y.m.d H:i:s'); //月以上显示日期时间
	echo sprintf(esc_html__('%s ago','hmd'), human_time_diff($d('U') , strtotime(current_time('mysql', 0))));
}
function timeago($ptime) {
    $ptime = strtotime($ptime);
    $etime = time() - $ptime;
    if ($etime < 1) return esc_html__('Just Now','hmd');
	//if ($etime > 60 * 60 * 24) return get_the_time('Y.m.d'); //月以上显示日期
    $interval = array(
        12 * 30 * 24 * 60 * 60 => esc_html__(' years ago', 'hmd'),
        30 * 24 * 60 * 60 => esc_html__(' month ago', 'hmd'),
        //7 * 24 * 60 * 60 => esc_html__(' weeks ago', 'hmd'),
        24 * 60 * 60 => esc_html__(' days ago', 'hmd'),
        60 * 60 => esc_html__(' hours ago', 'hmd'),
        60 => esc_html__(' minutes ago', 'hmd'),
        1 => esc_html__(' seconds ago', 'hmd')
    );
    foreach ($interval as $secs => $str) {
        $d = $etime / $secs;
        if ($d >= 1) {
            $r = round($d);
            return $r . $str;
        }
    };
}

// 注册边栏函数
function hjyl_widgets_init() {

	register_sidebar(
		array(
			'name'          => esc_html__( 'Left', 'hmd' ),
			'id'            => 'left',
			'description'   => esc_html__( 'Add left widgets here to appear in Home page.', 'hmd' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Center', 'hmd' ),
			'id'            => 'center',
			'description'   => esc_html__( 'Add center widgets here to appear in Home page.', 'hmd' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Right', 'hmd' ),
			'id'            => 'right',
			'description'   => esc_html__( 'Add right widgets here to appear in Home page.', 'hmd' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'hjyl_widgets_init' );

// 这是官方默认保持最小文章宽度
function hjyl_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'hjyl_content_width', 1000 );
}
add_action( 'after_setup_theme', 'hjyl_content_width', 0 );

function hjyl_scripts() {
	wp_enqueue_script( 'jquery' );
	// 支持评论嵌套
	wp_enqueue_script( 'comment-reply' );
	wp_enqueue_script( 'ajax-comment', get_template_directory_uri() . '/asset/comments-ajax.js', array('jquery'), wp_get_theme()->get( 'Version' ), true);
	wp_localize_script( 'ajax-comment', 'ajaxcomment', array(
		'ajax_url' => admin_url('admin-ajax.php'),
		'order' => get_option('comment_order'),
		'formpostion' => 'top',
		'txt1' => esc_html__('Wait a moment...','hmd'),
		'txt2' => esc_html__('Good Comment','hmd')
	) );
	wp_enqueue_script( 'hmd-js', get_template_directory_uri() . '/asset/hmd.js', array(), wp_get_theme()->get( 'Version' ), true);
	wp_enqueue_style( 'style', get_stylesheet_uri(),  array(), wp_get_theme()->get( 'Version' ), 'all');
	//下面是霞鹜文楷字体，如果需要可以删除前面的注释
	wp_enqueue_style( 'lxgw', 'https://cdn.staticfile.org/lxgw-wenkai-screen-webfont/1.7.0/style.css', array(), wp_get_theme()->get( 'Version' ));

	if( is_page('archives') ){
		wp_enqueue_script( 'hmd-archives', get_template_directory_uri() . '/asset/archives.js', array(), wp_get_theme()->get( 'Version' ), true);
		wp_localize_script('hmd-archives', 'githubHotMap', array(
			'jsonUrl' => home_url() . '/wp-json/wp/v2/posts?',
			'articles' => esc_html__('articles', 'hmd')
	));
		wp_enqueue_style( 'hmd-archives', get_template_directory_uri() . '/styles/archives.css', array(), wp_get_theme()->get( 'Version' ), 'all');
	};
	if(is_404()){
		wp_enqueue_style( 'hmd-4043', get_template_directory_uri() . '/styles/404.css', array(), wp_get_theme()->get( 'Version' ), 'all');
	}
}
add_action( 'wp_enqueue_scripts', 'hjyl_scripts' );


function twenty_twenty_one_add_sub_menu_toggle( $output, $item, $depth, $args ) {
	if ( 0 === $depth && in_array( 'menu-item-has-children', $item->classes, true ) ) {

		// Add toggle button.
		$output .= '<button class="sub-menu-toggle" aria-expanded="false">';
		$output .= '<i class="hjylfont hjyl-jump_to_bottom">▲</i>';
		$output .= '<i class="hjylfont hjyl-jump_to_top" style="display:none;">▼</i>';
		$output .= '<span class="screen-reader-text">' . esc_html__( 'Open menu', 'hmd' ) . '</span>';
		$output .= '</button>';
	}
	return $output;
}
add_filter( 'walker_nav_menu_start_el', 'twenty_twenty_one_add_sub_menu_toggle', 10, 4 );

//显示数据库查询次数、查询时间及内存占用的代码
function iperformance($visible = false){
    $stat = sprintf('%d 次查询 用时 %.3f 秒, 耗费了 %.2fMB 内存', get_num_queries(), timer_stop(0, 3), memory_get_peak_usage() / 1024 / 1024);
    echo $visible ? $stat : "<!-- {$stat} -->";
}
add_action('wp_footer', 'iperformance', 20);

// 评论模板
require get_template_directory() . '/parts/hjyl-comment.php';
//类似GitHub活跃图
require get_template_directory() . '/parts/heatMap.php';

//引用两个官方要求，但是对我来说没用的东西
require get_template_directory() . '/parts/block-patterns.php';
require get_template_directory() . '/parts/block-styles.php';

