<?php
/**
 * Customizer
 * 
 * @package WordPress
 * @subpackage herbal-products-shop
 * @since herbal-products-shop 1.0
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function herbal_products_shop_customize_register( $wp_customize ) {
	$wp_customize->add_section( new Herbal_Products_Shop_Upsell_Section($wp_customize,'upsell_section',array(
		'title'            => __( 'Herbal Products Shop Pro', 'herbal-products-shop' ),
		'button_text'      => __( 'Upgrade Pro', 'herbal-products-shop' ),
		'url'              => 'https://www.wpradiant.net/products/herbal-products-wordpress-theme',
		'priority'         => 0,
	)));
}
add_action( 'customize_register', 'herbal_products_shop_customize_register' );

/**
 * Enqueue script for custom customize control.
 */
function herbal_products_shop_custom_control_scripts() {
	wp_enqueue_script( 'herbal-products-shop-custom-controls-js', get_template_directory_uri() . '/assets/js/custom-controls.js', array( 'jquery', 'jquery-ui-core', 'jquery-ui-sortable' ), '1.0', true );
	wp_enqueue_style( 'herbal-products-shop-customize-controls', trailingslashit( get_template_directory_uri() ) . '/assets/css/customize-controls.css' );
}
add_action( 'customize_controls_enqueue_scripts', 'herbal_products_shop_custom_control_scripts' );