<?php
/**
 * Block Styles
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_style/
 *
 * @package WordPress
 * @subpackage herbal-products-shop
 * @since herbal-products-shop 1.0
 */

if ( function_exists( 'register_block_style' ) ) {
	/**
	 * Register block styles.
	 *
	 * @since herbal-products-shop 1.0
	 *
	 * @return void
	 */
	function herbal_products_shop_register_block_styles() {
		

		// Image: Borders.
		register_block_style(
			'core/image',
			array(
				'name'  => 'herbal-products-shop-border',
				'label' => esc_html__( 'Borders', 'herbal-products-shop' ),
			)
		);

		
	}
	add_action( 'init', 'herbal_products_shop_register_block_styles' );
}