<?php
/**
 * Home starter content.
 *
 * @since 1.0.0
 * @package HelloCommerce
 */

$assets_url = HELLO_COMMERCE_STARTER_IMAGES_URL;

// @codingStandardsIgnoreStart WordPressVIPMinimum.Security.Mustache.OutputNotation -- Required for starter content.
$default_home_content = '<!-- wp:group {"align":"full","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"dimensions":{"minHeight":"60px"},"spacing":{"padding":{"right":"30px","left":"30px"}}},"backgroundColor":"black","textColor":"white","fontSize":"medium","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center","verticalAlignment":"center","orientation":"horizontal"}} -->
<div class="wp-block-group alignfull has-white-color has-black-background-color has-text-color has-background has-link-color has-medium-font-size" style="min-height:60px;padding-right:30px;padding-left:30px"><!-- wp:group {"style":{"layout":{"selfStretch":"fill","flexSize":null},"spacing":{"padding":{"top":"10px","bottom":"10px"}}},"fontSize":"medium","layout":{"type":"flex","flexWrap":"wrap","justifyContent":"center","verticalAlignment":"center"}} -->
<div class="wp-block-group has-medium-font-size" style="padding-top:10px;padding-bottom:10px"><!-- wp:image {"id":354,"sizeSlug":"full","linkDestination":"none","style":{"layout":{"selfStretch":"fixed","flexSize":"24px"}}} -->
<figure class="wp-block-image size-full"><img src="'. $assets_url .'Box.png" alt="" class="wp-image-354"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"align":"center","fontSize":"medium"} -->
<p class="has-text-align-center has-medium-font-size">Free shipping and 100 days free returns </p>
<!-- /wp:paragraph -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"textColor":"white","width":100,"className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"26px","right":"26px","top":"6px","bottom":"6px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline"><a class="wp-block-button__link has-white-color has-text-color has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:6px;padding-right:26px;padding-bottom:6px;padding-left:26px">Shop now</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group -->

<!-- wp:image {"id":353,"sizeSlug":"full","linkDestination":"none","style":{"layout":{"selfStretch":"fixed","flexSize":"16px"}}} -->
<figure class="wp-block-image size-full"><img src="'. $assets_url .'Close.png" alt="" class="wp-image-353"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group -->

<!-- wp:group {"tagName":"header","align":"full","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"dimensions":{"minHeight":"100px"},"position":{"type":""},"spacing":{"margin":{"top":"0px","bottom":"0px"},"blockGap":"","padding":{"right":"20px","left":"20px","top":"20px","bottom":"20px"}},"color":{"background":"#f6f7f8"}},"textColor":"white","fontSize":"medium","layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
<header class="wp-block-group alignfull has-white-color has-text-color has-background has-link-color has-medium-font-size" style="background-color:#f6f7f8;min-height:100px;margin-top:0px;margin-bottom:0px;padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:group {"style":{"spacing":{"blockGap":"35px"}},"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|black"}}}},"textColor":"black","fontSize":"medium"} -->
<p class="has-text-align-center has-black-color has-text-color has-link-color has-medium-font-size">Shop</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|black"}}}},"textColor":"black","fontSize":"medium"} -->
<p class="has-text-align-center has-black-color has-text-color has-link-color has-medium-font-size">Collections</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|black"}}}},"textColor":"black","fontSize":"medium"} -->
<p class="has-text-align-center has-black-color has-text-color has-link-color has-medium-font-size">About</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|black"}}}},"textColor":"black","fontSize":"medium"} -->
<p class="has-text-align-center has-black-color has-text-color has-link-color has-medium-font-size">Contact</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:image {"id":369,"scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"layout":{"selfStretch":"fixed","flexSize":"214px"},"spacing":{"margin":{"right":"214px"}}}} -->
<figure class="wp-block-image size-full" style="margin-right:214px"><img src="'. $assets_url .'logo.png" alt="" class="wp-image-369" style="object-fit:cover"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"15px"},"layout":{"selfStretch":"fit","flexSize":null}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"right","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"textColor":"black","width":100,"className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"var:preset|color|black"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"26px","right":"26px","top":"6px","bottom":"6px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline"><a class="wp-block-button__link has-black-color has-text-color has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:6px;padding-right:26px;padding-bottom:6px;padding-left:26px">My Account</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons -->

<!-- wp:image {"id":368,"scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"layout":{"selfStretch":"fixed","flexSize":"16px"}}} -->
<figure class="wp-block-image size-full"><img src="'. $assets_url .'Basket.png" alt="" class="wp-image-368" style="object-fit:cover"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></header>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"80px","bottom":"80px","right":"20px","left":"20px"}}},"layout":{"type":"flex","flexWrap":"nowrap","orientation":"vertical","justifyContent":"center"}} -->
<div class="wp-block-group" style="padding-top:80px;padding-right:20px;padding-bottom:80px;padding-left:20px"><!-- wp:heading {"textAlign":"center","level":1,"fontSize":"large"} -->
<h1 class="wp-block-heading has-text-align-center has-large-font-size"><strong>Handcrafted goods for everyday living</strong></h1>
<!-- /wp:heading -->

<!-- wp:group {"layout":{"type":"constrained","contentSize":"500px"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"center","style":{"layout":{"selfStretch":"fit","flexSize":null},"spacing":{"padding":{"top":"0px","right":"0px","bottom":"0px","left":"0px"}}},"fontSize":"medium"} -->
<p class="has-text-align-center has-medium-font-size" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px">Thoughtfully made. Beautifully useful. Shop artisan home essentials designed with care.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"layout":{"selfStretch":"fill","flexSize":null}},"fontSize":"x-large","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
<div class="wp-block-group has-x-large-font-size"><!-- wp:buttons {"style":{"layout":{"selfStretch":"fit","flexSize":null},"spacing":{"blockGap":{"top":"15px","left":"15px"}}},"fontSize":"medium","layout":{"type":"flex","orientation":"horizontal","justifyContent":"center","flexWrap":"nowrap"}} -->
<div class="wp-block-buttons has-custom-font-size has-medium-font-size"><!-- wp:button {"backgroundColor":"black","textColor":"white","width":100,"className":"is-style-fill","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"26px","right":"26px","top":"6px","bottom":"6px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-fill"><a class="wp-block-button__link has-white-color has-black-background-color has-text-color has-background has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:6px;padding-right:26px;padding-bottom:6px;padding-left:26px">Shop now</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons -->

<!-- wp:buttons {"style":{"layout":{"selfStretch":"fit","flexSize":null},"spacing":{"blockGap":{"top":"15px","left":"15px"}}},"fontSize":"medium","layout":{"type":"flex","orientation":"horizontal","justifyContent":"center","flexWrap":"nowrap"}} -->
<div class="wp-block-buttons has-custom-font-size has-medium-font-size"><!-- wp:button {"textColor":"black","width":100,"className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"var:preset|color|black"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"26px","right":"26px","top":"6px","bottom":"6px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline"><a class="wp-block-button__link has-black-color has-text-color has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:6px;padding-right:26px;padding-bottom:6px;padding-left:26px">Our story</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:image {"id":392,"sizeSlug":"full","linkDestination":"none","align":"full","style":{"layout":{"selfStretch":"fit","flexSize":null}}} -->
<figure class="wp-block-image alignfull size-full"><img src="'. $assets_url .'Hero_Image.jpg" alt="" class="wp-image-392"/></figure>
<!-- /wp:image -->

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"20px","bottom":"20px","right":"20px","left":"20px"},"margin":{"top":"0px","bottom":"0px"}}},"backgroundColor":"white","layout":{"type":"constrained","contentSize":"100%","wideSize":"100%"}} -->
<div class="wp-block-group alignfull has-white-background-color has-background" style="margin-top:0px;margin-bottom:0px;padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"50px","left":"50px"}}}} -->
<div class="wp-block-columns"><!-- wp:column {"width":"50%"} -->
<div class="wp-block-column" style="flex-basis:50%"><!-- wp:image {"id":411,"scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"color":[],"layout":{"selfStretch":"fit","flexSize":null}}} -->
<figure class="wp-block-image size-full"><img src="'. $assets_url .'About.jpg" alt="" class="wp-image-411" style="object-fit:cover"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"480px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:480px"><!-- wp:heading {"style":{"color":{"text":"#000000"},"typography":{"fontSize":"32px"}}} -->
<h2 class="wp-block-heading has-text-color" style="color:#000000;font-size:32px"><strong>A Brand That Gives Back</strong></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px"},"color":{"text":"#000000"}}} -->
<p class="has-text-color" style="color:#000000;font-size:16px">Every product we create is made with intention, from locally sourced materials to fair labor practices. We’re on a mission to bring meaningful craftsmanship into everyday life.</p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"fontSize":"medium","layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-buttons has-custom-font-size has-medium-font-size"><!-- wp:button {"backgroundColor":"black","textColor":"white","width":50,"className":"is-style-fill","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"12px","right":"12px","top":"10px","bottom":"10px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-50 is-style-fill"><a class="wp-block-button__link has-white-color has-black-background-color has-text-color has-background has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:10px;padding-right:12px;padding-bottom:10px;padding-left:12px">Explore our collection</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"60px","bottom":"60px","right":"60px","left":"60px"},"margin":{"top":"0px","bottom":"0px"},"blockGap":""},"color":{"background":"#f6f7f8"}},"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","verticalAlignment":"top"}} -->
<div class="wp-block-group alignfull has-background" style="background-color:#f6f7f8;margin-top:0px;margin-bottom:0px;padding-top:60px;padding-right:60px;padding-bottom:60px;padding-left:60px"><!-- wp:group {"align":"wide","style":{"layout":{"selfStretch":"fixed","flexSize":"350px"},"spacing":{"blockGap":"40px"}},"fontSize":"small","layout":{"type":"flex","orientation":"vertical","flexWrap":"wrap","justifyContent":"stretch"}} -->
<div class="wp-block-group alignwide has-small-font-size"><!-- wp:image {"id":495,"scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"layout":{"selfStretch":"fit","flexSize":null}}} -->
<figure class="wp-block-image size-full"><img src="'. $assets_url .'Categ_1.jpg" alt="" class="wp-image-495" style="object-fit:cover"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3,"style":{"color":{"text":"#000000"},"typography":{"fontSize":"32px"}}} -->
<h3 class="wp-block-heading has-text-color" style="color:#000000;font-size:32px"><strong>Home Goods</strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px"},"color":{"text":"#000000"}}} -->
<p class="has-text-color" style="color:#000000;font-size:16px">Thoughtfully made wooden pieces to bring warmth, function, and beauty to your everyday spaces.</p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"layout":{"selfStretch":"fill","flexSize":null},"spacing":{"blockGap":{"top":"15px","left":"15px"}}},"fontSize":"medium"} -->
<div class="wp-block-buttons has-custom-font-size has-medium-font-size"><!-- wp:button {"backgroundColor":"black","textColor":"white","width":100,"className":"is-style-fill","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"12px","right":"12px","top":"10px","bottom":"10px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-fill"><a class="wp-block-button__link has-white-color has-black-background-color has-text-color has-background has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:10px;padding-right:12px;padding-bottom:10px;padding-left:12px">Shop now</a></div>
<!-- /wp:button -->

<!-- wp:button {"textColor":"black","width":100,"className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"var:preset|color|black"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"12px","right":"12px","top":"10px","bottom":"10px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline"><a class="wp-block-button__link has-black-color has-text-color has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:10px;padding-right:12px;padding-bottom:10px;padding-left:12px">Learn more</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"wide","style":{"layout":{"selfStretch":"fixed","flexSize":"350px"},"spacing":{"blockGap":"40px"}},"fontSize":"small","layout":{"type":"flex","orientation":"vertical","flexWrap":"wrap","justifyContent":"stretch"}} -->
<div class="wp-block-group alignwide has-small-font-size"><!-- wp:image {"id":496,"sizeSlug":"full","linkDestination":"none","style":{"layout":{"selfStretch":"fit","flexSize":null}}} -->
<figure class="wp-block-image size-full"><img src="'. $assets_url .'Categ_2.jpg" alt="" class="wp-image-496"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3,"style":{"typography":{"fontSize":"32px"},"color":{"text":"#000000"}}} -->
<h3 class="wp-block-heading has-text-color" style="color:#000000;font-size:32px"><strong>Table ware</strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px"},"color":{"text":"#000000"}}} -->
<p class="has-text-color" style="color:#000000;font-size:16px">Hand-turned wooden bowls, boards, and utensils crafted for gathering, sharing, and everyday use.</p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"layout":{"selfStretch":"fill","flexSize":null},"spacing":{"blockGap":{"top":"15px","left":"15px"}}},"fontSize":"medium"} -->
<div class="wp-block-buttons has-custom-font-size has-medium-font-size"><!-- wp:button {"backgroundColor":"black","textColor":"white","width":100,"className":"is-style-fill","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"12px","right":"12px","top":"10px","bottom":"10px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-fill"><a class="wp-block-button__link has-white-color has-black-background-color has-text-color has-background has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:10px;padding-right:12px;padding-bottom:10px;padding-left:12px">Shop now</a></div>
<!-- /wp:button -->

<!-- wp:button {"textColor":"black","width":100,"className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"var:preset|color|black"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"12px","right":"12px","top":"10px","bottom":"10px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline"><a class="wp-block-button__link has-black-color has-text-color has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:10px;padding-right:12px;padding-bottom:10px;padding-left:12px">Learn more</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"wide","style":{"layout":{"selfStretch":"fixed","flexSize":"350px"},"spacing":{"blockGap":"40px"}},"fontSize":"small","layout":{"type":"flex","orientation":"vertical","flexWrap":"wrap","justifyContent":"stretch"}} -->
<div class="wp-block-group alignwide has-small-font-size"><!-- wp:image {"id":497,"sizeSlug":"full","linkDestination":"none","style":{"layout":{"selfStretch":"fit","flexSize":null}}} -->
<figure class="wp-block-image size-full"><img src="'. $assets_url .'Categ_3.jpg" alt="" class="wp-image-497"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3,"style":{"typography":{"fontSize":"32px"},"color":{"text":"#000000"}}} -->
<h3 class="wp-block-heading has-text-color" style="color:#000000;font-size:32px"><strong>Vases</strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px"},"color":{"text":"#000000"}}} -->
<p class="has-text-color" style="color:#000000;font-size:16px">Exquisite handmade artisan wooden vases, crafted with love to elevate your home decor!</p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"layout":{"selfStretch":"fill","flexSize":null},"spacing":{"blockGap":{"top":"15px","left":"15px"}}},"fontSize":"medium"} -->
<div class="wp-block-buttons has-custom-font-size has-medium-font-size"><!-- wp:button {"backgroundColor":"black","textColor":"white","width":100,"className":"is-style-fill","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"12px","right":"12px","top":"10px","bottom":"10px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-fill"><a class="wp-block-button__link has-white-color has-black-background-color has-text-color has-background has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:10px;padding-right:12px;padding-bottom:10px;padding-left:12px">Shop now</a></div>
<!-- /wp:button -->

<!-- wp:button {"textColor":"black","width":100,"className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"var:preset|color|black"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"12px","right":"12px","top":"10px","bottom":"10px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline"><a class="wp-block-button__link has-black-color has-text-color has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:10px;padding-right:12px;padding-bottom:10px;padding-left:12px">Learn more</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"60px","bottom":"60px","right":"60px","left":"60px"}}},"backgroundColor":"white","layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch","flexWrap":"wrap"}} -->
<div class="wp-block-group alignfull has-white-background-color has-background" style="padding-top:60px;padding-right:60px;padding-bottom:60px;padding-left:60px"><!-- wp:heading -->
<h2 class="wp-block-heading">New arrivals</h2>
<!-- /wp:heading -->

<!-- wp:group {"style":{"layout":{"selfStretch":"fit","flexSize":null},"spacing":{"blockGap":""}},"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:group {"align":"wide","style":{"layout":{"selfStretch":"fixed","flexSize":"400px"},"spacing":{"blockGap":"20px"}},"fontSize":"small","layout":{"type":"flex","orientation":"vertical","flexWrap":"wrap","justifyContent":"stretch"}} -->
<div class="wp-block-group alignwide has-small-font-size"><!-- wp:image {"id":446,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="'. $assets_url .'Product_1.jpg" alt="" class="wp-image-446"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3,"style":{"color":{"text":"#000000"},"typography":{"fontSize":"22px"}}} -->
<h3 class="wp-block-heading has-text-color" style="color:#000000;font-size:22px"><strong>Round Vase Duo</strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px"},"color":{"text":"#000000"}}} -->
<p class="has-text-color" style="color:#000000;font-size:16px"><strong>$84.00</strong></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"layout":{"selfStretch":"fill","flexSize":null},"spacing":{"blockGap":{"top":"15px","left":"15px"}}},"fontSize":"medium"} -->
<div class="wp-block-buttons has-custom-font-size has-medium-font-size"><!-- wp:button {"backgroundColor":"black","textColor":"white","width":75,"className":"is-style-fill","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"12px","right":"12px","top":"10px","bottom":"10px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-75 is-style-fill"><a class="wp-block-button__link has-white-color has-black-background-color has-text-color has-background has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:10px;padding-right:12px;padding-bottom:10px;padding-left:12px"><em>Add to cart</em></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"wide","style":{"layout":{"selfStretch":"fixed","flexSize":"400px"},"spacing":{"blockGap":"20px"}},"fontSize":"small","layout":{"type":"flex","orientation":"vertical","flexWrap":"wrap","justifyContent":"stretch"}} -->
<div class="wp-block-group alignwide has-small-font-size"><!-- wp:image {"id":447,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="'. $assets_url .'Product_2.jpg" alt="" class="wp-image-447"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3,"style":{"color":{"text":"#000000"},"typography":{"fontSize":"22px"}}} -->
<h3 class="wp-block-heading has-text-color" style="color:#000000;font-size:22px"><strong><strong>Spice Tray</strong></strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px"},"color":{"text":"#000000"}}} -->
<p class="has-text-color" style="color:#000000;font-size:16px"><strong><s><mark style="background-color:rgba(0, 0, 0, 0)" class="has-inline-color has-cyan-bluish-gray-color">$74.00</mark></s> $52.00</strong></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"layout":{"selfStretch":"fill","flexSize":null},"spacing":{"blockGap":{"top":"15px","left":"15px"}}},"fontSize":"medium"} -->
<div class="wp-block-buttons has-custom-font-size has-medium-font-size"><!-- wp:button {"backgroundColor":"black","textColor":"white","width":75,"className":"is-style-fill","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"12px","right":"12px","top":"10px","bottom":"10px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-75 is-style-fill"><a class="wp-block-button__link has-white-color has-black-background-color has-text-color has-background has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:10px;padding-right:12px;padding-bottom:10px;padding-left:12px"><em>Add to cart</em></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"wide","style":{"layout":{"selfStretch":"fixed","flexSize":"400px"},"spacing":{"blockGap":"20px"}},"fontSize":"small","layout":{"type":"flex","orientation":"vertical","flexWrap":"wrap","justifyContent":"stretch"}} -->
<div class="wp-block-group alignwide has-small-font-size"><!-- wp:image {"id":448,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="'. $assets_url .'Product_3.jpg" alt="" class="wp-image-448"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3,"style":{"color":{"text":"#000000"},"typography":{"fontSize":"22px"}}} -->
<h3 class="wp-block-heading has-text-color" style="color:#000000;font-size:22px"><strong>Salad Bowl Set</strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px"},"color":{"text":"#000000"}}} -->
<p class="has-text-color" style="color:#000000;font-size:16px"><strong>$120.00</strong></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"layout":{"selfStretch":"fill","flexSize":null},"spacing":{"blockGap":{"top":"15px","left":"15px"}}},"fontSize":"medium"} -->
<div class="wp-block-buttons has-custom-font-size has-medium-font-size"><!-- wp:button {"backgroundColor":"black","textColor":"white","width":75,"className":"is-style-fill","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"12px","right":"12px","top":"10px","bottom":"10px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-75 is-style-fill"><a class="wp-block-button__link has-white-color has-black-background-color has-text-color has-background has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:10px;padding-right:12px;padding-bottom:10px;padding-left:12px"><em>Add to cart</em></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"wide","style":{"layout":{"selfStretch":"fixed","flexSize":"400px"},"spacing":{"blockGap":"20px"}},"fontSize":"small","layout":{"type":"flex","orientation":"vertical","flexWrap":"wrap","justifyContent":"stretch"}} -->
<div class="wp-block-group alignwide has-small-font-size"><!-- wp:image {"id":449,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="'. $assets_url .'Product_4.jpg" alt="" class="wp-image-449"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":3,"style":{"color":{"text":"#000000"},"typography":{"fontSize":"22px"}}} -->
<h3 class="wp-block-heading has-text-color" style="color:#000000;font-size:22px"><strong>Utensil Holder</strong></h3>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"typography":{"fontSize":"16px"},"color":{"text":"#000000"}}} -->
<p class="has-text-color" style="color:#000000;font-size:16px"><strong>$64.00</strong></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"style":{"layout":{"selfStretch":"fill","flexSize":null},"spacing":{"blockGap":{"top":"15px","left":"15px"}}},"fontSize":"medium"} -->
<div class="wp-block-buttons has-custom-font-size has-medium-font-size"><!-- wp:button {"backgroundColor":"black","textColor":"white","width":75,"className":"is-style-fill","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"border":{"radius":"0px","width":"1px"},"spacing":{"padding":{"left":"12px","right":"12px","top":"10px","bottom":"10px"}}},"fontSize":"medium"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-75 is-style-fill"><a class="wp-block-button__link has-white-color has-black-background-color has-text-color has-background has-link-color has-medium-font-size has-custom-font-size wp-element-button" style="border-width:1px;border-radius:0px;padding-top:10px;padding-right:12px;padding-bottom:10px;padding-left:12px"><em>Add to cart</em></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"60px","bottom":"60px","right":"60px","left":"60px"},"margin":{"top":"0px","bottom":"0px"}},"color":{"background":"#f6f7f8"}},"layout":{"type":"constrained","contentSize":"100%","wideSize":"100%"}} -->
<div class="wp-block-group alignfull has-background" style="background-color:#f6f7f8;margin-top:0px;margin-bottom:0px;padding-top:60px;padding-right:60px;padding-bottom:60px;padding-left:60px"><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"50px","left":"50px"}}}} -->
<div class="wp-block-columns"><!-- wp:column {"width":"50%"} -->
<div class="wp-block-column" style="flex-basis:50%"><!-- wp:image {"id":434,"scale":"cover","sizeSlug":"full","style":{"color":[],"layout":{"selfStretch":"fit","flexSize":null}}} -->
<figure class="wp-block-image size-full"><img src="'. $assets_url .'Reviews.jpg" alt="" class="wp-image-434" style="object-fit:cover"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","width":"480px"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:480px"><!-- wp:heading -->
<h2 class="wp-block-heading">Customer reviews</h2>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"blockGap":"40px"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"15px"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"left","flexWrap":"wrap"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"layout":{"selfStretch":"fit","flexSize":null}}} -->
<p>You can see the craftsmanship in every Homewood item. Beautiful pieces and great quality. My order was well packaged and arrived right on time.</p>
<!-- /wp:paragraph -->

<!-- wp:group {"style":{"spacing":{"blockGap":"20px"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"left","orientation":"horizontal"}} -->
<div class="wp-block-group"><!-- wp:image {"id":436,"width":"52px","height":"52px","scale":"cover"} -->
<figure class="wp-block-image is-resized"><img src="'. $assets_url .'Berta.jpg" alt="" class="wp-image-436" style="object-fit:cover;width:52px;height:52px"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"placeholder":"Content…"} -->
<p>Berta Gray</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"15px"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"left","flexWrap":"wrap"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"layout":{"selfStretch":"fit","flexSize":null}}} -->
<p>You can see the craftsmanship in every Homewood item. Beautiful pieces and great quality. My order was well packaged and arrived right on time.</p>
<!-- /wp:paragraph -->

<!-- wp:group {"style":{"spacing":{"blockGap":"20px"}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"left","orientation":"horizontal"}} -->
<div class="wp-block-group"><!-- wp:image {"id":437,"width":"52px","height":"52px","scale":"cover"} -->
<figure class="wp-block-image is-resized"><img src="'. $assets_url .'Mel.jpg" alt="" class="wp-image-437" style="object-fit:cover;width:52px;height:52px"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"placeholder":"Content…"} -->
<p>Mel Amott</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"60px","bottom":"60px","right":"60px","left":"60px"},"margin":{"top":"0px","bottom":"0px"}}},"backgroundColor":"black","layout":{"type":"constrained","contentSize":"100%","wideSize":"100%"}} -->
<div class="wp-block-group alignfull has-black-background-color has-background" style="margin-top:0px;margin-bottom:0px;padding-top:60px;padding-right:60px;padding-bottom:60px;padding-left:60px"><!-- wp:group {"style":{"spacing":{"blockGap":"100px"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"stretch","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"layout":{"selfStretch":"fit","flexSize":null},"spacing":{"blockGap":"100px"}},"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"left","verticalAlignment":"top"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"layout":{"selfStretch":"fixed","flexSize":"350px"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"left","flexWrap":"wrap"}} -->
<div class="wp-block-group"><!-- wp:image {"id":499,"width":"195px","sizeSlug":"full","linkDestination":"none","style":{"layout":{"selfStretch":"fit","flexSize":null}}} -->
<figure class="wp-block-image size-full is-resized"><img src="'. $assets_url .'Logo-footer.png" alt="" class="wp-image-499" style="width:195px"/></figure>
<!-- /wp:image -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
<p class="has-white-color has-text-color has-link-color">Thoughtfully made. Beautifully useful. Shop artisan home essentials designed with care.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"layout":{"selfStretch":"fit","flexSize":null}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"left","flexWrap":"wrap"}} -->
<div class="wp-block-group"><!-- wp:heading {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
<h2 class="wp-block-heading has-white-color has-text-color has-link-color">Quick Links</h2>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
<p class="has-white-color has-text-color has-link-color">Shop</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
<p class="has-white-color has-text-color has-link-color">Collections</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
<p class="has-white-color has-text-color has-link-color">About</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
<p class="has-white-color has-text-color has-link-color">Contact</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"layout":{"selfStretch":"fit","flexSize":null}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"left","flexWrap":"wrap"}} -->
<div class="wp-block-group"><!-- wp:heading {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
<h2 class="wp-block-heading has-white-color has-text-color has-link-color">Customer Service</h2>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
<p class="has-white-color has-text-color has-link-color">Shipping</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
<p class="has-white-color has-text-color has-link-color">Returns</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
<p class="has-white-color has-text-color has-link-color">FAQ</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"layout":{"selfStretch":"fit","flexSize":null}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"left","flexWrap":"wrap"}} -->
<div class="wp-block-group"><!-- wp:heading {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
<h2 class="wp-block-heading has-white-color has-text-color has-link-color">Follow</h2>
<!-- /wp:heading -->

<!-- wp:social-links {"iconColor":"white","iconColorValue":"#ffffff","className":"is-style-logos-only","style":{"spacing":{"blockGap":{"top":"10px","left":"10px"}}}} -->
<ul class="wp-block-social-links has-icon-color is-style-logos-only"><!-- wp:social-link {"url":"#","service":"instagram"} /-->

<!-- wp:social-link {"url":"#","service":"tiktok"} /-->

<!-- wp:social-link {"url":"#","service":"facebook"} /--></ul>
<!-- /wp:social-links --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
<p class="has-white-color has-text-color has-link-color">©2025. All rights reserved.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->';
// @codingStandardsIgnoreEnd WordPressVIPMinimum.Security.Mustache.OutputNotation -- Required for starter content.
return [
	'post_type'    => 'page',
	'post_title'   => _x( 'Home', 'Theme starter content', 'hello-commerce' ),
	'post_content' => $default_home_content,
];
