<?php
/**
 * Template Name: Custom Home
 */

get_header(); ?>

<main id="skip-content" role="main">

	<?php do_action( 'luzuk_heena_mehndi_artist_above_slider' ); ?>

	<?php if( get_theme_mod('luzuk_heena_mehndi_artist_slider_hide_show') != ''){ ?>
	<section id="slider">
		<div class="container">
			<div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
			    <?php $luzuk_heena_mehndi_artist_slider_pages = array();
			    for ( $count = 1; $count <= 4; $count++ ) {
			        $mod = intval( get_theme_mod( 'luzuk_heena_mehndi_artist_slider'. $count ));
			        if ( 'page-none-selected' != $mod ) {
			          $luzuk_heena_mehndi_artist_slider_pages[] = $mod;
			        }
			    }
		      	if( !empty($luzuk_heena_mehndi_artist_slider_pages) ) :
			        $args = array(
			          	'post_type' => 'page',
			          	'post__in' => $luzuk_heena_mehndi_artist_slider_pages,
			          	'orderby' => 'post__in'
			        );
		        	$query = new WP_Query( $args );
		        if ( $query->have_posts() ) :
		          	$i = 1;
		    	?>     
				    <div class="carousel-inner" role="listbox">
				      	<?php  while ( $query->have_posts() ) : $query->the_post(); ?>
					        <div <?php if($i == 1){echo 'class="carousel-item fade-in-image active"';} else{ echo 'class="carousel-item fade-in-image"';}?>>
							<img src="<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>" alt="<?php the_title_attribute(); ?>" />
							<div class="s-oly"></div>
							<div class="slide-imgbx ">
						        	<!-- <div class="sliderimg "> -->
									<?php
										$luzuk_heena_mehndi_artist_slider_effect = get_theme_mod('luzuk_heena_mehndi_artist_slider_effect', '') 
									?>
									<div class="content <?php echo ($luzuk_heena_mehndi_artist_slider_effect); ?>">
										<h2><?php the_title(); ?></h2>
										<?php 
											$luzuk_heena_mehndi_artist_slider_excerpt_length = get_theme_mod('luzuk_heena_mehndi_artist_slider_excerpt_length','15');
										
											if( $luzuk_heena_mehndi_artist_slider_excerpt_length != ''){?>
											<p class="mb-0"><?php $luzuk_heena_mehndi_artist_excerpt = get_the_excerpt(); echo esc_html( luzuk_heena_mehndi_artist_string_limit_words( $luzuk_heena_mehndi_artist_excerpt, esc_attr(get_theme_mod('luzuk_heena_mehndi_artist_slider_excerpt_length','15') ) )); ?></p>
										<?php } ?>
										<a href="<?php echo esc_url(get_theme_mod('luzuk_heena_mehndi_artist_sliderbtnlink')) ?>" class="read-btn sbtn1">
											<span><?php esc_html_e('Contact Now','heena-mehndi-artist'); ?></span>
										</a>
									</div>
						        </div>
					        </div>
				      	<?php $i++; endwhile; 
				      	wp_reset_postdata();?>
				    </div>
			    <?php else : ?>
			    	<div class="no-postfound"></div>
	      		<?php endif;
			    endif;?>
			    <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
			      	<span class="carousel-control-prev-icon" aria-hidden="true"><i class="fa fa-angle-double-left"></i></span>
			      	<span class="screen-reader-text"><?php esc_html_e( 'Prev','heena-mehndi-artist' );?></span>
			    </a>
			    <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
			      	<span class="carousel-control-next-icon" aria-hidden="true"><i class="fa fa-angle-double-right"></i></span>
			      	<span class="screen-reader-text"><?php esc_html_e( 'Next','heena-mehndi-artist' );?></span>
			    </a>
			</div>
		  	<div class="clearfix"></div>
		</div>
	</section>
	<?php }?>
	
	<?php do_action('luzuk_heena_mehndi_artist_below_slider'); ?>

		<section id="aboutus-section" class="py-5">
			<div class="container"> 
				<div class="row mr-0"> 
					
					<div class="col-lg-6 col-md-12 col-sm-12">
						<div class="aboutus-image">
							<?php 
								$luzuk_heena_mehndi_artist_aboutus_rightimage = get_theme_mod('luzuk_heena_mehndi_artist_aboutus_rightimage');

								if(!empty($luzuk_heena_mehndi_artist_aboutus_rightimage)){
									echo '<img alt="'. esc_html(get_the_title()) .'" src="'.esc_url($luzuk_heena_mehndi_artist_aboutus_rightimage).'" class="img-responsive secondry-bg-img" />';
								}else{
									echo '<img alt="luzuk_heena_mehndi_artist_aboutus_rightimage" src="'.get_template_directory_uri().'/assets/images/about.png" class="img-responsive" />';
								}
							?>
						</div>
					</div>
					<div class="col-lg-6 col-md-12 col-sm-12 r-abt">
						<h1><?php echo esc_html(get_theme_mod('luzuk_heena_mehndi_artist_aboutusheading')); ?></h1>
						<h2><?php echo esc_html(get_theme_mod('luzuk_heena_mehndi_artist_aboutustitle')); ?></h2>
						<p><?php echo esc_html(get_theme_mod('luzuk_heena_mehndi_artist_aboutusdescription1')); ?></p>
						<div class="row mr-0 fdsa"> 
							<div class="col-lg-6 col-md-6 col-sm-12 pd-0 abtbox1">
								<div class="box1 box">
									<div class="row m-0">
										<div class="col-lg-4 col-md-4 col-sm-12 pd-0">
											<div class="icn">
												<i class="<?php echo esc_html(get_theme_mod('luzuk_heena_mehndi_artist_aboutusbox1icon')); ?>"></i>
											</div>
										</div>		
										<div class="col-lg-8 col-md-8 col-sm-12 pd-0">
											<h2><?php echo esc_html(get_theme_mod('luzuk_heena_mehndi_artist_aboutusbox1number')); ?></h2>
											<h3><?php echo esc_html(get_theme_mod('luzuk_heena_mehndi_artist_aboutusbox1text')); ?></h3>
										</div>
									</div>		
								</div>
							</div>	
							<div class="col-lg-6 col-md-6 col-sm-12 pd-0 abtbox2">
								<div class="box2 box">
									<div class="row m-0">
										<div class="col-lg-4 col-md-4 col-sm-12 pd-0">
											<div class="icn">
												<i class="<?php echo esc_html(get_theme_mod('luzuk_heena_mehndi_artist_aboutusbox2icon')); ?>"></i>
											</div>
										</div>		
										<div class="col-lg-8 col-md-8 col-sm-12 pd-0">
											<h2><?php echo esc_html(get_theme_mod('luzuk_heena_mehndi_artist_aboutusbox2number')); ?></h2>
											<h3><?php echo esc_html(get_theme_mod('luzuk_heena_mehndi_artist_aboutusbox2text')); ?></h3>
										</div>
									</div>		
								</div>
							</div>			
						</div>	
						<a href="<?php echo esc_html(get_theme_mod('luzuk_heena_mehndi_artist_aboutus_btnlink')); ?>" class="read-btn"><?php echo esc_html('Read More','heena-mehndi-artist'); ?>
						</a>
					</div> 
					
				</div>
			</div>
		</section>

	<?php do_action('luzuk_heena_mehndi_artist_below_service_section'); ?>

	<?php if( get_theme_mod('luzuk_heena_mehndi_artist_service_category_setting') != '' ){?>
		<section id="service-section" class="py-5">
			<div class="container"> 

				<div class="head">
					<h2 class="heading"><?php echo esc_html(get_theme_mod('luzuk_heena_mehndi_artist_serviceheading')); ?></h2>
					<h4 class="subheading"><?php echo esc_html(get_theme_mod('luzuk_heena_mehndi_artist_servicesubheading')); ?></h4>
				</div>

				<div class="row m-0">  
					<?php $luzuk_heena_mehndi_artist_catData1 =  get_theme_mod('luzuk_heena_mehndi_artist_service_category_setting');
					if($luzuk_heena_mehndi_artist_catData1){ 
						$args = array(
							'post_type' => 'post',
							'category_name' => $luzuk_heena_mehndi_artist_catData1
						);
						$i=1; ?>
						<?php $query = new WP_Query( $args );
						if ( $query->have_posts() ) :
							while( $query->have_posts() && $i <= 3) : $query->the_post(); ?>
								<div class="col-lg-4 col-md-6 single-service-bx">
									<div class="service-box">
										<a href="<?php the_permalink(); ?>">
										<?php if(has_post_thumbnail()) { ?>
			          						<div class="service-img">
			          							<?php the_post_thumbnail(); ?>
			          							<div class="ser-btn">
			          								<a href="<?php the_permalink(); ?>">
														<i class="fas fa-chevron-right"></i>
													</a>
												</div>
			          						</div>
			          					</a>
			          					<?php }?>
										
										<div class="service-content">
											<a href="<?php the_permalink(); ?>"><h4><?php the_title_attribute(); ?></h4></a>
										</div>
										<div class="clearfix"></div>
									</div>
								</div>
							<?php $i++; endwhile; 
							wp_reset_postdata(); ?>
						<?php else : ?>
							<div class="no-postfound"></div>
						<?php endif; ?>
					<?php }?>
				</div>
			</div>
		</section>
	<?php }?>

	<?php do_action('luzuk_heena_mehndi_artist_below_service_section'); ?>

	<div class="container">
	  	<?php while ( have_posts() ) : the_post(); ?>
	  		<div class="lz-content">
	        	<?php the_content(); ?>
	        </div>
	    <?php endwhile; // end of the loop. ?>
	</div>
</main>

<?php get_footer(); ?>