<?php
/**
 * Heena Mehndi Artist: Customizer
 *
 * @subpackage Heena Mehndi Artist
 * @since 1.0
 */

use WPTRT\Customize\Section\Luzuk_Heena_Mehndi_Artist_Button;

add_action( 'customize_register', function( $manager ) {

	$manager->register_section_type( Luzuk_Heena_Mehndi_Artist_Button::class );

	$manager->add_section(
		new Luzuk_Heena_Mehndi_Artist_Button( $manager, 'luzuk_heena_mehndi_artist_pro', [
			'title' => __( 'Heena Mehndi Artist Pro', 'heena-mehndi-artist' ),
			'priority' => 0,
			'button_text' => __( 'Go Pro', 'heena-mehndi-artist' ),
			'button_url'  => esc_url( 'https://www.luzuk.com/products/heena-artist-wp-theme/', 'heena-mehndi-artist')
		] )
	);

} );

// Load the JS and CSS.
add_action( 'customize_controls_enqueue_scripts', function() {

	$version = wp_get_theme()->get( 'Version' );

	wp_enqueue_script(
		'heena-mehndi-artist-customize-section-button',
		get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/js/customize-controls.js' ),
		[ 'customize-controls' ],
		$version,
		true
	);

	wp_enqueue_style(
		'heena-mehndi-artist-customize-section-button',
		get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/css/customize-controls.css' ),
		[ 'customize-controls' ],
 		$version
	);

} );

function luzuk_heena_mehndi_artist_customize_register( $wp_customize ) {

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_logo_size',array(
		'sanitize_callback'	=> 'luzuk_heena_mehndi_artist_sanitize_float'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_logo_size',array(
		'type' => 'range',
		'label' => __('Logo Size','heena-mehndi-artist'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_logo_padding',array(
		'sanitize_callback'	=> 'esc_html'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_logo_padding',array(
		'label' => __('Logo Margin','heena-mehndi-artist'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_logo_top_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_heena_mehndi_artist_sanitize_float'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_logo_top_padding',array(
		'type' => 'number',
		'description' => __('Top','heena-mehndi-artist'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_logo_bottom_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_heena_mehndi_artist_sanitize_float'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_logo_bottom_padding',array(
		'type' => 'number',
		'description' => __('Bottom','heena-mehndi-artist'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_logo_left_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_heena_mehndi_artist_sanitize_float'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_logo_left_padding',array(
		'type' => 'number',
		'description' => __('Left','heena-mehndi-artist'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_logo_right_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_heena_mehndi_artist_sanitize_float'
 	));
 	$wp_customize->add_control('luzuk_heena_mehndi_artist_logo_right_padding',array(
		'type' => 'number',
		'description' => __('Right','heena-mehndi-artist'),
		'section' => 'title_tagline',
    ));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_show_site_title',array(
		'default' => true,
		'sanitize_callback'	=> 'luzuk_heena_mehndi_artist_sanitize_checkbox'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_show_site_title',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Title','heena-mehndi-artist'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_site_title_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_site_title_color', array(
		'label' => 'Title Color',
		'section' => 'title_tagline',
	)));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_show_tagline',array(
		'default' => true,
		'sanitize_callback'	=> 'luzuk_heena_mehndi_artist_sanitize_checkbox'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_show_tagline',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Tagline','heena-mehndi-artist'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_site_tagline_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_site_tagline_color', array(
		'label' => 'Tagline Color',
		'section' => 'title_tagline',
	)));

	$wp_customize->add_panel( 'luzuk_heena_mehndi_artist_panel_id', array(
		'priority' => 10,
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => __( 'Theme Settings', 'heena-mehndi-artist' ),
		'description' => __( 'Description of what this panel does.', 'heena-mehndi-artist' ),
	) );

	$wp_customize->add_section( 'luzuk_heena_mehndi_artist_theme_options_section', array(
    	'title'      => __( 'General Settings', 'heena-mehndi-artist' ),
		'priority'   => 30,
		'panel' => 'luzuk_heena_mehndi_artist_panel_id'
	) );

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_theme_options',array(
		'default' => 'One Column',
		'sanitize_callback' => 'luzuk_heena_mehndi_artist_sanitize_choices'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_theme_options',array(
		'type' => 'select',
		'label' => __('Blog Page Sidebar Layout','heena-mehndi-artist'),
		'section' => 'luzuk_heena_mehndi_artist_theme_options_section',
		'choices' => array(
		   'Left Sidebar' => __('Left Sidebar','heena-mehndi-artist'),
		   'Right Sidebar' => __('Right Sidebar','heena-mehndi-artist'),
		   'One Column' => __('One Column','heena-mehndi-artist'),
		   'Grid Layout' => __('Grid Layout','heena-mehndi-artist')
		),
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_single_post_sidebar',array(
		'default' => 'Right Sidebar',
		'sanitize_callback' => 'luzuk_heena_mehndi_artist_sanitize_choices'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_single_post_sidebar',array(
        'type' => 'select',
        'label' => __('Single Post Sidebar Layout','heena-mehndi-artist'),
        'section' => 'luzuk_heena_mehndi_artist_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','heena-mehndi-artist'),
            'Right Sidebar' => __('Right Sidebar','heena-mehndi-artist'),
            'One Column' => __('One Column','heena-mehndi-artist')
        ),
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_page_sidebar',array(
		'default' => 'One Column',
		'sanitize_callback' => 'luzuk_heena_mehndi_artist_sanitize_choices'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_page_sidebar',array(
        'type' => 'select',
        'label' => __('Page Sidebar Layout','heena-mehndi-artist'),
        'section' => 'luzuk_heena_mehndi_artist_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','heena-mehndi-artist'),
            'Right Sidebar' => __('Right Sidebar','heena-mehndi-artist'),
            'One Column' => __('One Column','heena-mehndi-artist')
        ),
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_archive_page_sidebar',array(
		'default' => 'One Column',
		'sanitize_callback' => 'luzuk_heena_mehndi_artist_sanitize_choices'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_archive_page_sidebar',array(
        'type' => 'select',
        'label' => __('Archive & Search Page Sidebar Layout','heena-mehndi-artist'),
        'section' => 'luzuk_heena_mehndi_artist_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','heena-mehndi-artist'),
            'Right Sidebar' => __('Right Sidebar','heena-mehndi-artist'),
            'One Column' => __('One Column','heena-mehndi-artist'),
            'Grid Layout' => __('Grid Layout','heena-mehndi-artist')
        ),
	));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_boxfull_width', array(
		'default'           => '',
		'sanitize_callback' => 'luzuk_heena_mehndi_artist_sanitize_choices'
	));
	
	$wp_customize->add_control( 'luzuk_heena_mehndi_artist_boxfull_width', array(
		'label'    => __( 'Section Width', 'heena-mehndi-artist' ),
		'section'  => 'luzuk_heena_mehndi_artist_theme_options_section',
		'type'     => 'select',
		'choices'  => array(
			'container'  => __('Box Width', 'heena-mehndi-artist'),
			'container-fluid' => __('Full Width', 'heena-mehndi-artist'),
			'none' => __('None', 'heena-mehndi-artist')
		),
	));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_dropdown_anim', array(
		'default'           => 'None',
		'sanitize_callback' => 'luzuk_heena_mehndi_artist_sanitize_choices'
	));
	$wp_customize->add_control( 'luzuk_heena_mehndi_artist_dropdown_anim', array(
		'label'    => __( 'Menu Dropdown Animations', 'heena-mehndi-artist' ),
		'section'  => 'luzuk_heena_mehndi_artist_theme_options_section',
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp'  => __('bounceInUp', 'heena-mehndi-artist'),
			'fadeInUp' => __('fadeInUp', 'heena-mehndi-artist'),
			'zoomIn'    => __('zoomIn', 'heena-mehndi-artist'),
			'None'    => __('None', 'heena-mehndi-artist')
		),
	));

	//Header
	$wp_customize->add_section( 'luzuk_heena_mehndi_artist_header' , array(
    	'title'    => __( 'Header Settings', 'heena-mehndi-artist' ),
		'priority' => null,
		'panel' => 'luzuk_heena_mehndi_artist_panel_id'
	) );

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_header_toptext',array(
    	'default' => 'Elevate Trandition with our exquisite Mehendi designs',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_header_toptext',array(
	   	'type' => 'text',
	   	'label' => __('Top Text','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_header',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_header_phoneno',array(
    	'default' => '+101 234 456',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_header_phoneno',array(
	   	'type' => 'text',
	   	'label' => __('Phone Number','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_header',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_header_btnlink',array(
    	'default' => '#',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_header_btnlink',array(
	   	'type' => 'text',
	   	'label' => __('Header Button Link','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_header',
	));

	
	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_headertopbg_col', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_headertopbg_col', array(
		'label' => 'Top BG Color',
		'section' => 'luzuk_heena_mehndi_artist_header',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_headertoptext_col', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_headertoptext_col', array(
		'label' => 'Top Text Color',
		'section' => 'luzuk_heena_mehndi_artist_header',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_headertopphoneicon_col', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_headertopphoneicon_col', array(
		'label' => 'Phone Icon Color',
		'section' => 'luzuk_heena_mehndi_artist_header',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_headertopphonenumber_col', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_headertopphonenumber_col', array(
		'label' => 'Phone Number Color',
		'section' => 'luzuk_heena_mehndi_artist_header',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_menu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_menu_color', array(
		'label' => 'Menu Color',
		'section' => 'luzuk_heena_mehndi_artist_header',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_menuhover_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_menuhover_color', array(
		'label' => 'Menu Hover Color',
		'section' => 'luzuk_heena_mehndi_artist_header',
	)));


	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_submenu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_submenu_color', array(
		'label' => 'Submenu Text Color',
		'section' => 'luzuk_heena_mehndi_artist_header',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_submenubg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_submenubg_color', array(
		'label' => 'Submenu BG Color',
		'section' => 'luzuk_heena_mehndi_artist_header',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_submenuhover_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_submenuhover_color', array(
		'label' => 'Submenu Text Hover Color',
		'section' => 'luzuk_heena_mehndi_artist_header',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_submenubghrv_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_submenubghrv_color', array(
		'label' => 'Submenu BG Hover Color',
		'section' => 'luzuk_heena_mehndi_artist_header',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_headerbtntext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_headerbtntext_color', array(
		'label' => 'Button Text Color',
		'section' => 'luzuk_heena_mehndi_artist_header',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_headerbtnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_headerbtnbg_color', array(
		'label' => 'Button BG Color',
		'section' => 'luzuk_heena_mehndi_artist_header',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_btntexthrv_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_btntexthrv_color', array(
		'label' => 'Button Text Hover Color',
		'section' => 'luzuk_heena_mehndi_artist_header',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_btnbghrv_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_btnbghrv_color', array(
		'label' => 'Button BG Hover Color',
		'section' => 'luzuk_heena_mehndi_artist_header',
	)));


	//home page slider
	$wp_customize->add_section( 'luzuk_heena_mehndi_artist_slider_section' , array(
    	'title'    => __( 'Slider Settings', 'heena-mehndi-artist' ),
		'description'=> __('<b>Note :</b> Please Add Image in 1300*600 Ratio.','heena-mehndi-artist'),
		'priority' => null,
		'panel' => 'luzuk_heena_mehndi_artist_panel_id'
	) );

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_slider_hide_show',array(
    	'default' => false,
    	'sanitize_callback'	=> 'luzuk_heena_mehndi_artist_sanitize_checkbox'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_slider_hide_show',array(
	   	'type' => 'checkbox',
	   	'label' => __('Show / Hide Slider','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_slider_section',
	));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_slider_effect', array(
		'default'           => '',
		'sanitize_callback' => 'luzuk_heena_mehndi_artist_sanitize_choices'
	));
	$wp_customize->add_control( 'luzuk_heena_mehndi_artist_slider_effect', array(
		'label'    => __( 'Onload Transactions Effects', 'heena-mehndi-artist' ),
		'section'  => 'luzuk_heena_mehndi_artist_slider_section',
		'type'     => 'select',
		'choices'  => array(
			'bounceInLeft'  => __('bounceInLeft', 'heena-mehndi-artist'),
			'bounceInRight' => __('bounceInRight', 'heena-mehndi-artist'),
			'bounceInUp'    => __('bounceInUp', 'heena-mehndi-artist'),
			'bounceInDown'    => __('bounceInDown', 'heena-mehndi-artist'),
			'zoomIn'  => __('zoomIn', 'heena-mehndi-artist'),
			'zoomOut' => __('zoomOut', 'heena-mehndi-artist'),
			'fadeInDown'    => __('fadeInDown', 'heena-mehndi-artist'),
			'fadeInUp'    => __('fadeInUp', 'heena-mehndi-artist'),
			'fadeInLeft'  => __('fadeInLeft', 'heena-mehndi-artist'),
			'fadeInRight' => __('fadeInRight', 'heena-mehndi-artist'),
			'flip-up'    => __('flip-up', 'heena-mehndi-artist'),
			'none'    => __('none', 'heena-mehndi-artist')
		),
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_slider' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'luzuk_heena_mehndi_artist_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'luzuk_heena_mehndi_artist_slider' . $count, array(
			'label' => __('Select Slider Image Page', 'heena-mehndi-artist' ),
			'section' => 'luzuk_heena_mehndi_artist_slider_section',
			'type' => 'dropdown-pages'
		));
	}

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_slider_excerpt_length',array(
		'default' => '15',
		'sanitize_callback'	=> 'luzuk_heena_mehndi_artist_sanitize_float'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_slider_excerpt_length',array(
		'type' => 'number',
		'label' => __('Description Excerpt Length','heena-mehndi-artist'),
		'section' => 'luzuk_heena_mehndi_artist_slider_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_sliderbtnlink',array(
    	'default' => '#',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_sliderbtnlink',array(
	   	'type' => 'url',
	   	'label' => __('Slider Button Link','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_slider_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_slider_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_heena_mehndi_artist_sanitize_float'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_slider_font_size',array(
		'type' => 'number',
		'label' => __('Title Font Size','heena-mehndi-artist'),
		'section' => 'luzuk_heena_mehndi_artist_slider_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_slider_text_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_heena_mehndi_artist_sanitize_float'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_slider_text_font_size',array(
		'type' => 'number',
		'label' => __('Text Font Size','heena-mehndi-artist'),
		'section' => 'luzuk_heena_mehndi_artist_slider_section',
	));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_slider_brd_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_slider_brd_color', array(
		'label' => 'Border Color',
		'section' => 'luzuk_heena_mehndi_artist_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_slider_title_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_slider_title_color', array(
		'label' => 'Title Color',
		'section' => 'luzuk_heena_mehndi_artist_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_slider_description_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_slider_description_color', array(
		'label' => 'Description Color',
		'section' => 'luzuk_heena_mehndi_artist_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_slider_btntext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_slider_btntext_color', array(
		'label' => 'Button Text Color',
		'section' => 'luzuk_heena_mehndi_artist_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_slider_btnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_slider_btnbg_color', array(
		'label' => 'Button BG Color',
		'section' => 'luzuk_heena_mehndi_artist_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_slider_btntexthrv_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_slider_btntexthrv_color', array(
		'label' => 'Button Hover Color',
		'section' => 'luzuk_heena_mehndi_artist_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_slider_btnbghrv_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_slider_btnbghrv_color', array(
		'label' => 'Button BG Hover Color',
		'section' => 'luzuk_heena_mehndi_artist_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_slider_arrowicon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_slider_arrowicon_color', array(
		'label' => 'Arrow Icon Color',
		'section' => 'luzuk_heena_mehndi_artist_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_slider_arrowiconbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_slider_arrowiconbg_color', array(
		'label' => 'Arrow Icon BG Color',
		'section' => 'luzuk_heena_mehndi_artist_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_slider_arrowiconbghrv_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_slider_arrowiconbghrv_color', array(
		'label' => 'Arrow Icon BG Hover Color',
		'section' => 'luzuk_heena_mehndi_artist_slider_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_slider_overlay_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_slider_overlay_color', array(
		'label' => 'Overlay Color',
		'section' => 'luzuk_heena_mehndi_artist_slider_section',
	)));

	//Aboutus Section
	$wp_customize->add_section('luzuk_heena_mehndi_artist_aboutus_section',array(
		'title'	=> __('Aboutus Settings','heena-mehndi-artist'),
		'description'=> __('<b>Note :</b> This section will appear below the slider.','heena-mehndi-artist'),
		'panel' => 'luzuk_heena_mehndi_artist_panel_id',
	));

	$wp_customize->add_setting(
    	'luzuk_heena_mehndi_artist_aboutus_rightimage',
	    array(
	        'sanitize_callback' => 'esc_url_raw'
	    )
	);
	$wp_customize->add_control(
	    new WP_Customize_Image_Control(
	        $wp_customize,
	        'luzuk_heena_mehndi_artist_aboutus_rightimage',
	        array(
			    'label'   		=> __('Right Image','heena-mehndi-artist'),
				'description'   		=> __('Image size 750*800','heena-mehndi-artist'),
	            'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	            'settings' => 'luzuk_heena_mehndi_artist_aboutus_rightimage',
	        )
	    )
	);

	
	$wp_customize->add_setting('luzuk_heena_mehndi_artist_aboutusheading',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_aboutusheading',array(
	   	'type' => 'text',
	   	'label' => __('Sub Title','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_aboutusheading_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_heena_mehndi_artist_sanitize_float'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_aboutusheading_font_size',array(
		'type' => 'number',
		'label' => __('Font Size','heena-mehndi-artist'),
		'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_aboutustitle',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_aboutustitle',array(
	   	'type' => 'text',
	   	'label' => __('Title','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_aboutustitle_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'luzuk_heena_mehndi_artist_sanitize_float'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_aboutustitle_font_size',array(
		'type' => 'number',
		'label' => __('Font Size','heena-mehndi-artist'),
		'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_aboutusdescription1',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_aboutusdescription1',array(
	   	'type' => 'text',
	   	'label' => __('Description','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_aboutusbox1icon',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_aboutusbox1icon',array(
	   	'type' => 'text',
	   	'label' => __('Box 1 Icon (like fas fa-shield-alt)','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_aboutusbox1number',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_aboutusbox1number',array(
	   	'type' => 'text',
	   	'label' => __('Box 1 Number','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_aboutusbox1text',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_aboutusbox1text',array(
	   	'type' => 'text',
	   	'label' => __('Box 1 Text','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_aboutusbox2icon',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_aboutusbox2icon',array(
	   	'type' => 'text',
	   	'label' => __('Box 2 Icon (like fas fa-shield-alt)','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_aboutusbox2number',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_aboutusbox2number',array(
	   	'type' => 'text',
	   	'label' => __('Box 2 Number','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_aboutusbox2text',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_aboutusbox2text',array(
	   	'type' => 'text',
	   	'label' => __('Box 2 Text','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_aboutus_btnlink',array(
    	'default' => '#',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_aboutus_btnlink',array(
	   	'type' => 'text',
	   	'label' => __('Button Link','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_aboutusheading_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_aboutusheading_color', array(
		'label' => 'Heading Color',
		'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_aboutustitle_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_aboutustitle_color', array(
		'label' => 'Title Color',
		'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_aboutusdescription_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_aboutusdescription_color', array(
		'label' => 'Description Color',
		'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	)));


	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_aboutusboxbrd_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_aboutusboxbrd_color', array(
		'label' => 'Box Border Color',
		'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_aboutusboxicon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_aboutusboxicon_color', array(
		'label' => 'Box Icon Color',
		'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_aboutusboxnumber_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_aboutusboxnumber_color', array(
		'label' => 'Box Number Color',
		'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_aboutusboxtext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_aboutusboxtext_color', array(
		'label' => 'Box Text Color',
		'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_aboutusbtntext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_aboutusbtntext_color', array(
		'label' => 'Button Text Color',
		'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_aboutusbtnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_aboutusbtnbg_color', array(
		'label' => 'Button BG Color',
		'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_aboutusbtntexthrv_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_aboutusbtntexthrv_color', array(
		'label' => 'Button Text Hover Color',
		'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	)));
	
	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_aboutusbtnbghrv_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_aboutusbtnbghrv_color', array(
		'label' => 'Button BG Hover Color',
		'section' => 'luzuk_heena_mehndi_artist_aboutus_section',
	)));
	

	//Service Section
	$wp_customize->add_section('luzuk_heena_mehndi_artist_service_section',array(
		'title'	=> __('Service Settings','heena-mehndi-artist'),
		'description'=> __('<b>Note :</b> This section will appear below the About Us.','heena-mehndi-artist'),
		'panel' => 'luzuk_heena_mehndi_artist_panel_id',
	));


	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_pst[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_pst[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_service_category_setting',array(
		'default' => 'select',
		'sanitize_callback' => 'luzuk_heena_mehndi_artist_sanitize_choices',
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_service_category_setting',array(
		'type' => 'select',
		'choices' => $cat_pst,
		'label' => __('Select Category To Display Post','heena-mehndi-artist'),
		'section' => 'luzuk_heena_mehndi_artist_service_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_serviceheading',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_serviceheading',array(
	   	'type' => 'text',
	   	'label' => __('Heading','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_service_section',
	));

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_servicesubheading',array(
    	'default' => '',
    	'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('luzuk_heena_mehndi_artist_servicesubheading',array(
	   	'type' => 'text',
	   	'label' => __('Sub Heading','heena-mehndi-artist'),
	   	'section' => 'luzuk_heena_mehndi_artist_service_section',
	));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_service_heading_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_service_heading_color', array(
		'label' => 'Heading Color',
		'section' => 'luzuk_heena_mehndi_artist_service_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_service_description_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_service_description_color', array(
		'label' => 'Description Color',
		'section' => 'luzuk_heena_mehndi_artist_service_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_service_title_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_service_title_color', array(
		'label' => 'Title Color',
		'section' => 'luzuk_heena_mehndi_artist_service_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_service_titlehrv_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_service_titlehrv_color', array(
		'label' => 'Title Hover Color',
		'section' => 'luzuk_heena_mehndi_artist_service_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_service_border_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_service_border_color', array(
		'label' => 'Image Border Color',
		'section' => 'luzuk_heena_mehndi_artist_service_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_service_icon_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_service_icon_color', array(
		'label' => 'Icon Color',
		'section' => 'luzuk_heena_mehndi_artist_service_section',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_service_iconhrv_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_service_iconhrv_color', array(
		'label' => 'Icon Hover Color',
		'section' => 'luzuk_heena_mehndi_artist_service_section',
	)));


	//Footer
    $wp_customize->add_section( 'luzuk_heena_mehndi_artist_footer', array(
    	'title'  => __( 'Footer Settings', 'heena-mehndi-artist' ),
		'priority' => null,
		'panel' => 'luzuk_heena_mehndi_artist_panel_id'
	) );

	$wp_customize->add_setting('luzuk_heena_mehndi_artist_show_back_totop',array(
       'default' => true,
       'sanitize_callback'	=> 'luzuk_heena_mehndi_artist_sanitize_checkbox'
    ));
    $wp_customize->add_control('luzuk_heena_mehndi_artist_show_back_totop',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Back to Top','heena-mehndi-artist'),
       'section' => 'luzuk_heena_mehndi_artist_footer'
    ));

    $wp_customize->add_setting('luzuk_heena_mehndi_artist_footer_copy',array(
		'default' => 'Heena Mehndi Artist WordPress Theme By Luzuk',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('luzuk_heena_mehndi_artist_footer_copy',array(
		'label'	=> __('Copyright Text','heena-mehndi-artist'),
		'section' => 'luzuk_heena_mehndi_artist_footer',
		'setting' => 'luzuk_heena_mehndi_artist_footer_copy',
		'type' => 'text'
	));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_footertext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_footertext_color', array(
		'label' => 'Text Color',
		'section' => 'luzuk_heena_mehndi_artist_footer',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_footerbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_footerbg_color', array(
		'label' => 'BG Color',
		'section' => 'luzuk_heena_mehndi_artist_footer',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_footerboxbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_footerboxbg_color', array(
		'label' => 'Box BG Color',
		'section' => 'luzuk_heena_mehndi_artist_footer',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_footerbttombg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_footerbttombg_color', array(
		'label' => 'Copyright BG Color',
		'section' => 'luzuk_heena_mehndi_artist_footer',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_footercopyright_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_footercopyright_color', array(
		'label' => 'Copyright Color',
		'section' => 'luzuk_heena_mehndi_artist_footer',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_footerscrolltotoptext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_footerscrolltotoptext_color', array(
		'label' => 'Scroll To Top Text Color',
		'section' => 'luzuk_heena_mehndi_artist_footer',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_footerscrolltotopbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_footerscrolltotopbg_color', array(
		'label' => 'Scroll To Top BG Color',
		'section' => 'luzuk_heena_mehndi_artist_footer',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_footerscrolltotoptexthover_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_footerscrolltotoptexthover_color', array(
		'label' => 'Scroll To Top Text Hover Color',
		'section' => 'luzuk_heena_mehndi_artist_footer',
	)));

	$wp_customize->add_setting( 'luzuk_heena_mehndi_artist_footerscrolltotophover_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'luzuk_heena_mehndi_artist_footerscrolltotophover_color', array(
		'label' => 'Scroll To Top Hover Color',
		'section' => 'luzuk_heena_mehndi_artist_footer',
	)));




	

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'luzuk_heena_mehndi_artist_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'luzuk_heena_mehndi_artist_customize_partial_blogdescription',
	) );
}
add_action( 'customize_register', 'luzuk_heena_mehndi_artist_customize_register' );

function luzuk_heena_mehndi_artist_customize_partial_blogname() {
	bloginfo( 'name' );
}

function luzuk_heena_mehndi_artist_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

if (class_exists('WP_Customize_Control')) {

   	class Luzuk_Heena_Mehndi_Artist_Fontawesome_Icon_Chooser extends WP_Customize_Control {

      	public $type = 'icon';

      	public function render_content() { ?>
	     	<label>
	            <span class="customize-control-title">
	               <?php echo esc_html($this->label); ?>
	            </span>

	            <?php if ($this->description) { ?>
	                <span class="description customize-control-description">
	                   <?php echo wp_kses_post($this->description); ?>
	                </span>
	            <?php } ?>

	            <div class="heena-mehndi-artist-selected-icon">
	                <i class="fa <?php echo esc_attr($this->value()); ?>"></i>
	                <span><i class="fa fa-angle-down"></i></span>
	            </div>

	            <ul class="heena-mehndi-artist-icon-list clearfix">
	                <?php
	                $luzuk_heena_mehndi_artist_font_awesome_icon_array = luzuk_heena_mehndi_artist_font_awesome_icon_array();
	                foreach ($luzuk_heena_mehndi_artist_font_awesome_icon_array as $luzuk_heena_mehndi_artist_font_awesome_icon) {
	                   $icon_class = $this->value() == $luzuk_heena_mehndi_artist_font_awesome_icon ? 'icon-active' : '';
	                   echo '<li class=' . esc_attr($icon_class) . '><i class="' . esc_attr($luzuk_heena_mehndi_artist_font_awesome_icon) . '"></i></li>';
	                }
	                ?>
	            </ul>
	            <input type="hidden" value="<?php $this->value(); ?>" <?php $this->link(); ?> />
	        </label>
	        <?php
      	}
  	}
}
function luzuk_heena_mehndi_artist_customizer_script() {
   wp_enqueue_style( 'font-awesome-1', esc_url(get_template_directory_uri()).'/assets/css/fontawesome-all.css');
}
add_action( 'customize_controls_enqueue_scripts', 'luzuk_heena_mehndi_artist_customizer_script' );