<?php
/**
 * The template for displaying single posts and pages.
 * @package Health Care Center
 * @since 1.0.0
 */

get_header();

$health_care_center_default = health_care_center_get_default_theme_options();
$health_care_center_global_layout = get_theme_mod('health_care_center_global_sidebar_layout', $health_care_center_default['health_care_center_global_sidebar_layout']);
$health_care_center_page_layout = get_theme_mod('health_care_center_page_sidebar_layout', $health_care_center_global_layout);
$health_care_center_post_layout = get_theme_mod('health_care_center_post_sidebar_layout', $health_care_center_global_layout);
$health_care_center_post_meta = get_post_meta(get_the_ID(), 'health_care_center_post_sidebar_option', true);

$health_care_center_final_layout = $health_care_center_global_layout;
if (!empty($health_care_center_post_meta) && $health_care_center_post_meta !== 'default') {
    $health_care_center_final_layout = $health_care_center_post_meta;
} elseif (is_page() || (function_exists('is_shop') && is_shop())) {
    $health_care_center_final_layout = $health_care_center_page_layout;
} elseif (is_single()) {
    $health_care_center_final_layout = $health_care_center_post_layout;
}

// Set content column order based on sidebar layout
$health_care_center_sidebar_column_class = 'column-order-1';
if ($health_care_center_final_layout === 'left-sidebar') {
    $health_care_center_sidebar_column_class = 'column-order-2';
}

?>

<div id="single-page" class="singular-main-block">
    <div class="wrapper">
        <div class="column-row <?php echo esc_attr($health_care_center_final_layout === 'no-sidebar' ? 'no-sidebar-layout' : ''); ?>">

            <?php if ($health_care_center_final_layout === 'left-sidebar') : ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>

            <div id="primary" class="content-area <?php echo esc_attr($health_care_center_final_layout === 'no-sidebar' ? 'full-width-content' : $health_care_center_sidebar_column_class); ?>">
                <main id="site-content" role="main">

                    <?php
                    health_care_center_breadcrumb(); // Display breadcrumb

                    if (have_posts()) : ?>

                        <div class="article-wraper">
                            <?php while (have_posts()) : the_post(); ?>

                                <?php get_template_part('template-parts/content', 'single'); ?>

                                <?php if ((is_single() || is_page()) && (comments_open() || get_comments_number()) && !post_password_required()) : ?>
                                    <div class="comments-wrapper">
                                        <?php comments_template(); ?>
                                    </div>
                                <?php endif; ?>

                            <?php endwhile; ?>
                        </div>

                    <?php else : ?>

                        <?php get_template_part('template-parts/content', 'none'); ?>

                    <?php endif;

                    do_action('health_care_center_navigation_action');
                    ?>

                </main>
            </div>

            <?php if ($health_care_center_final_layout === 'right-sidebar') : ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>

        </div>
    </div>
</div>

<?php get_footer(); ?>