<?php
$health_care_center_layout = health_care_center_get_final_sidebar_layout();
$health_care_center_sidebar_class = 'column-order-1';

if ( $health_care_center_layout === 'left-sidebar' ) {
    $health_care_center_sidebar_class = 'column-order-1';
} elseif ( $health_care_center_layout === 'right-sidebar' ) {
    $health_care_center_sidebar_class = 'column-order-2';
}

if ( $health_care_center_layout !== 'no-sidebar' ) : ?>
    <aside id="secondary" class="widget-area <?php echo esc_attr( $health_care_center_sidebar_class ); ?>">
        <div class="widget-area-wrapper">
            <?php if ( is_active_sidebar('sidebar-1') ) : ?>
                <?php dynamic_sidebar( 'sidebar-1' ); ?>
            <?php else : ?>
                <!-- Default widgets -->
                <div class="widget widget_block widget_search">
                    <h3 class="widget-title"><?php esc_html_e('Search', 'health-care-center'); ?></h3>
                    <?php get_search_form(); ?>
                </div>

                <div class="widget widget_pages">
                    <h3 class="widget-title"><?php esc_html_e('Pages', 'health-care-center'); ?></h3>
                    <ul>
                        <?php
                        wp_list_pages(array(
                            'title_li' => '',
                        ));
                        ?>
                    </ul>
                </div>

                <div class="widget widget_archive">
                    <h3 class="widget-title"><?php esc_html_e('Archives', 'health-care-center'); ?></h3>
                    <ul>
                        <?php wp_get_archives(['type' => 'monthly', 'show_post_count' => true]); ?>
                    </ul>
                </div>

                <div class="widget widget_categories">
                    <h3 class="widget-title"><?php esc_html_e('Categories', 'health-care-center'); ?></h3>
                    <ul class="wp-block-categories-list wp-block-categories">
                        <?php wp_list_categories(['orderby' => 'name', 'title_li' => '', 'show_count' => true]); ?>
                    </ul>
                </div>

                <div class="widget widget_tag_cloud">
                    <h3 class="widget-title"><?php esc_html_e('Tags', 'health-care-center'); ?></h3>
                    <?php
                    $health_care_center_tags = get_tags();
                    if ( $health_care_center_tags ) {
                        echo '<div class="tagcloud">';
                        foreach ( $health_care_center_tags as $health_care_center_tag ) {
                            $health_care_center_link = get_tag_link($health_care_center_tag->term_id);
                            echo '<a href="' . esc_url($health_care_center_link) . '" class="tag-cloud-link">' . esc_html($health_care_center_tag->name) . '</a> ';
                        }
                        echo '</div>';
                    } else {
                        echo '<p>' . esc_html__('No tags found.', 'health-care-center') . '</p>';
                    }
                    ?>
                </div>

            <?php endif; ?>
        </div>
    </aside>
<?php endif; ?>
