<?php
/**
* Widget Functions.
*
* @package Health Care Center
*/

function health_care_center_widgets_init(){

	register_sidebar(array(
	    'name' => esc_html__('Main Sidebar', 'health-care-center'),
	    'id' => 'sidebar-1',
	    'description' => esc_html__('Add widgets here.', 'health-care-center'),
	    'before_widget' => '<div id="%1$s" class="widget %2$s">',
	    'after_widget' => '</div>',
	    'before_title' => '<h3 class="widget-title"><span>',
	    'after_title' => '</span></h3>',
	));


    $health_care_center_default = health_care_center_get_default_theme_options();
    $health_care_center_footer_column_layout = absint( get_theme_mod( 'health_care_center_footer_column_layout',$health_care_center_default['health_care_center_footer_column_layout'] ) );

    for( $i = 0; $i < $health_care_center_footer_column_layout; $i++ ){
    	
    	if( $i == 0 ){ $count = esc_html__('One','health-care-center'); }
    	if( $i == 1 ){ $count = esc_html__('Two','health-care-center'); }
    	if( $i == 2 ){ $count = esc_html__('Three','health-care-center'); }

	    register_sidebar( array(
	        'name' => esc_html__('Footer Widget ', 'health-care-center').$count,
	        'id' => 'health-care-center-footer-widget-'.$i,
	        'description' => esc_html__('Add widgets here.', 'health-care-center'),
	        'before_widget' => '<div id="%1$s" class="widget %2$s">',
	        'after_widget' => '</div>',
	        'before_title' => '<h2 class="widget-title">',
	        'after_title' => '</h2>',
	    ));
	}

}

add_action('widgets_init', 'health_care_center_widgets_init');