<?php
/**
 *
 * Pagination Functions
 *
 * @package Health Care Center
 */

/**
 * Pagination for archive.
 */
function health_care_center_render_posts_pagination() {
    // Get the setting to check if pagination is enabled
    $health_care_center_is_pagination_enabled = get_theme_mod( 'health_care_center_enable_pagination', true );

    // Check if pagination is enabled
    if ( $health_care_center_is_pagination_enabled ) {
        // Get the selected pagination type from the Customizer
        $health_care_center_pagination_type = get_theme_mod( 'health_care_center_theme_pagination_type', 'numeric' );

        // Check if the pagination type is "newer_older" (Previous/Next) or "numeric"
        if ( 'newer_older' === $health_care_center_pagination_type ) :
            // Display "Newer/Older" pagination (Previous/Next navigation)
            the_posts_navigation(
                array(
                    'prev_text' => __( '&laquo; Newer', 'health-care-center' ),  // Change the label for "previous"
                    'next_text' => __( 'Older &raquo;', 'health-care-center' ),  // Change the label for "next"
                    'screen_reader_text' => __( 'Posts navigation', 'health-care-center' ),
                )
            );
        else :
            // Display numeric pagination (Page numbers)
            the_posts_pagination(
                array(
                    'prev_text' => __( '&laquo; Previous', 'health-care-center' ),
                    'next_text' => __( 'Next &raquo;', 'health-care-center' ),
                    'type'      => 'list', // Display as <ul> <li> tags
                    'screen_reader_text' => __( 'Posts navigation', 'health-care-center' ),
                )
            );
        endif;
    }
}
add_action( 'health_care_center_posts_pagination', 'health_care_center_render_posts_pagination', 10 );