<?php
/**
 * Wizard
 *
 * @package Health_Care_Center_Whizzie
 * @author Catapult Themes
 * @since 1.0.0
 */

class Health_Care_Center_Whizzie {
	
	protected $version = '1.1.0';
	
	/** @var string Current theme name, used as namespace in actions. */
	protected $health_care_center_theme_name = '';
	protected $health_care_center_theme_title = '';
	
	/** @var string Wizard page slug and title. */
	protected $health_care_center_page_slug = '';
	protected $health_care_center_page_title = '';
	
	/** @var array Wizard steps set by user. */
	protected $config_steps = array();
	
	public $parent_slug;
	
	/**
	 * Constructor
	 *
	 * @param $config	Our config parameters
	 */
	public function __construct( $config ) {
		$this->set_vars( $config );
		$this->init();
	}
	
	/**
	 * Set some settings
	 * @since 1.0.0
	 * @param $config	Our config parameters
	 */
	public function set_vars( $config ) {

		if( isset( $config['health_care_center_page_slug'] ) ) {
			$this->health_care_center_page_slug = esc_attr( $config['health_care_center_page_slug'] );
		}
		if( isset( $config['health_care_center_page_title'] ) ) {
			$this->health_care_center_page_title = esc_attr( $config['health_care_center_page_title'] );
		}
		if( isset( $config['steps'] ) ) {
			$this->config_steps = $config['steps'];
		}

		$health_care_center_current_theme = wp_get_theme();
		$this->health_care_center_theme_title = $health_care_center_current_theme->get( 'Name' );
		$this->health_care_center_theme_name = strtolower( preg_replace( '#[^a-zA-Z]#', '', $health_care_center_current_theme->get( 'Name' ) ) );
		$this->health_care_center_page_slug = apply_filters( $this->health_care_center_theme_name . '_theme_setup_wizard_health_care_center_page_slug', $this->health_care_center_theme_name . '-wizard' );
		$this->parent_slug = apply_filters( $this->health_care_center_theme_name . '_theme_setup_wizard_parent_slug', '' );

	}
	
	/**
	 * Hooks and filters
	 * @since 1.0.0
	 */	
	public function init() {

		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'admin_menu', array( $this, 'menu_page' ) );
		add_action( 'wp_ajax_health_care_center_setup_widgets', array( $this, 'health_care_center_setup_widgets' ) );
		
	}
	
	public function enqueue_scripts() {
		wp_enqueue_style( 'health-care-center-homepage-setup-style', get_template_directory_uri() . '/inc/homepage-setup/assets/css/homepage-setup-style.css');
		wp_register_script( 'health-care-center-homepage-setup-script', get_template_directory_uri() . '/inc/homepage-setup/assets/js/homepage-setup-script.js', array( 'jquery' ), time() );
		wp_localize_script( 
			'health-care-center-homepage-setup-script',
			'whizzie_params',
			array(
				'ajaxurl' 		=> admin_url( 'admin-ajax.php' ),
				'wpnonce' 		=> wp_create_nonce( 'whizzie_nonce' ),
				'verify_text'	=> esc_html( 'verifying', 'health-care-center' )
			)
		);
		wp_enqueue_script( 'health-care-center-homepage-setup-script' );
	}
	
	public static function get_instance() {
		if ( ! self::$instance ) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	
	/**
	 * Make a modal screen for the wizard
	 */
	public function menu_page() {
		add_theme_page( esc_html( $this->health_care_center_page_title ), esc_html( $this->health_care_center_page_title ), 'manage_options', $this->health_care_center_page_slug, array( $this, 'wizard_page' ) );
	}
	
	/**
	 * Make an interface for the wizard
	 */
	public function wizard_page() {

		$url = wp_nonce_url( add_query_arg( array( 'plugins' => 'go' ) ), 'whizzie-setup' );
		$method = '';
		$fields = array_keys( $_POST );

		if ( false === ( $creds = request_filesystem_credentials( esc_url_raw( $url ), $method, false, false, $fields ) ) ) {
			return true;
		}

		if ( ! WP_Filesystem( $creds ) ) {
			request_filesystem_credentials( esc_url_raw( $url ), $method, true, false, $fields );
			return true;
		}

		$health_care_center_theme = wp_get_theme();
		$health_care_center_theme_title = $health_care_center_theme->get( 'Name' );
		$health_care_center_theme_version = $health_care_center_theme->get( 'Version' );

		?>
		<div class="wrap">
			<?php
				printf( '<h1>%s %s</h1>', esc_html( $health_care_center_theme_title ), esc_html( '(Version :- ' . $health_care_center_theme_version . ')' ) );
			?>
			<div class="homepage-setup">
				<div class="homepage-setup-theme-bundle">
					<div class="homepage-setup-theme-bundle-one">
						<h1><?php echo esc_html__( 'WP Theme Bundle', 'health-care-center' ); ?></h1>
						<p><?php echo wp_kses_post( 'Get <span>15% OFF</span> on all WordPress themes! Use code <span>"BNDL15OFF"</span> at checkout. Limited time offer!' ); ?></p>
					</div>
					<div class="homepage-setup-theme-bundle-two">
						<p><?php echo wp_kses_post( 'Extra <span>15%</span> OFF' ); ?></p>
					</div>
					<div class="homepage-setup-theme-bundle-three">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/bundle-banner.png' ); ?>" alt="<?php echo esc_attr__( 'Theme Bundle Image', 'health-care-center' ); ?>">
					</div>
					<div class="homepage-setup-theme-bundle-four">
						<p><?php echo wp_kses_post( '<span>$2795</span>$69' ); ?></p>
						<a target="_blank" href="<?php echo esc_url( HEALTH_CARE_CENTER_BUNDLE_BUTTON ); ?>"><?php echo esc_html__( 'SHOP NOW', 'health-care-center' ); ?> <span class="dashicons dashicons-arrow-right-alt2"></span></a>
					</div>
				</div>
			</div>
			
			<div class="card whizzie-wrap">
				<div class="demo_content_image">
					<div class="demo_content">
						<?php
							$health_care_center_steps = $this->get_steps();
							echo '<ul class="whizzie-menu">';
							foreach ( $health_care_center_steps as $health_care_center_step ) {
								$class = 'step step-' . esc_attr( $health_care_center_step['id'] );
								echo '<li data-step="' . esc_attr( $health_care_center_step['id'] ) . '" class="' . esc_attr( $class ) . '">';
								printf( '<h2>%s</h2>', esc_html( $health_care_center_step['title'] ) );

								$content = call_user_func( array( $this, $health_care_center_step['view'] ) );
								if ( isset( $content['summary'] ) ) {
									printf(
										'<div class="summary">%s</div>',
										wp_kses_post( $content['summary'] )
									);
								}
								if ( isset( $content['detail'] ) ) {
									printf(
										'<div class="detail">%s</div>',
										wp_kses_post( $content['detail'] )
									);
								}
								if ( isset( $health_care_center_step['button_text'] ) && $health_care_center_step['button_text'] ) {
									printf( 
										'<div class="button-wrap"><a href="#" class="button button-primary do-it" data-callback="%s" data-step="%s">%s</a></div>',
										esc_attr( $health_care_center_step['callback'] ),
										esc_attr( $health_care_center_step['id'] ),
										esc_html( $health_care_center_step['button_text'] )
									);
								}
								echo '</li>';
							}
							echo '</ul>';
						?>
						
						<ul class="whizzie-nav">
							<?php
							$step_number = 1;	
							foreach ( $health_care_center_steps as $health_care_center_step ) {
								echo '<li class="nav-step-' . esc_attr( $health_care_center_step['id'] ) . '">';
								echo '<span class="step-number">' . esc_html( $step_number ) . '</span>';
								echo '</li>';
								$step_number++;
							}
							?>
							<div class="blank-border"></div>
						</ul>

						<div class="homepage-setup-links">
							<div class="homepage-setup-links buttons">
								<a href="<?php echo esc_url( HEALTH_CARE_CENTER_LITE_DOCS_PRO ); ?>" target="_blank" class="button button-primary"><?php echo esc_html__( 'Free Documentation', 'health-care-center' ); ?></a>
								<a href="<?php echo esc_url( HEALTH_CARE_CENTER_BUY_NOW ); ?>" class="button button-primary" target="_blank"><?php echo esc_html__( 'Get Premium', 'health-care-center' ); ?></a>
								<a href="<?php echo esc_url( HEALTH_CARE_CENTER_DEMO_PRO ); ?>" class="button button-primary" target="_blank"><?php echo esc_html__( 'Premium Demo', 'health-care-center' ); ?></a>
								<a href="<?php echo esc_url( HEALTH_CARE_CENTER_SUPPORT_FREE ); ?>" target="_blank" class="button button-primary"><?php echo esc_html__( 'Support Forum', 'health-care-center' ); ?></a>
							</div>
						</div> <!-- .demo_image -->

						<div class="step-loading"><span class="spinner"></span></div>
					</div> <!-- .demo_content -->

					<div class="homepage-setup-image">
						<div class="homepage-setup-theme-buynow">
							<div class="homepage-setup-theme-buynow-one">
								<h1><?php echo wp_kses_post( 'Health Care<br>WordPress Theme' ); ?></h1>
								<p><?php echo wp_kses_post( '<span>25%<br>Off</span> SHOP NOW' ); ?></p>
							</div>
							<div class="homepage-setup-theme-buynow-two">
								<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/homepage-setup/assets/homepage-setup-images/health-care-center.png' ); ?>" alt="<?php echo esc_attr__( 'Theme Bundle Image', 'health-care-center' ); ?>">
							</div>
							<div class="homepage-setup-theme-buynow-three">
								<p><?php echo wp_kses_post( 'Get <span>25% OFF</span> on Premium Health Care WordPress Theme Use code <span>"NYTHEMES25"</span> at checkout.' ); ?></p>
							</div>
							<div class="homepage-setup-theme-buynow-four">
								<a target="_blank" href="<?php echo esc_url( HEALTH_CARE_CENTER_BUY_NOW ); ?>"><?php echo esc_html__( 'Upgrade To Pro With Just $40', 'health-care-center' ); ?></a>
							</div>
						</div>
					</div> <!-- .demo_image -->

				</div> <!-- .demo_content_image -->
			</div> <!-- .whizzie-wrap -->
		</div> <!-- .wrap -->
		<?php
	}


	/**
	 * Set options for the steps
	 * Incorporate any options set by the theme dev
	 * Return the array for the steps
	 * @return Array
	 */
	public function get_steps() {
		$health_care_center_dev_steps = $this->config_steps;
		$health_care_center_steps = array(
			'widgets' => array(
				'id'			=> 'widgets',
				'title'			=> __( 'Setup Home Page', 'health-care-center' ),
				'icon'			=> 'welcome-widgets-menus',
				'view'			=> 'get_step_widgets',
				'callback'		=> 'health_care_center_install_widgets',
				'button_text'	=> __( 'Start Home Page Setup', 'health-care-center' ),
				'can_skip'		=> false
			),
			'done' => array(
				'id'			=> 'done',
				'title'			=> __( 'Customize Your Site', 'health-care-center' ),
				'icon'			=> 'yes',
				'view'			=> 'get_step_done',
				'callback'		=> ''
			)
		);
		
		// Iterate through each step and replace with dev config values
		if( $health_care_center_dev_steps ) {
			// Configurable elements - these are the only ones the dev can update from homepage-setup-settings.php
			$can_config = array( 'title', 'icon', 'button_text', 'can_skip' );
			foreach( $health_care_center_dev_steps as $health_care_center_dev_step ) {
				// We can only proceed if an ID exists and matches one of our IDs
				if( isset( $health_care_center_dev_step['id'] ) ) {
					$id = $health_care_center_dev_step['id'];
					if( isset( $health_care_center_steps[$id] ) ) {
						foreach( $can_config as $element ) {
							if( isset( $health_care_center_dev_step[$element] ) ) {
								$health_care_center_steps[$id][$element] = $health_care_center_dev_step[$element];
							}
						}
					}
				}
			}
		}
		return $health_care_center_steps;
	}
	
	/**
	 * Print the content for the widgets step
	 * @since 1.1.0
	 */
	public function get_step_widgets() { ?> <?php }
	
	/**
	 * Print the content for the final step
	 */
	public function get_step_done() { ?>
		<div id="health-care-center-demo-setup-guid">
			<div class="customize_div">
				<div class="customize_div finish">
					<div class="customize_div finish btns">
						<h3><?php echo esc_html( 'Your Site Is Ready To View' ); ?></h3>
						<div class="btnsss">
							<a target="_blank" href="<?php echo esc_url( get_home_url() ); ?>" class="button button-primary">
								<?php esc_html_e( 'View Your Site', 'health-care-center' ); ?>
							</a>
							<a target="_blank" href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>" class="button button-primary">
								<?php esc_html_e( 'Customize Your Site', 'health-care-center' ); ?>
							</a>
							<a href="<?php echo esc_url(admin_url()); ?>" class="button button-primary">
								<?php esc_html_e( 'Finsh', 'health-care-center' ); ?>
							</a>
						</div>
					</div>
					<div class="health-care-center-setup-finish">
						<img src="<?php echo esc_url( get_template_directory_uri() . '/screenshot.png' ); ?>"/>
					</div>
				</div>
			</div>
		</div>
	<?php }


	public function health_care_center_customizer_nav_menu() {

		/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- Health Care Center Primary Menu -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/

		$health_care_center_themename = 'Health Care Center';
		$health_care_center_menuname = $health_care_center_themename . ' Primary Menu';
		$health_care_center_menulocation = 'health-care-center-primary-menu';
		$health_care_center_menu_exists = wp_get_nav_menu_object($health_care_center_menuname);

		if (!$health_care_center_menu_exists) {
			$health_care_center_menu_id = wp_create_nav_menu($health_care_center_menuname);

			// Home
			wp_update_nav_menu_item($health_care_center_menu_id, 0, array(
				'menu-item-title' => __('Home', 'health-care-center'),
				'menu-item-classes' => 'home',
				'menu-item-url' => home_url('/'),
				'menu-item-status' => 'publish'
			));

			// About
			$health_care_center_page_about = get_page_by_path('about');
			if($health_care_center_page_about){
				wp_update_nav_menu_item($health_care_center_menu_id, 0, array(
					'menu-item-title' => __('About', 'health-care-center'),
					'menu-item-classes' => 'about',
					'menu-item-url' => get_permalink($health_care_center_page_about),
					'menu-item-status' => 'publish'
				));
			}

			// Services
			$health_care_center_page_services = get_page_by_path('services');
			if($health_care_center_page_services){
				wp_update_nav_menu_item($health_care_center_menu_id, 0, array(
					'menu-item-title' => __('Services', 'health-care-center'),
					'menu-item-classes' => 'services',
					'menu-item-url' => get_permalink($health_care_center_page_services),
					'menu-item-status' => 'publish'
				));
			}

			// Shop Page (WooCommerce)
			if (class_exists('WooCommerce')) {
				$health_care_center_shop_page_id = wc_get_page_id('shop');
				if ($health_care_center_shop_page_id) {
					wp_update_nav_menu_item($health_care_center_menu_id, 0, array(
						'menu-item-title' => __('Shop', 'health-care-center'),
						'menu-item-classes' => 'shop',
						'menu-item-url' => get_permalink($health_care_center_shop_page_id),
						'menu-item-status' => 'publish'
					));
				}
			}

			// Blog
			$health_care_center_page_blog = get_page_by_path('blog');
			if($health_care_center_page_blog){
				wp_update_nav_menu_item($health_care_center_menu_id, 0, array(
					'menu-item-title' => __('Blog', 'health-care-center'),
					'menu-item-classes' => 'blog',
					'menu-item-url' => get_permalink($health_care_center_page_blog),
					'menu-item-status' => 'publish'
				));
			}

			// 404 Page
			$health_care_center_notfound = get_page_by_path('404 Page');
			if($health_care_center_notfound){
				wp_update_nav_menu_item($health_care_center_menu_id, 0, array(
					'menu-item-title' => __('404 Page', 'health-care-center'),
					'menu-item-classes' => '404',
					'menu-item-url' => get_permalink($health_care_center_notfound),
					'menu-item-status' => 'publish'
				));
			}

			if (!has_nav_menu($health_care_center_menulocation)) {
				$health_care_center_locations = get_theme_mod('nav_menu_locations');
				$health_care_center_locations[$health_care_center_menulocation] = $health_care_center_menu_id;
				set_theme_mod('nav_menu_locations', $health_care_center_locations);
			}
		}
	}

	
	/**
	 * Imports the Demo Content
	 * @since 1.1.0
	 */
	public function health_care_center_setup_widgets(){

		/* -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+- MENUS PAGES -+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-*/
		
			// Creation of home page //
			$health_care_center_home_content = '';
			$health_care_center_home_title = 'Home';
			$health_care_center_home = array(
					'post_type' => 'page',
					'post_title' => $health_care_center_home_title,
					'post_content'  => $health_care_center_home_content,
					'post_status' => 'publish',
					'post_author' => 1,
					'post_slug' => 'home'
			);
			$health_care_center_home_id = wp_insert_post($health_care_center_home);

			add_post_meta( $health_care_center_home_id, '_wp_page_template', 'frontpage.php' );

			$health_care_center_home = get_page_by_path( 'Home' );
			update_option( 'page_on_front', $health_care_center_home->ID );
			update_option( 'show_on_front', 'page' );

			// Creation of blog page //
			$health_care_center_blog_title = 'Blog';
			$health_care_center_blog_check = get_page_by_path('blog');
			if (!$health_care_center_blog_check) {
				$health_care_center_blog = array(
					'post_type'    => 'page',
					'post_title'   => $health_care_center_blog_title,
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_name'    => 'blog'
				);
				$health_care_center_blog_id = wp_insert_post($health_care_center_blog);

				if (!is_wp_error($health_care_center_blog_id)) {
					update_option('page_for_posts', $health_care_center_blog_id);
				}
			}

			// Creation of about page //
			$health_care_center_about_title = 'About';
			$health_care_center_about_content = 'What is Lorem Ipsum?
														Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
			$health_care_center_about_check = get_page_by_path('about');
			if (!$health_care_center_about_check) {
				$health_care_center_about = array(
					'post_type'    => 'page',
					'post_title'   => $health_care_center_about_title,
					'post_content'   => $health_care_center_about_content,
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_name'    => 'about'
				);
				wp_insert_post($health_care_center_about);
			}

			// Creation of services page //
			$health_care_center_services_title = 'Services';
			$health_care_center_services_content = 'What is Lorem Ipsum?
														Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.
														&nbsp;
														Why do we use it?
														It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using Content here, content here, making it look like readable English. Many desktop publishing packages and web page editors now use Lorem Ipsum as their default model text, and a search for lorem ipsum will uncover many web sites still in their infancy. Various versions have evolved over the years, sometimes by accident, sometimes on purpose (injected humour and the like).
														&nbsp;
														Where does it come from?
														There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text. All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
			$health_care_center_services_check = get_page_by_path('services');
			if (!$health_care_center_services_check) {
				$health_care_center_services = array(
					'post_type'    => 'page',
					'post_title'   => $health_care_center_services_title,
					'post_content'   => $health_care_center_services_content,
					'post_status'  => 'publish',
					'post_author'  => 1,
					'post_name'    => 'services'
				);
				wp_insert_post($health_care_center_services);
			}

			// Creation of 404 page //
			$health_care_center_notfound_title = '404 Page';
			$health_care_center_notfound = array(
				'post_type'   => 'page',
				'post_title'  => $health_care_center_notfound_title,
				'post_status' => 'publish',
				'post_author' => 1,
				'post_slug'   => '404'
			);
			$health_care_center_notfound_id = wp_insert_post($health_care_center_notfound);
			add_post_meta($health_care_center_notfound_id, '_wp_page_template', '404.php');

        
        $this->health_care_center_customizer_nav_menu();

	    exit;
	}
}