<?php

function health_care_center_enqueue_fonts() {
    $health_care_center_default_font_content = 'Inter';
    $health_care_center_default_font_heading = 'Playfair Display';

    $health_care_center_font_content = esc_attr(get_theme_mod('health_care_center_content_typography_font', $health_care_center_default_font_content));
    $health_care_center_font_heading = esc_attr(get_theme_mod('health_care_center_heading_typography_font', $health_care_center_default_font_heading));

    $health_care_center_css = '';

    // Always enqueue main font
    $health_care_center_css .= '
    :root {
        --font-main: ' . $health_care_center_font_content . ', ' . (in_array($health_care_center_font_content, ['bitter', 'charis-sil']) ? 'serif' : 'sans-serif') . '!important;
    }';
    wp_enqueue_style('health-care-center-style-font-general', get_template_directory_uri() . '/fonts/' . $health_care_center_font_content . '/font.css');

    // Always enqueue header font
    $health_care_center_css .= '
    :root {
        --font-head: ' . $health_care_center_font_heading . ', ' . (in_array($health_care_center_font_heading, ['bitter', 'charis-sil']) ? 'serif' : 'sans-serif') . '!important;
    }';
    wp_enqueue_style('health-care-center-style-font-h', get_template_directory_uri() . '/fonts/' . $health_care_center_font_heading . '/font.css');

    // Add inline style
    wp_add_inline_style('health-care-center-style-font-general', $health_care_center_css);
}
add_action('wp_enqueue_scripts', 'health_care_center_enqueue_fonts', 50);