<?php
/**
* Typography Settings.
*
* @package Health Care Center
*/

$health_care_center_default = health_care_center_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'health_care_center_typography_setting',
	array(
	'title'      => esc_html__( 'Typography Settings', 'health-care-center' ),
	'priority'   => 21,
	'capability' => 'edit_theme_options',
	'panel'      => 'health_care_center_theme_option_panel',
	)
);

// -----------------  Font array
$health_care_center_fonts = array(
    'Select'           => __('Default Font', 'health-care-center'),
    'bad-script' => 'Bad Script',
    'bitter'     => 'Bitter',
    'cuprum'     => 'Cuprum',
    'exo-2'      => 'Exo 2',
    'jost'       => 'Jost',
    'open-sans'  => 'Open Sans',
    'oswald'     => 'Oswald',
    'play'       => 'Play',
    'roboto'     => 'Roboto',
    'Inter'     => 'Inter',
    'Playfair Display'     => 'PlayfairDisplay',
);

 // -----------------  General text font
 $wp_customize->add_setting( 'health_care_center_content_typography_font', array(
    'default'           => 'Inter',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_radio_sanitize',
) );
$wp_customize->add_control( 'health_care_center_content_typography_font', array(
    'type'     => 'select',
    'label'    => esc_html__( 'General Content Font', 'health-care-center' ),
    'section'  => 'health_care_center_typography_setting',
    'settings' => 'health_care_center_content_typography_font',
    'choices'  => $health_care_center_fonts,
) );

 // -----------------  General Heading Font
$wp_customize->add_setting( 'health_care_center_heading_typography_font', array(
    'default'           => 'Playfair Display',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_radio_sanitize',
) );
$wp_customize->add_control( 'health_care_center_heading_typography_font', array(
    'type'     => 'select',
    'label'    => esc_html__( 'General Heading Font', 'health-care-center' ),
    'section'  => 'health_care_center_typography_setting',
    'settings' => 'health_care_center_heading_typography_font',
    'choices'  => $health_care_center_fonts,
) );