<?php
/**
* Custom Functions.
*
* @package Health Care Center
*/

if( !function_exists( 'health_care_center_sanitize_sidebar_option' ) ) :

    // Sidebar Option Sanitize.
    function health_care_center_sanitize_sidebar_option( $health_care_center_input ){

        $health_care_center_metabox_options = array( 'global-sidebar','left-sidebar','right-sidebar','no-sidebar' );
        if( in_array( $health_care_center_input,$health_care_center_metabox_options ) ){

            return $health_care_center_input;

        }

        return;

    }

endif;

if ( ! function_exists( 'health_care_center_sanitize_checkbox' ) ) :

	/**
	 * Sanitize checkbox.
	 */
	function health_care_center_sanitize_checkbox( $health_care_center_checked ) {

		return ( ( isset( $health_care_center_checked ) && true === $health_care_center_checked ) ? true : false );

	}

endif;


if ( ! function_exists( 'health_care_center_sanitize_select' ) ) :

    /**
     * Sanitize select.
     */
    function health_care_center_sanitize_select( $health_care_center_input, $health_care_center_setting ) {
        $health_care_center_input = sanitize_text_field( $health_care_center_input );
        $choices = $health_care_center_setting->manager->get_control( $health_care_center_setting->id )->choices;
        return ( array_key_exists( $health_care_center_input, $choices ) ? $health_care_center_input : $health_care_center_setting->default );
    }

endif;