<?php
/**
* Posts Settings.
*
* @package Health Care Center
*/

$health_care_center_default = health_care_center_get_default_theme_options();

// Single Post Section.
$wp_customize->add_section( 'health_care_center_single_posts_settings',
    array(
    'title'      => esc_html__( 'Single Meta Information Settings', 'health-care-center' ),
    'priority'   => 35,
    'capability' => 'edit_theme_options',
    'panel'      => 'health_care_center_theme_option_panel',
    )
);

$wp_customize->add_setting('health_care_center_display_single_post_image',
    array(
        'default' => $health_care_center_default['health_care_center_display_single_post_image'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_display_single_post_image',
    array(
        'label' => esc_html__('Enable Single Posts Image', 'health-care-center'),
        'section' => 'health_care_center_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('health_care_center_post_author',
    array(
        'default' => $health_care_center_default['health_care_center_post_author'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_post_author',
    array(
        'label' => esc_html__('Enable Posts Author', 'health-care-center'),
        'section' => 'health_care_center_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('health_care_center_post_date',
    array(
        'default' => $health_care_center_default['health_care_center_post_date'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_post_date',
    array(
        'label' => esc_html__('Enable Posts Date', 'health-care-center'),
        'section' => 'health_care_center_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('health_care_center_post_category',
    array(
        'default' => $health_care_center_default['health_care_center_post_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_post_category',
    array(
        'label' => esc_html__('Enable Posts Category', 'health-care-center'),
        'section' => 'health_care_center_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('health_care_center_post_tags',
    array(
        'default' => $health_care_center_default['health_care_center_post_tags'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_post_tags',
    array(
        'label' => esc_html__('Enable Posts Tags', 'health-care-center'),
        'section' => 'health_care_center_single_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'health_care_center_single_page_content_alignment',
    array(
    'default'           => $health_care_center_default['health_care_center_single_page_content_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_sanitize_page_content_alignment',
    )
);
$wp_customize->add_control( 'health_care_center_single_page_content_alignment',
    array(
    'label'       => esc_html__( 'Single Page Content Alignment', 'health-care-center' ),
    'section'     => 'health_care_center_single_posts_settings',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'health-care-center' ),
        'center'  => esc_html__( 'Center', 'health-care-center' ),
        'right'    => esc_html__( 'Right', 'health-care-center' ),
        ),
    )
);

$wp_customize->add_setting( 'health_care_center_single_post_content_alignment',
    array(
    'default'           => $health_care_center_default['health_care_center_single_post_content_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_sanitize_page_content_alignment',
    )
);
$wp_customize->add_control( 'health_care_center_single_post_content_alignment',
    array(
    'label'       => esc_html__( 'Single Post Content Alignment', 'health-care-center' ),
    'section'     => 'health_care_center_single_posts_settings',
    'type'        => 'select',
    'choices'     => array(
        'left' => esc_html__( 'Left', 'health-care-center' ),
        'center'  => esc_html__( 'Center', 'health-care-center' ),
        'right'    => esc_html__( 'Right', 'health-care-center' ),
        ),
    )
);

// Archive Post Section.
$wp_customize->add_section( 'health_care_center_posts_settings',
    array(
    'title'      => esc_html__( 'Archive Meta Information Settings', 'health-care-center' ),
    'priority'   => 36,
    'capability' => 'edit_theme_options',
    'panel'      => 'health_care_center_theme_option_panel',
    )
);

$wp_customize->add_setting('health_care_center_display_archive_post_format_icon',
    array(
        'default' => $health_care_center_default['health_care_center_display_archive_post_format_icon'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_display_archive_post_format_icon',
    array(
        'label' => esc_html__('Enable Posts Format Icon', 'health-care-center'),
        'section' => 'health_care_center_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('health_care_center_display_archive_post_image',
    array(
        'default' => $health_care_center_default['health_care_center_display_archive_post_image'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_display_archive_post_image',
    array(
        'label' => esc_html__('Enable Posts Image', 'health-care-center'),
        'section' => 'health_care_center_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('health_care_center_display_archive_post_category',
    array(
        'default' => $health_care_center_default['health_care_center_display_archive_post_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_display_archive_post_category',
    array(
        'label' => esc_html__('Enable Posts Category', 'health-care-center'),
        'section' => 'health_care_center_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('health_care_center_display_archive_post_title',
    array(
        'default' => $health_care_center_default['health_care_center_display_archive_post_title'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_display_archive_post_title',
    array(
        'label' => esc_html__('Enable Posts Title', 'health-care-center'),
        'section' => 'health_care_center_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('health_care_center_display_archive_post_content',
    array(
        'default' => $health_care_center_default['health_care_center_display_archive_post_content'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_display_archive_post_content',
    array(
        'label' => esc_html__('Enable Posts Content', 'health-care-center'),
        'section' => 'health_care_center_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('health_care_center_display_archive_post_button',
    array(
        'default' => $health_care_center_default['health_care_center_display_archive_post_button'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_display_archive_post_button',
    array(
        'label' => esc_html__('Enable Posts Button', 'health-care-center'),
        'section' => 'health_care_center_posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('health_care_center_excerpt_limit',
    array(
        'default'           => $health_care_center_default['health_care_center_excerpt_limit'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_number_range',
    )
);
$wp_customize->add_control('health_care_center_excerpt_limit',
    array(
        'label'       => esc_html__('Blog Posts Excerpt limit', 'health-care-center'),
        'section'     => 'health_care_center_posts_settings',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 100,
           'step'   => 1,
        ),
    )
);

$wp_customize->add_setting( 'health_care_center_archive_image_size',
	array(
	'default'           => 'medium',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'health_care_center_sanitize_select',
	)
);
$wp_customize->add_control( 'health_care_center_archive_image_size',
	array(
	'label'       => esc_html__( 'Blog Posts Image Size', 'health-care-center' ),
	'section'     => 'health_care_center_posts_settings',
	'type'        => 'select',
	'choices'               => array(
		'full' => esc_html__( 'Large Size Image', 'health-care-center' ),
		'large' => esc_html__( 'Big Size Image', 'health-care-center' ),
		'medium' => esc_html__( 'Medium Size Image', 'health-care-center' ),
		'small' => esc_html__( 'Small Size Image', 'health-care-center' ),
		'xsmall' => esc_html__( 'Extra Small Size Image', 'health-care-center' ),
		'thumbnail' => esc_html__( 'Thumbnail Size Image', 'health-care-center' ),
	    ),
	)
);

$wp_customize->add_setting('health_care_center_posts_per_columns',
    array(
    'default'           => '3',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_sanitize_number_range',
    )
);
$wp_customize->add_control('health_care_center_posts_per_columns',
    array(
    'label'       => esc_html__('Blog Posts Per Column', 'health-care-center'),
    'section'     => 'health_care_center_posts_settings',
    'type'        => 'number',
    'input_attrs' => array(
    'min'   => 1,
    'max'   => 5,
    'step'   => 1,
    ),
    )
);