<?php
/**
* Noting Found Page Settings.
*
* @package Health Care Center
*/

$health_care_center_default = health_care_center_get_default_theme_options();

$wp_customize->add_section( 'health_care_center_noting_found_page_settings',
    array(
        'title'      => esc_html__( 'Noting Found Page Settings', 'health-care-center' ),
        'priority'   => 200,
        'capability' => 'edit_theme_options',
        'panel'      => 'health_care_center_theme_addons_panel',
    )
);

$wp_customize->add_setting( 'health_care_center_noting_found_main_title',
    array(
        'default'           => 'Nothing Found',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_noting_found_main_title',
    array(
        'label'    => esc_html__( 'Main Title', 'health-care-center' ),
        'section'  => 'health_care_center_noting_found_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_noting_found_para',
    array(
        'default'           => 'Sorry, but nothing matched your search terms. Please try again with some different keywords.',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_noting_found_para',
    array(
        'label'    => esc_html__( 'Para Text', 'health-care-center' ),
        'section'  => 'health_care_center_noting_found_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting('health_care_center_noting_found_saerch',
    array(
        'default' => 1,
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_noting_found_saerch',
    array(
        'label' => esc_html__('Enable/Disable Search', 'health-care-center'),
        'section' => 'health_care_center_noting_found_page_settings',
        'type' => 'checkbox',
    )
);