<?php
/**
* Layouts Settings.
*
* @package Health Care Center
*/

$health_care_center_default = health_care_center_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'health_care_center_layout_setting',
	array(
	'title'      => esc_html__( 'Sidebar Settings', 'health-care-center' ),
	'priority'   => 20,
	'capability' => 'edit_theme_options',
	'panel'      => 'health_care_center_theme_option_panel',
	)
);

$wp_customize->add_setting( 'health_care_center_global_sidebar_layout',
    array(
    'default'           => $health_care_center_default['health_care_center_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_sanitize_sidebar_option',
    )
);
$wp_customize->add_control( 'health_care_center_global_sidebar_layout',
    array(
    'label'       => esc_html__( 'Global Sidebar Layout', 'health-care-center' ),
    'section'     => 'health_care_center_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__( 'Right Sidebar', 'health-care-center' ),
        'left-sidebar'  => esc_html__( 'Left Sidebar', 'health-care-center' ),
        'no-sidebar'    => esc_html__( 'No Sidebar', 'health-care-center' ),
        ),
    )
);

$wp_customize->add_setting('health_care_center_page_sidebar_layout', array(
    'default'           => $health_care_center_default['health_care_center_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_sanitize_sidebar_option',
));

$wp_customize->add_control('health_care_center_page_sidebar_layout', array(
    'label'       => esc_html__('Single Page Sidebar Layout', 'health-care-center'),
    'section'     => 'health_care_center_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__('Right Sidebar', 'health-care-center'),
        'left-sidebar'  => esc_html__('Left Sidebar', 'health-care-center'),
        'no-sidebar'    => esc_html__('No Sidebar', 'health-care-center'),
    ),
));

$wp_customize->add_setting('health_care_center_post_sidebar_layout', array(
    'default'           => $health_care_center_default['health_care_center_global_sidebar_layout'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_sanitize_sidebar_option',
));

$wp_customize->add_control('health_care_center_post_sidebar_layout', array(
    'label'       => esc_html__('Single Post Sidebar Layout', 'health-care-center'),
    'section'     => 'health_care_center_layout_setting',
    'type'        => 'select',
    'choices'     => array(
        'right-sidebar' => esc_html__('Right Sidebar', 'health-care-center'),
        'left-sidebar'  => esc_html__('Left Sidebar', 'health-care-center'),
        'no-sidebar'    => esc_html__('No Sidebar', 'health-care-center'),
    ),
));

$wp_customize->add_setting('health_care_center_sticky_sidebar',
    array(
        'default'           => true,
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_sticky_sidebar',
    array(
        'label' => esc_html__('Enable/Disable Sticky Sidebar', 'health-care-center'),
        'section' => 'health_care_center_layout_setting',
        'type' => 'checkbox',
    )
);