<?php
/**
* Header Banner Options.
*
* @package Health Care Center
*/

$health_care_center_default = health_care_center_get_default_theme_options();
$health_care_center_post_category_list = health_care_center_post_category_list();

$wp_customize->add_section( 'header_banner_setting',
    array(
    'title'      => esc_html__( 'Banner Settings', 'health-care-center' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'theme_home_pannel',
    )
);

// Show/Hide Site Logo
$wp_customize->add_setting('health_care_center_display_logo', array(
    'default'           => false,
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_sanitize_checkbox',
));
$wp_customize->add_control('health_care_center_display_logo', array(
    'label'    => esc_html__('Enable / Disable Site Logo', 'health-care-center'),
    'section'  => 'title_tagline',
    'type'     => 'checkbox',
));

// Show/Hide Site Title
$wp_customize->add_setting('health_care_center_display_title', array(
    'default'           => true,
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_sanitize_checkbox',
));
$wp_customize->add_control('health_care_center_display_title', array(
    'label'    => esc_html__('Enable / Disable Site Title', 'health-care-center'),
    'section'  => 'title_tagline',
    'type'     => 'checkbox',
));

// Show/Hide Site Tagline
$wp_customize->add_setting('health_care_center_display_header_text',
    array(
        'default'           => false,
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_display_header_text',
    array(
        'label' => esc_html__('Enable / Disable Site Tagline', 'health-care-center'),
        'section' => 'title_tagline',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('health_care_center_header_slider',
    array(
        'default' => $health_care_center_default['health_care_center_header_slider'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_header_slider',
    array(
        'label' => esc_html__('Enable Banner', 'health-care-center'),
        'section' => 'header_banner_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('health_care_center_banner_background_image',
    array(
        'default' => $health_care_center_default['health_care_center_banner_background_image'],
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'health_care_center_banner_background_image',
        array(
            'label' => __('Banner Background Image','health-care-center'),
            'section' => 'header_banner_setting',
            'settings' => 'health_care_center_banner_background_image',
        )
    )
);

$wp_customize->add_setting( 'health_care_center_banner_short_heading',
    array(
    'default'           => $health_care_center_default['health_care_center_banner_short_heading'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_banner_short_heading',
    array(
    'label'    => esc_html__( 'Banner Short Heading ', 'health-care-center' ),
    'section'  => 'header_banner_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_banner_heading',
    array(
    'default'           => $health_care_center_default['health_care_center_banner_heading'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_banner_heading',
    array(
    'label'    => esc_html__( 'Banner Heading ', 'health-care-center' ),
    'section'  => 'header_banner_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_banner_content',
    array(
    'default'           => $health_care_center_default['health_care_center_banner_content'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_banner_content',
    array(
    'label'    => esc_html__( 'Banner Content ', 'health-care-center' ),
    'section'  => 'header_banner_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_banner_button_text',
    array(
    'default'           => $health_care_center_default['health_care_center_banner_button_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_banner_button_text',
    array(
    'label'    => esc_html__( 'Banner Button Text ', 'health-care-center' ),
    'section'  => 'header_banner_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_banner_button_url',
    array(
    'default'           => $health_care_center_default['health_care_center_banner_button_url'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_banner_button_url',
    array(
    'label'    => esc_html__( 'Banner Button Url ', 'health-care-center' ),
    'section'  => 'header_banner_setting',
    'type'     => 'url',
    )
);

$wp_customize->add_setting( 'health_care_center_banner_rating_number',
    array(
    'default'           => $health_care_center_default['health_care_center_banner_rating_number'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_banner_rating_number',
    array(
    'label'    => esc_html__( 'Banner Rating Number ', 'health-care-center' ),
    'section'  => 'header_banner_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_banner_rating_text',
    array(
    'default'           => $health_care_center_default['health_care_center_banner_rating_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_banner_rating_text',
    array(
    'label'    => esc_html__( 'Banner Rating Text ', 'health-care-center' ),
    'section'  => 'header_banner_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting('health_care_center_banner_team_image_1',
    array(
        'default' => $health_care_center_default['health_care_center_banner_team_image_1'],
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'health_care_center_banner_team_image_1',
        array(
            'label' => __('Testimonial Image 1','health-care-center'),
            'section' => 'header_banner_setting',
            'settings' => 'health_care_center_banner_team_image_1',
        )
    )
);

$wp_customize->add_setting('health_care_center_banner_team_image_2',
    array(
        'default' => $health_care_center_default['health_care_center_banner_team_image_2'],
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'health_care_center_banner_team_image_2',
        array(
            'label' => __('Testimonial Image 2','health-care-center'),
            'section' => 'header_banner_setting',
            'settings' => 'health_care_center_banner_team_image_2',
        )
    )
);

$wp_customize->add_setting('health_care_center_banner_team_image_3',
    array(
        'default' => $health_care_center_default['health_care_center_banner_team_image_3'],
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'health_care_center_banner_team_image_3',
        array(
            'label' => __('Testimonial Image 3','health-care-center'),
            'section' => 'header_banner_setting',
            'settings' => 'health_care_center_banner_team_image_3',
        )
    )
);

$wp_customize->add_setting('health_care_center_banner_team_image_4',
    array(
        'default' => $health_care_center_default['health_care_center_banner_team_image_4'],
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'health_care_center_banner_team_image_4',
        array(
            'label' => __('Testimonial Image 4','health-care-center'),
            'section' => 'header_banner_setting',
            'settings' => 'health_care_center_banner_team_image_4',
        )
    )
);

// About Us Setting

$wp_customize->add_section( 'product_column_setting',
    array(
    'title'      => esc_html__( 'About Us Setting', 'health-care-center' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'theme_home_pannel',
    )
);

$wp_customize->add_setting('health_care_center_about_us_image_1',
    array(
        'default' => $health_care_center_default['health_care_center_about_us_image_1'],
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'health_care_center_about_us_image_1',
        array(
            'label' => __('About Us Image 1','health-care-center'),
            'section' => 'product_column_setting',
            'settings' => 'health_care_center_about_us_image_1',
        )
    )
);

$wp_customize->add_setting('health_care_center_about_us_image_2',
    array(
        'default' => $health_care_center_default['health_care_center_about_us_image_2'],
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'health_care_center_about_us_image_2',
        array(
            'label' => __('About Us Image 2','health-care-center'),
            'section' => 'product_column_setting',
            'settings' => 'health_care_center_about_us_image_2',
        )
    )
);

$wp_customize->add_setting('health_care_center_about_us_image_3',
    array(
        'default' => $health_care_center_default['health_care_center_about_us_image_3'],
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'health_care_center_about_us_image_3',
        array(
            'label' => __('About Us Image 3','health-care-center'),
            'section' => 'product_column_setting',
            'settings' => 'health_care_center_about_us_image_3',
        )
    )
);

$wp_customize->add_setting( 'health_care_center_about_us_section_short_title',
    array(
    'default'           => $health_care_center_default['health_care_center_about_us_section_short_title'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_about_us_section_short_title',
    array(
    'label'    => esc_html__( 'About Us Short Heading ', 'health-care-center' ),
    'section'  => 'product_column_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_about_us_section_title',
    array(
    'default'           => $health_care_center_default['health_care_center_about_us_section_title'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_about_us_section_title',
    array(
    'label'    => esc_html__( 'About Us Heading ', 'health-care-center' ),
    'section'  => 'product_column_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_team_section_subtitle',
    array(
    'default'           => $health_care_center_default['health_care_center_team_section_subtitle'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_team_section_subtitle',
    array(
    'label'    => esc_html__( 'About Us Content ', 'health-care-center' ),
    'section'  => 'product_column_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_about_us_list_text_1',
    array(
    'default'           => $health_care_center_default['health_care_center_about_us_list_text_1'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_about_us_list_text_1',
    array(
    'label'    => esc_html__( 'About Us List 1 ', 'health-care-center' ),
    'section'  => 'product_column_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_about_us_list_text_2',
    array(
    'default'           => $health_care_center_default['health_care_center_about_us_list_text_2'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_about_us_list_text_2',
    array(
    'label'    => esc_html__( 'About Us List 2 ', 'health-care-center' ),
    'section'  => 'product_column_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_about_us_list_text_3',
    array(
    'default'           => $health_care_center_default['health_care_center_about_us_list_text_3'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_about_us_list_text_3',
    array(
    'label'    => esc_html__( 'About Us List 3 ', 'health-care-center' ),
    'section'  => 'product_column_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_team_section_button_text',
    array(
    'default'           => $health_care_center_default['health_care_center_team_section_button_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_team_section_button_text',
    array(
    'label'    => esc_html__( 'About Us Button Text ', 'health-care-center' ),
    'section'  => 'product_column_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_team_section_button_url',
    array(
    'default'           => $health_care_center_default['health_care_center_team_section_button_url'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_team_section_button_url',
    array(
    'label'    => esc_html__( 'About Us Button Url ', 'health-care-center' ),
    'section'  => 'product_column_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting('health_care_center_about_doctor_image',
    array(
        'default' => $health_care_center_default['health_care_center_about_doctor_image'],
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control( $wp_customize,'health_care_center_about_doctor_image',
        array(
            'label' => __('About Doctor Image','health-care-center'),
            'section' => 'product_column_setting',
            'settings' => 'health_care_center_about_doctor_image',
        )
    )
);

$wp_customize->add_setting( 'health_care_center_about_doctor_name',
    array(
    'default'           => $health_care_center_default['health_care_center_about_doctor_name'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_about_doctor_name',
    array(
    'label'    => esc_html__( 'About Doctor Name ', 'health-care-center' ),
    'section'  => 'product_column_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_about_doctor_designation',
    array(
    'default'           => $health_care_center_default['health_care_center_about_doctor_designation'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_about_doctor_designation',
    array(
    'label'    => esc_html__( 'About Doctor Designation ', 'health-care-center' ),
    'section'  => 'product_column_setting',
    'type'     => 'text',
    )
);