<?php
/**
* Header Options.
*
* @package Health Care Center
*/

$health_care_center_default = health_care_center_get_default_theme_options();

// Header Section.
$wp_customize->add_section( 'health_care_center_button_header_setting',
	array(
	'title'      => esc_html__( 'Header Settings', 'health-care-center' ),
	'priority'   => 10,
	'capability' => 'edit_theme_options',
	'panel'      => 'health_care_center_theme_option_panel',
	)
);

$wp_customize->add_setting('health_care_center_menu_font_size',
    array(
        'default'           => $health_care_center_default['health_care_center_menu_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_number_range',
    )
);
$wp_customize->add_control('health_care_center_menu_font_size',
    array(
        'label'       => esc_html__('Menu Font Size', 'health-care-center'),
        'section'     => 'health_care_center_button_header_setting',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 30,
           'step'   => 1,
        ),
    )
);

$wp_customize->add_setting( 'health_care_center_menu_text_transform',
    array(
    'default'           => $health_care_center_default['health_care_center_menu_text_transform'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_sanitize_menu_transform',
    )
);
$wp_customize->add_control( 'health_care_center_menu_text_transform',
    array(
    'label'       => esc_html__( 'Menu Text Transform', 'health-care-center' ),
    'section'     => 'health_care_center_button_header_setting',
    'type'        => 'select',
    'choices'     => array(
        'capitalize' => esc_html__( 'Capitalize', 'health-care-center' ),
        'uppercase'  => esc_html__( 'Uppercase', 'health-care-center' ),
        'lowercase'    => esc_html__( 'Lowercase', 'health-care-center' ),
        ),
    )
);

$wp_customize->add_setting('health_care_center_header_menus_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'health_care_center_header_menus_color', array(
    'label'    => __('Main Menu Color', 'health-care-center'),
    'section'  => 'health_care_center_button_header_setting',
)));

$wp_customize->add_setting('health_care_center_header_menus_hover_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'health_care_center_header_menus_hover_color', array(
    'label'    => __('Main Menu Hover Color', 'health-care-center'),
    'section'  => 'health_care_center_button_header_setting',
)));

$wp_customize->add_setting('health_care_center_header_submenus_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'health_care_center_header_submenus_color', array(
    'label'    => __('Submenu Color', 'health-care-center'),
    'section'  => 'health_care_center_button_header_setting',
)));

$wp_customize->add_setting('health_care_center_header_submenus_hover_color', array(
    'default'           => '',
    'sanitize_callback' => 'sanitize_hex_color',
));
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'health_care_center_header_submenus_hover_color', array(
    'label'    => __('Submenu Hover Color', 'health-care-center'),
    'section'  => 'health_care_center_button_header_setting',
)));


$wp_customize->add_setting('health_care_center_sticky',
    array(
        'default' => $health_care_center_default['health_care_center_sticky'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_sticky',
    array(
        'label' => esc_html__('Enable Sticky Header', 'health-care-center'),
        'section' => 'health_care_center_button_header_setting',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'health_care_center_header_phone_number',
    array(
    'default'           => $health_care_center_default['health_care_center_header_phone_number'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_header_phone_number',
    array(
    'label'    => esc_html__( 'Header Phone Number', 'health-care-center' ),
    'section'  => 'health_care_center_button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_header_text',
    array(
    'default'           => $health_care_center_default['health_care_center_header_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_header_text',
    array(
    'label'    => esc_html__( 'Header Text', 'health-care-center' ),
    'section'  => 'health_care_center_button_header_setting',
    'type'     => 'text',
    )
);
