<?php
/**
* Global Color Settings.
*
* @package Health Care Center
*/

$health_care_center_default = health_care_center_get_default_theme_options();

// Layout Section.
$wp_customize->add_section( 'health_care_center_global_color_setting',
	array(
	'title'      => esc_html__( 'Global Color Settings', 'health-care-center' ),
	'priority'   => 21,
	'capability' => 'edit_theme_options',
	'panel'      => 'health_care_center_theme_option_panel',
	)
);

$wp_customize->add_setting( 'health_care_center_global_color',
    array(
    'default'           => '#1B75BB',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_hex_color',
    )
);
$wp_customize->add_control( 
    new WP_Customize_Color_Control( 
    $wp_customize, 
    'health_care_center_global_color',
    array(
        'label'      => esc_html__( 'Global Color', 'health-care-center' ),
        'section'    => 'health_care_center_global_color_setting',
        'settings'   => 'health_care_center_global_color',
    ) ) 
);