<?php
/**
* Footer Settings.
*
* @package Health Care Center
*/

$health_care_center_default = health_care_center_get_default_theme_options();

$wp_customize->add_section( 'health_care_center_footer_widget_area',
	array(
	'title'      => esc_html__( 'Footer Settings', 'health-care-center' ),
	'priority'   => 200,
	'capability' => 'edit_theme_options',
	'panel'      => 'health_care_center_theme_option_panel',
	)
);

$wp_customize->add_setting('health_care_center_display_footer',
    array(
        'default' => $health_care_center_default['health_care_center_display_footer'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_display_footer',
    array(
        'label' => esc_html__('Enable Footer', 'health-care-center'),
        'section' => 'health_care_center_footer_widget_area',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'health_care_center_footer_column_layout',
	array(
	'default'           => $health_care_center_default['health_care_center_footer_column_layout'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'health_care_center_sanitize_select',
	)
);
$wp_customize->add_control( 'health_care_center_footer_column_layout',
	array(
	'label'       => esc_html__( 'Footer Column Layout', 'health-care-center' ),
	'section'     => 'health_care_center_footer_widget_area',
	'type'        => 'select',
	'choices'               => array(
		'1' => esc_html__( 'One Column', 'health-care-center' ),
		'2' => esc_html__( 'Two Column', 'health-care-center' ),
		'3' => esc_html__( 'Three Column', 'health-care-center' ),
	    ),
	)
);

$wp_customize->add_setting( 'health_care_center_footer_copyright_text',
	array(
	'default'           => $health_care_center_default['health_care_center_footer_copyright_text'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'health_care_center_footer_copyright_text',
	array(
	'label'    => esc_html__( 'Footer Copyright Text', 'health-care-center' ),
	'section'  => 'health_care_center_footer_widget_area',
	'type'     => 'text',
	)
);

$wp_customize->add_setting('health_care_center_copyright_font_size',
    array(
        'default'           => $health_care_center_default['health_care_center_copyright_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_number_range',
    )
);
$wp_customize->add_control('health_care_center_copyright_font_size',
    array(
        'label'       => esc_html__('Copyright Font Size', 'health-care-center'),
        'section'     => 'health_care_center_footer_widget_area',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 5,
           'max'   => 30,
           'step'   => 1,
    	),
    )
);

$wp_customize->add_setting( 'health_care_center_copyright_alignment', array(
    'default'           => 'Default',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_sanitize_copyright_alignment_meta',
) );

$wp_customize->add_control( 'health_care_center_copyright_alignment', array(
    'label'    => esc_html__( 'Copyright Section Alignment', 'health-care-center' ),
    'section'  => 'health_care_center_footer_widget_area',
    'type'     => 'select',
    'choices'  => array(
        'Default' => esc_html__( 'Default View', 'health-care-center' ),
        'Reverse' => esc_html__( 'Reverse View', 'health-care-center' ),
        'Center'  => esc_html__( 'Centered Content', 'health-care-center' ),
    ),
) );

$wp_customize->add_setting( 'health_care_center_footer_widget_background_color', array(
    'default' => '',
    'sanitize_callback' => 'sanitize_hex_color'
));
$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'health_care_center_footer_widget_background_color', array(
    'label'     => __('Footer Widget Background Color', 'health-care-center'),
    'description' => __('It will change the complete footer widget background color.', 'health-care-center'),
    'section' => 'health_care_center_footer_widget_area',
    'settings' => 'health_care_center_footer_widget_background_color',
)));

$wp_customize->add_setting('health_care_center_footer_widget_background_image',array(
    'default'   => '',
    'sanitize_callback' => 'esc_url_raw',
));
$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'health_care_center_footer_widget_background_image',array(
    'label' => __('Footer Widget Background Image','health-care-center'),
    'section' => 'health_care_center_footer_widget_area'
)));

$wp_customize->add_setting( 'health_care_center_footer_widget_title_alignment',
        array(
        'default'           => $health_care_center_default['health_care_center_footer_widget_title_alignment'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_footer_widget_title_alignment',
        )
    );
    $wp_customize->add_control( 'health_care_center_footer_widget_title_alignment',
        array(
        'label'       => esc_html__( 'Footer Widget Title Alignment', 'health-care-center' ),
        'section'     => 'health_care_center_footer_widget_area',
        'type'        => 'select',
        'choices'     => array(
            'left' => esc_html__( 'Left', 'health-care-center' ),
            'center'  => esc_html__( 'Center', 'health-care-center' ),
            'right'    => esc_html__( 'Right', 'health-care-center' ),
            ),
        )
    );

$wp_customize->add_setting('health_care_center_enable_to_the_top',
    array(
        'default' => $health_care_center_default['health_care_center_enable_to_the_top'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_enable_to_the_top',
    array(
        'label' => esc_html__('Enable To The Top', 'health-care-center'),
        'section' => 'health_care_center_footer_widget_area',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'health_care_center_to_the_top_text',
    array(
    'default'           => $health_care_center_default['health_care_center_to_the_top_text'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_to_the_top_text',
    array(
    'label'    => esc_html__( 'Edit Text Here', 'health-care-center' ),
    'section'  => 'health_care_center_footer_widget_area',
    'type'     => 'text',
    )
);