<?php
/**
 * Default Values.
 *
 * @package Health Care Center
 */

if ( ! function_exists( 'health_care_center_get_default_theme_options' ) ) :
	function health_care_center_get_default_theme_options() {

		$health_care_center_defaults = array();
		
        // Options.
        $health_care_center_defaults['health_care_center_logo_width_range']  = 200;
        $health_care_center_defaults['health_care_center_global_sidebar_layout'] = 'right-sidebar';
        $health_care_center_defaults['health_care_center_header_search'] = 0;
        $health_care_center_defaults['health_care_center_display_header_toggle'] = 0;
        $health_care_center_defaults['health_care_center_theme_pagination_options_alignment'] = 'Center';
        $health_care_center_defaults['health_care_center_theme_breadcrumb_options_alignment'] = 'Left';
        $health_care_center_defaults['health_care_center_pagination_layout'] = 'numeric';
        $health_care_center_defaults['health_care_center_menu_text_transform'] = 'Capitalize';
        $health_care_center_defaults['health_care_center_single_post_content_alignment'] = 'left';
        $health_care_center_defaults['health_care_center_single_page_content_alignment'] = 'left';
        $health_care_center_defaults['health_care_center_footer_column_layout'] = 3;
        $health_care_center_defaults['health_care_center_menu_font_size'] = 16;
        $health_care_center_defaults['health_care_center_copyright_font_size'] = 16;
        $health_care_center_defaults['health_care_center_breadcrumb_font_size'] = 16;
        $health_care_center_defaults['health_care_center_excerpt_limit'] = 20;
        $health_care_center_defaults['health_care_center_per_columns'] = 3;
        $health_care_center_defaults['health_care_center_product_per_page'] = 9;
        $health_care_center_defaults['health_care_center_custom_related_products_number'] = 6;
        $health_care_center_defaults['health_care_center_custom_related_products_number_per_row'] = 3;
        $health_care_center_defaults['health_care_center_footer_copyright_text'] = esc_html__( 'All rights reserved.', 'health-care-center' );
        $health_care_center_defaults['twp_navigation_type'] = 'theme-normal-navigation';
        $health_care_center_defaults['health_care_center_post_author'] = 1;
        $health_care_center_defaults['health_care_center_post_date'] = 1;
        $health_care_center_defaults['health_care_center_post_category'] = 1;
        $health_care_center_defaults['health_care_center_post_tags'] = 1;
        $health_care_center_defaults['health_care_center_floating_next_previous_nav'] = 1;
        $health_care_center_defaults['health_care_center_category_section'] = 0;
        $health_care_center_defaults['health_care_center_courses_category_section'] = 0;
        $health_care_center_defaults['health_care_center_sticky'] = 0;
        $health_care_center_defaults['health_care_center_background_color'] = '#fff';
        $health_care_center_defaults['health_care_center_show_hide_related_product']                      = 1;
        $health_care_center_defaults['health_care_center_display_footer']                                 = 1;
        $health_care_center_defaults['health_care_center_global_color']                                   = '#1B75BB';
        $health_care_center_defaults['health_care_center_display_archive_post_category']          = 1;
        $health_care_center_defaults['health_care_center_display_archive_post_title']             = 1;
        $health_care_center_defaults['health_care_center_display_archive_post_content']           = 1;
        $health_care_center_defaults['health_care_center_display_archive_post_image']             = 1;
        $health_care_center_defaults['health_care_center_display_archive_post_button']            = 1;
        $health_care_center_defaults['health_care_center_theme_loader']                                       = 0;
        $health_care_center_defaults['health_care_center_theme_breadcrumb_enable']                            = 1;

        $health_care_center_defaults['health_care_center_enable_to_the_top']                              = 1;
        $health_care_center_defaults['health_care_center_to_the_top_text']                                = esc_html__( 'To The Top', 'health-care-center' );

        //Header Top 
        $health_care_center_defaults['health_care_center_header_phone_number']                    = esc_html__( '+(0321) 752 8659', 'health-care-center' );
        $health_care_center_defaults['health_care_center_header_text']                            = esc_html__( 'Freebies on orders above ₹499', 'health-care-center' );
        $health_care_center_defaults['health_care_center_footer_widget_title_alignment']                 = 'left'; 

        $health_care_center_defaults['health_care_center_banner_team_image_1']                    = esc_url(get_template_directory_uri() . '/assets/images/user-1.png');
        $health_care_center_defaults['health_care_center_banner_team_image_2']                    = esc_url(get_template_directory_uri() . '/assets/images/user-2.png');
        $health_care_center_defaults['health_care_center_banner_team_image_3']                    = esc_url(get_template_directory_uri() . '/assets/images/user-3.png');
        $health_care_center_defaults['health_care_center_banner_team_image_4']                    = esc_url(get_template_directory_uri() . '/assets/images/user-4.png');

        // Social Icon
        $health_care_center_defaults['health_care_center_header_layout_facebook_link']            = esc_url( '#', 'health-care-center' );
        $health_care_center_defaults['health_care_center_header_layout_twitter_link']             = esc_url( '#', 'health-care-center' );
        $health_care_center_defaults['health_care_center_header_layout_pintrest_link']            = esc_url( '#', 'health-care-center' );
        $health_care_center_defaults['health_care_center_header_layout_instagram_link']           = esc_url( '#', 'health-care-center' );
        $health_care_center_defaults['health_care_center_header_layout_youtube_link']             = esc_url( '#', 'health-care-center' );

        //slider
        $health_care_center_defaults['health_care_center_header_slider']                          = 1;
        $health_care_center_defaults['health_care_center_banner_short_heading']                   = esc_html__( 'Your Journey to Healing', 'health-care-center' );
        $health_care_center_defaults['health_care_center_banner_heading']                         = esc_html__( 'Bringing you the best health care ', 'health-care-center' );
        $health_care_center_defaults['health_care_center_banner_content']                         = esc_html__( 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', 'health-care-center' );
        $health_care_center_defaults['health_care_center_banner_button_text']                     = esc_html__( 'Let’s Get Started', 'health-care-center' );
        $health_care_center_defaults['health_care_center_banner_button_url']                      = esc_url( '#', 'health-care-center' );
        
        $health_care_center_defaults['health_care_center_banner_rating_number']                   = esc_html__( '3.5k Plus', 'health-care-center' );
        $health_care_center_defaults['health_care_center_banner_rating_text']                     = esc_html__( 'Satisfied Patients', 'health-care-center' );
        
        $health_care_center_defaults['health_care_center_banner_background_image']                = esc_url(get_template_directory_uri() . '/assets/images/slider-main.png');

        // Courses Section
        $health_care_center_defaults['health_care_center_locations_post']                            = 1;
        $health_care_center_defaults['health_care_center_about_us_image_1']                       = esc_url(get_template_directory_uri() . '/assets/images/about-1.png');
        $health_care_center_defaults['health_care_center_about_us_image_2']                       = esc_url(get_template_directory_uri() . '/assets/images/about-2.png');
        $health_care_center_defaults['health_care_center_about_us_image_3']                       = esc_url(get_template_directory_uri() . '/assets/images/about-3.png');

        $health_care_center_defaults['health_care_center_about_us_section_short_title']           = esc_html__( 'About Us ', 'health-care-center' );
        $health_care_center_defaults['health_care_center_about_us_section_title']                 = esc_html__( 'Start your healthy life to day with us', 'health-care-center' );
        $health_care_center_defaults['health_care_center_team_section_subtitle']                  = esc_html__( 'Lorem Ipsum is simply dummy text of the printing and type setting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.', 'health-care-center' );

        $health_care_center_defaults['health_care_center_about_us_list_text_1']                   = esc_html__( 'Get latest news in your inbox. Consectetur  elitadipiscing.', 'health-care-center' );
        $health_care_center_defaults['health_care_center_about_us_list_text_2']                   = esc_html__( 'eddo eusmod tempor incididunt utlabore edolore.', 'health-care-center' );
        $health_care_center_defaults['health_care_center_about_us_list_text_3']                   = esc_html__( 'tempor incididunt ut laboreet dolore magna aliqua.', 'health-care-center' );
        
        $health_care_center_defaults['health_care_center_team_section_button_text']               = esc_html__( 'Read More', 'health-care-center' );
        $health_care_center_defaults['health_care_center_team_section_button_url']                = esc_url( '#', 'health-care-center' );

        $health_care_center_defaults['health_care_center_about_doctor_image']                     = esc_url(get_template_directory_uri() . '/assets/images/doctor.png');

        $health_care_center_defaults['health_care_center_about_doctor_name']                      = esc_html__( 'Lily A. Wilson ', 'health-care-center' );
        $health_care_center_defaults['health_care_center_about_doctor_designation']               = esc_html__( 'Dermatology', 'health-care-center' );
        
        $health_care_center_defaults['health_care_center_display_single_post_image']            = 1;
        $health_care_center_defaults['health_care_center_display_archive_post_format_icon']       = 1;

        // 404 Page Defaults
        $health_care_center_defaults['health_care_center_404_main_title'] = esc_html__( 'Oops! That page can’t be found.', 'health-care-center' );
        $health_care_center_defaults['health_care_center_404_subtitle_one'] = esc_html__( 'Maybe it’s out there, somewhere...', 'health-care-center' );
        $health_care_center_defaults['health_care_center_404_para_one'] = esc_html__( 'You can always find insightful stories on our', 'health-care-center' );
        $health_care_center_defaults['health_care_center_404_subtitle_two'] = esc_html__( 'Still feeling lost? You’re not alone.', 'health-care-center' );
        $health_care_center_defaults['health_care_center_404_para_two'] = esc_html__( 'Enjoy these stories about getting lost, losing things, and finding what you never knew you were looking for.', 'health-care-center' );

    	// Pass through filter.
    	$health_care_center_defaults = apply_filters( 'health_care_center_filter_default_theme_options', $health_care_center_defaults );

		return $health_care_center_defaults;
	}
endif;
