<?php
/**
* Customizer Custom Classes.
* @package Health Care Center
*/

if ( ! function_exists( 'health_care_center_sanitize_number_range' ) ) :
    function health_care_center_sanitize_number_range( $health_care_center_input, $health_care_center_setting ) {
        $health_care_center_input = absint( $health_care_center_input );
        $health_care_center_atts = $health_care_center_setting->manager->get_control( $health_care_center_setting->id )->input_attrs;
        $health_care_center_min = ( isset( $health_care_center_atts['min'] ) ? $health_care_center_atts['min'] : $health_care_center_input );
        $health_care_center_max = ( isset( $health_care_center_atts['max'] ) ? $health_care_center_atts['max'] : $health_care_center_input );
        $health_care_center_step = ( isset( $health_care_center_atts['step'] ) ? $health_care_center_atts['step'] : 1 );
        return ( $health_care_center_min <= $health_care_center_input && $health_care_center_input <= $health_care_center_max && is_int( $health_care_center_input / $health_care_center_step ) ? $health_care_center_input : $health_care_center_setting->default );
    }
endif;

/**
 * Upsell customizer section.
 *
 * @since  1.0.0
 * @access public
 */
class Health_Care_Center_Customize_Section_Upsell extends WP_Customize_Section {

    /**
     * The type of customize section being rendered.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $type = 'upsell';

    /**
     * Custom button text to output.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $pro_text = '';

    /**
     * Custom pro button URL.
     *
     * @since  1.0.0
     * @access public
     * @var    string
     */
    public $pro_url = '';

    public $notice = '';
    public $nonotice = '';

    /**
     * Add custom parameters to pass to the JS via JSON.
     *
     * @since  1.0.0
     * @access public
     * @return void
     */
    public function json() {
        $json = parent::json();

        $json['pro_text'] = $this->pro_text;
        $json['pro_url']  = esc_url( $this->pro_url );
        $json['notice']  = esc_attr( $this->notice );
        $json['nonotice']  = esc_attr( $this->nonotice );

        return $json;
    }

    /**
     * Outputs the Underscore.js template.
     *
     * @since  1.0.0
     * @access public
     * @return void
     */
    protected function render_template() { ?>

        <li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }} cannot-expand">

            <# if ( data.notice ) { #>
                <h3 class="accordion-section-notice">
                    {{ data.title }}
                </h3>
            <# } #>

            <# if ( !data.notice ) { #>
                <h3 class="accordion-section-title">
                    {{ data.title }}

                    <# if ( data.pro_text && data.pro_url ) { #>
                        <a href="{{ data.pro_url }}" class="button button-secondary alignright" target="_blank">{{ data.pro_text }}</a>
                    <# } #>
                </h3>
            <# } #>
            
        </li>
    <?php }
}