<?php
/**
* Custom Addons.
*
* @package Health Care Center
*/

$wp_customize->add_section( 'health_care_center_theme_pagination_options',
    array(
    'title'      => esc_html__( 'Customizer Custom Settings', 'health-care-center' ),
    'priority'   => 10,
    'capability' => 'edit_theme_options',
    'panel'      => 'health_care_center_theme_addons_panel',
    )
);

$wp_customize->add_setting('health_care_center_theme_loader',
    array(
        'default' => $health_care_center_default['health_care_center_theme_loader'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
);
$wp_customize->add_control('health_care_center_theme_loader',
    array(
        'label' => esc_html__('Enable Preloader', 'health-care-center'),
        'section' => 'health_care_center_theme_pagination_options',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting( 'health_care_center_enable_pagination', 
    array(
        'default'           => true,
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_enable_pagination',
    )
);

$wp_customize->add_control( 'health_care_center_enable_pagination', 
    array(
        'label'    => esc_html__( 'Enable Pagination', 'health-care-center' ),
        'section'  => 'health_care_center_theme_pagination_options',
        'type'     => 'checkbox',
    )
);

$wp_customize->add_setting( 'health_care_center_theme_pagination_type', 
    array(
        'default'           => 'numeric',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_pagination_type',
    )
);

$wp_customize->add_control( 'health_care_center_theme_pagination_type',
    array(
        'label'       => esc_html__( 'Pagination Style', 'health-care-center' ),
        'section'     => 'health_care_center_theme_pagination_options',
        'type'        => 'select',
        'choices'     => array(
            'numeric'      => esc_html__( 'Numeric (Page Numbers)', 'health-care-center' ),
            'newer_older'  => esc_html__( 'Newer/Older (Previous/Next)', 'health-care-center' ),
        ),
    )
);

$wp_customize->add_setting( 'health_care_center_theme_pagination_options_alignment',
    array(
    'default'           => $health_care_center_default['health_care_center_theme_pagination_options_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_sanitize_pagination_meta',
    )
);
$wp_customize->add_control( 'health_care_center_theme_pagination_options_alignment',
    array(
    'label'       => esc_html__( 'Pagination Alignment', 'health-care-center' ),
    'section'     => 'health_care_center_theme_pagination_options',
    'type'        => 'select',
    'choices'     => array(
        'Center'    => esc_html__( 'Center', 'health-care-center' ),
        'Right' => esc_html__( 'Right', 'health-care-center' ),
        'Left'  => esc_html__( 'Left', 'health-care-center' ),
        ),
    )
);

$wp_customize->add_setting('health_care_center_theme_breadcrumb_enable',
array(
    'default' => $health_care_center_default['health_care_center_theme_breadcrumb_enable'],
    'capability' => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_sanitize_checkbox',
)
);
$wp_customize->add_control('health_care_center_theme_breadcrumb_enable',
    array(
        'label' => esc_html__('Enable Breadcrumb', 'health-care-center'),
        'section' => 'health_care_center_theme_pagination_options',
        'type' => 'checkbox',
    )
);


$wp_customize->add_setting( 'health_care_center_theme_breadcrumb_options_alignment',
    array(
    'default'           => $health_care_center_default['health_care_center_theme_breadcrumb_options_alignment'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'health_care_center_sanitize_pagination_meta',
    )
);
$wp_customize->add_control( 'health_care_center_theme_breadcrumb_options_alignment',
    array(
    'label'       => esc_html__( 'Breadcrumb Alignment', 'health-care-center' ),
    'section'     => 'health_care_center_theme_pagination_options',
    'type'        => 'select',
    'choices'     => array(
        'Center'    => esc_html__( 'Center', 'health-care-center' ),
        'Right' => esc_html__( 'Right', 'health-care-center' ),
        'Left'  => esc_html__( 'Left', 'health-care-center' ),
        ),
    )
);

$wp_customize->add_setting('health_care_center_breadcrumb_font_size',
    array(
        'default'           => $health_care_center_default['health_care_center_breadcrumb_font_size'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_number_range',
    )
);
$wp_customize->add_control('health_care_center_breadcrumb_font_size',
    array(
        'label'       => esc_html__('Breadcrumb Font Size', 'health-care-center'),
        'section'     => 'health_care_center_theme_pagination_options',
        'type'        => 'number',
        'input_attrs' => array(
           'min'   => 1,
           'max'   => 45,
           'step'   => 1,
        ),
    )
);