<?php
/**
* Additional Woocommerce Settings.
*
* @package Health Care Center
*/

$health_care_center_default = health_care_center_get_default_theme_options();

// Additional Woocommerce Section.
$wp_customize->add_section( 'health_care_center_additional_woocommerce_options',
	array(
	'title'      => esc_html__( 'Additional Woocommerce Options', 'health-care-center' ),
	'priority'   => 210,
	'capability' => 'edit_theme_options',
	'panel'      => 'health_care_center_theme_option_panel',
	)
);

	$wp_customize->add_setting('health_care_center_per_columns',
		array(
		'default'           => $health_care_center_default['health_care_center_per_columns'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'health_care_center_sanitize_number_range',
		)
	);
	$wp_customize->add_control('health_care_center_per_columns',
		array(
		'label'       => esc_html__('Products Per Column', 'health-care-center'),
		'section'     => 'health_care_center_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 6,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('health_care_center_product_per_page',
		array(
		'default'           => $health_care_center_default['health_care_center_product_per_page'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'health_care_center_sanitize_number_range',
		)
	);
	$wp_customize->add_control('health_care_center_product_per_page',
		array(
		'label'       => esc_html__('Products Per Page', 'health-care-center'),
		'section'     => 'health_care_center_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 100,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('health_care_center_show_hide_related_product',
    array(
        'default' => $health_care_center_default['health_care_center_show_hide_related_product'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'health_care_center_sanitize_checkbox',
    )
	);
	$wp_customize->add_control('health_care_center_show_hide_related_product',
	    array(
	        'label' => esc_html__('Enable Related Products', 'health-care-center'),
	        'section' => 'health_care_center_additional_woocommerce_options',
	        'type' => 'checkbox',
	    )
	);

	$wp_customize->add_setting('health_care_center_custom_related_products_number',
		array(
		'default'           => $health_care_center_default['health_care_center_custom_related_products_number'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'health_care_center_sanitize_number_range',
		)
	);
	$wp_customize->add_control('health_care_center_custom_related_products_number',
		array(
		'label'       => esc_html__('Related Products Per Page', 'health-care-center'),
		'section'     => 'health_care_center_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 10,
		'step'   => 1,
		),
		)
	);

	$wp_customize->add_setting('health_care_center_custom_related_products_number_per_row',
		array(
		'default'           => $health_care_center_default['health_care_center_custom_related_products_number_per_row'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'health_care_center_sanitize_number_range',
		)
	);
	$wp_customize->add_control('health_care_center_custom_related_products_number_per_row',
		array(
		'label'       => esc_html__('Related Products Per Row', 'health-care-center'),
		'section'     => 'health_care_center_additional_woocommerce_options',
		'type'        => 'number',
		'input_attrs' => array(
		'min'   => 1,
		'max'   => 5,
		'step'   => 1,
		),
		)
	);