<?php
/**
* 404 Page Settings.
*
* @package Health Care Center
*/

$health_care_center_default = health_care_center_get_default_theme_options();

$wp_customize->add_section( 'health_care_center_404_page_settings',
    array(
        'title'      => esc_html__( '404 Page Settings', 'health-care-center' ),
        'priority'   => 200,
        'capability' => 'edit_theme_options',
        'panel'      => 'health_care_center_theme_addons_panel',
    )
);

$wp_customize->add_setting( 'health_care_center_404_main_title',
    array(
        'default'           => $health_care_center_default['health_care_center_404_main_title'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_404_main_title',
    array(
        'label'    => esc_html__( '404 Main Title', 'health-care-center' ),
        'section'  => 'health_care_center_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_404_subtitle_one',
    array(
        'default'           => $health_care_center_default['health_care_center_404_subtitle_one'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_404_subtitle_one',
    array(
        'label'    => esc_html__( '404 Sub Title One', 'health-care-center' ),
        'section'  => 'health_care_center_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_404_para_one',
    array(
        'default'           => $health_care_center_default['health_care_center_404_para_one'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_404_para_one',
    array(
        'label'    => esc_html__( '404 Para Text One', 'health-care-center' ),
        'section'  => 'health_care_center_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_404_subtitle_two',
    array(
        'default'           => $health_care_center_default['health_care_center_404_subtitle_two'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_404_subtitle_two',
    array(
        'label'    => esc_html__( '404 Sub Title Two', 'health-care-center' ),
        'section'  => 'health_care_center_404_page_settings',
        'type'     => 'text',
    )
);

$wp_customize->add_setting( 'health_care_center_404_para_two',
    array(
        'default'           => $health_care_center_default['health_care_center_404_para_two'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'health_care_center_404_para_two',
    array(
        'label'    => esc_html__( '404 Para Text Two', 'health-care-center' ),
        'section'  => 'health_care_center_404_page_settings',
        'type'     => 'text',
    )
);