<?php
/**
 * Custom Functions.
 *
 * @package Health Care Center
 */

if( !function_exists( 'health_care_center_fonts_url' ) ) :

    //Google Fonts URL
    function health_care_center_fonts_url(){

        $font_families = array(
            'Playfair+Display:ital,wght@0,400..900;1,400..900', //     font-family: "Playfair Display", serif;
            'Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900', //     font-family: "Inter", serif;
        );

        $fonts_url = add_query_arg( array(
            'family' => implode( '&family=', $font_families ),
            'display' => 'swap',
        ), 'https://fonts.googleapis.com/css2' );

        return esc_url_raw($fonts_url);

    }

endif;

if ( ! function_exists( 'health_care_center_sub_menu_toggle_button' ) ) :

    function health_care_center_sub_menu_toggle_button( $args, $item, $depth ) {

        // Add sub menu toggles to the main menu with toggles
        if ( $args->theme_location == 'health-care-center-primary-menu' && isset( $args->show_toggles ) ) {
            
            // Wrap the menu item link contents in a div, used for positioning
            $args->before = '<div class="submenu-wrapper">';
            $args->after  = '';

            // Add a toggle to items with children
            if ( in_array( 'menu-item-has-children', $item->classes ) ) {

                $toggle_target_string = '.menu-item.menu-item-' . $item->ID . ' > .sub-menu';

                // Add the sub menu toggle
                $args->after .= '<button type="button" class="theme-aria-button submenu-toggle" data-toggle-target="' . $toggle_target_string . '" data-toggle-type="slidetoggle" data-toggle-duration="250" aria-expanded="false"><span class="btn__content" tabindex="-1"><span class="screen-reader-text">' . esc_html__( 'Show sub menu', 'health-care-center' ) . '</span>' . health_care_center_get_theme_svg( 'chevron-down' ) . '</span></button>';

            }

            // Close the wrapper
            $args->after .= '</div><!-- .submenu-wrapper -->';
            // Add sub menu icons to the main menu without toggles (the fallback menu)

        }elseif( $args->theme_location == 'health-care-center-primary-menu' ) {

            if ( in_array( 'menu-item-has-children', $item->classes ) ) {

                $args->before = '<div class="link-icon-wrapper">';
                $args->after  = health_care_center_get_theme_svg( 'chevron-down' ) . '</div>';

            } else {

                $args->before = '';
                $args->after  = '';

            }

        }

        return $args;

    }

endif;

add_filter( 'nav_menu_item_args', 'health_care_center_sub_menu_toggle_button', 10, 3 );

if ( ! function_exists( 'health_care_center_the_theme_svg' ) ):
    
    function health_care_center_the_theme_svg( $health_care_center_svg_name, $return = false ) {

        if( $return ){

            return health_care_center_get_theme_svg( $health_care_center_svg_name ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped in health_care_center_get_theme_svg();.

        }else{

            echo health_care_center_get_theme_svg( $health_care_center_svg_name ); //phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- Escaped in health_care_center_get_theme_svg();.

        }
    }

endif;

if ( ! function_exists( 'health_care_center_get_theme_svg' ) ):

    function health_care_center_get_theme_svg( $health_care_center_svg_name ) {

        // Make sure that only our allowed tags and attributes are included.
        $health_care_center_svg = wp_kses(
            Health_Care_Center_SVG_Icons::get_svg( $health_care_center_svg_name ),
            array(
                'svg'     => array(
                    'class'       => true,
                    'xmlns'       => true,
                    'width'       => true,
                    'height'      => true,
                    'viewbox'     => true,
                    'aria-hidden' => true,
                    'role'        => true,
                    'focusable'   => true,
                ),
                'path'    => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'd'         => true,
                    'transform' => true,
                ),
                'polygon' => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'points'    => true,
                    'transform' => true,
                    'focusable' => true,
                ),
                'polyline' => array(
                    'fill'      => true,
                    'points'    => true,
                ),
                'line' => array(
                    'fill'      => true,
                    'x1'      => true,
                    'x2' => true,
                    'y1'    => true,
                    'y2' => true,
                ),
            )
        );
        if ( ! $health_care_center_svg ) {
            return false;
        }
        return $health_care_center_svg;

    }

endif;

if( !function_exists( 'health_care_center_post_category_list' ) ) :

    // Post Category List.
    function health_care_center_post_category_list( $select_cat = true ){

        $post_cat_lists = get_categories(
            array(
                'hide_empty' => '0',
                'exclude' => '1',
            )
        );

        $post_cat_cat_array = array();
        if( $select_cat ){

            $post_cat_cat_array[''] = esc_html__( '-- Select Category --','health-care-center' );

        }

        foreach ( $post_cat_lists as $post_cat_list ) {

            $post_cat_cat_array[$post_cat_list->slug] = $post_cat_list->name;

        }

        return $post_cat_cat_array;
    }

endif;

if( !function_exists('health_care_center_single_post_navigation') ):

    function health_care_center_single_post_navigation(){

        $health_care_center_default = health_care_center_get_default_theme_options();
        $health_care_center_twp_navigation_type = esc_attr( get_post_meta( get_the_ID(), 'twp_disable_ajax_load_next_post', true ) );
        $current_id = '';
        $article_wrap_class = '';
        global $post;
        $current_id = $post->ID;
        if( $health_care_center_twp_navigation_type == '' || $health_care_center_twp_navigation_type == 'global-layout' ){
            $health_care_center_twp_navigation_type = get_theme_mod('twp_navigation_type', $health_care_center_default['twp_navigation_type']);
        }

        if( $health_care_center_twp_navigation_type != 'no-navigation' && 'post' === get_post_type() ){

            if( $health_care_center_twp_navigation_type == 'theme-normal-navigation' ){ ?>

                <div class="navigation-wrapper">
                    <?php
                    // Previous/next post navigation.
                    the_post_navigation(array(
                        'prev_text' => '<span class="arrow" aria-hidden="true">' . health_care_center_the_theme_svg('arrow-left',$return = true ) . '</span><span class="screen-reader-text">' . esc_html__('Previous post:', 'health-care-center') . '</span><span class="post-title">%title</span>',
                        'next_text' => '<span class="arrow" aria-hidden="true">' . health_care_center_the_theme_svg('arrow-right',$return = true ) . '</span><span class="screen-reader-text">' . esc_html__('Next post:', 'health-care-center') . '</span><span class="post-title">%title</span>',
                    )); ?>
                </div>
                <?php

            }else{

                $next_post = get_next_post();
                if( isset( $next_post->ID ) ){

                    $next_post_id = $next_post->ID;
                    echo '<div loop-count="1" next-post="' . absint( $next_post_id ) . '" class="twp-single-infinity"></div>';

                }
            }

        }

    }

endif;

add_action( 'health_care_center_navigation_action','health_care_center_single_post_navigation',30 );

if( !function_exists('health_care_center_content_offcanvas') ):

    // Offcanvas Contents
    function health_care_center_content_offcanvas(){ ?>

        <div id="offcanvas-menu">
            <div class="offcanvas-wraper">
                <div class="close-offcanvas-menu">
                    <div class="offcanvas-close">
                        <a href="javascript:void(0)" class="skip-link-menu-start"></a>
                        <button type="button" class="button-offcanvas-close">
                            <span class="offcanvas-close-label">
                                <?php echo esc_html__('Close', 'health-care-center'); ?>
                            </span>
                        </button>
                    </div>
                </div>
                <div id="primary-nav-offcanvas" class="offcanvas-item offcanvas-main-navigation">
                    <nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e('Horizontal', 'health-care-center'); ?>" role="navigation">
                        <ul class="primary-menu theme-menu">
                            <?php
                            if (has_nav_menu('health-care-center-primary-menu')) {
                                wp_nav_menu(
                                    array(
                                        'container' => '',
                                        'items_wrap' => '%3$s',
                                        'theme_location' => 'health-care-center-primary-menu',
                                        'show_toggles' => true,
                                    )
                                );
                            }else{

                                wp_list_pages(
                                    array(
                                        'match_menu_classes' => true,
                                        'show_sub_menu_icons' => true,
                                        'title_li' => false,
                                        'show_toggles' => true,
                                        'walker' => new Health_Care_Center_Walker_Page(),
                                    )
                                );
                            }
                            ?>
                        </ul>
                    </nav><!-- .primary-menu-wrapper -->
                </div>
                <a href="javascript:void(0)" class="skip-link-menu-end"></a>
            </div>
        </div>

    <?php
    }

endif;

add_action( 'health_care_center_before_footer_content_action','health_care_center_content_offcanvas',30 );

if( !function_exists('health_care_center_footer_content_widget') ):

    function health_care_center_footer_content_widget(){
        
        $health_care_center_default = health_care_center_get_default_theme_options();
        
        $health_care_center_footer_column_layout = absint(get_theme_mod('health_care_center_footer_column_layout', $health_care_center_default['health_care_center_footer_column_layout']));
        $health_care_center_footer_sidebar_class = 12;
        
        if($health_care_center_footer_column_layout == 2) {
            $health_care_center_footer_sidebar_class = 6;
        }
        
        if($health_care_center_footer_column_layout == 3) {
            $health_care_center_footer_sidebar_class = 4;
        }
        ?>
        
        <?php if ( get_theme_mod('health_care_center_display_footer', true) == true ) : ?>
            <div class="footer-widgetarea">
                <div class="wrapper">
                    <div class="column-row">
                    
                        <?php for ($i = 0; $i < $health_care_center_footer_column_layout; $i++) : ?>
                            
                            <div class="column <?php echo 'column-' . absint($health_care_center_footer_sidebar_class); ?> column-sm-12">
                                
                                <?php 
                                // If no widgets are assigned, display default widgets
                                if ( ! is_active_sidebar( 'health-care-center-footer-widget-' . $i ) ) : 

                                    if ($i === 0) : ?>
                                        <div id="media_image-3" class="widget widget_media_image">
                                            <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/logo.png'); ?>" style="max-width: 100%; height: auto;">
                                        </div>
                                        <div id="text-3" class="widget widget_text">
                                            <div class="textwidget">
                                                <p class="widget_text">
                                                    <?php esc_html_e('The Health Care Center WordPress Theme is a versatile and professional design tailored to meet the needs of hospitals, clinics, and other health care providers. It is specifically crafted for a variety of medical services, including primary health care, urgent care, women\'s health, pediatric care, senior health care, mental health services, and rehabilitation centers.', 'health-care-center'); ?>
                                                </p>
                                            </div>
                                        </div>

                                    <?php elseif ($i === 1) : ?>
                                        <div id="pages-2" class="widget widget_pages">
                                            <h2 class="widget-title"><?php esc_html_e('Calendar', 'health-care-center'); ?></h2>
                                            <?php get_calendar(); ?>
                                        </div>

                                    <?php elseif ($i === 2) : ?>
                                        <div id="search-2" class="widget widget_search">
                                            <h2 class="widget-title"><?php esc_html_e('Enter Keywords Here', 'health-care-center'); ?></h2>
                                            <?php get_search_form(); ?>
                                        </div>
                                    <?php endif; 
                                    
                                else :
                                    // Display dynamic sidebar widget if assigned
                                    dynamic_sidebar('health-care-center-footer-widget-' . $i);
                                endif;
                                ?>
                                
                            </div>
                            
                        <?php endfor; ?>

                    </div>
                </div>
            </div>
        <?php endif; ?> 

    <?php
    }

endif;

add_action( 'health_care_center_footer_content_action', 'health_care_center_footer_content_widget', 10 );

if( !function_exists('health_care_center_footer_content_info') ):

    /**
     * Footer Copyright Area
    **/
    function health_care_center_footer_content_info(){

        $health_care_center_default = health_care_center_get_default_theme_options(); ?>
        <div class="site-info">
            <div class="wrapper">
                <div class="column-row">
                    <div class="column column-9">
                        <div class="footer-credits">
                            <div class="footer-copyright">
                                <?php
                                $health_care_center_footer_copyright_text = wp_kses_post( get_theme_mod( 'health_care_center_footer_copyright_text', $health_care_center_default['health_care_center_footer_copyright_text'] ) );
                                    echo esc_html( $health_care_center_footer_copyright_text );
                                    echo '<br>';
                                    echo esc_html__('Theme: ', 'health-care-center') . '<a href="' . esc_url('https://www.omegathemes.com/products/free-health-wordpress-theme') . '" title="' . esc_attr__('Health Care Center', 'health-care-center') . '" target="_blank"><span>' . esc_html__('Health Care Center ', 'health-care-center') . '</span></a>' . esc_html__(' By ', 'health-care-center') . '  <span>' . esc_html__('OMEGA ', 'health-care-center') . '</span>';
                                    echo esc_html__('Powered by ', 'health-care-center') . '<a href="' . esc_url('https://wordpress.org') . '" title="' . esc_attr__('WordPress', 'health-care-center') . '" target="_blank"><span>' . esc_html__('WordPress.', 'health-care-center') . '</span></a>';
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="column column-3 align-text-right">
                        <a class="to-the-top" href="#site-header">
                            <span class="to-the-top-long">
                                <?php if ( get_theme_mod('health_care_center_enable_to_the_top', true) == true ) : ?>
                                    <?php
                                    $health_care_center_to_the_top_text = get_theme_mod( 'health_care_center_to_the_top_text', __( 'To the Top', 'health-care-center' ) );
                                    printf( 
                                        wp_kses( 
                                            /* translators: %s is the arrow icon markup */
                                            '%s %s', 
                                            array( 'span' => array( 'class' => array(), 'aria-hidden' => array() ) ) 
                                        ), 
                                        esc_html( $health_care_center_to_the_top_text ),
                                        '<span class="arrow" aria-hidden="true">&uarr;</span>' 
                                    );
                                    ?>
                                <?php endif; ?>
                            </span>
                        </a>

                    </div>
                </div>
            </div>
        </div>

    <?php
    }

endif;

add_action( 'health_care_center_footer_content_action','health_care_center_footer_content_info',20 );


if ( ! function_exists( 'health_care_center_main_slider' ) ) :

    function health_care_center_main_slider() {
        $output = '';
        $health_care_center_defaults = health_care_center_get_default_theme_options();
        $health_care_center_header_slider = get_theme_mod( 'health_care_center_header_slider', $health_care_center_defaults['health_care_center_header_slider'] );

        $health_care_center_banner_heading = esc_html( get_theme_mod( 'health_care_center_banner_heading',
        $health_care_center_defaults['health_care_center_banner_heading'] ) );

        $health_care_center_banner_short_heading = esc_html( get_theme_mod( 'health_care_center_banner_short_heading',
        $health_care_center_defaults['health_care_center_banner_short_heading'] ) );

        $health_care_center_banner_content = esc_html( get_theme_mod( 'health_care_center_banner_content',
        $health_care_center_defaults['health_care_center_banner_content'] ) );

        $health_care_center_banner_button_url = esc_url( get_theme_mod( 'health_care_center_banner_button_url',
        $health_care_center_defaults['health_care_center_banner_button_url'] ) );

        $health_care_center_banner_button_text = esc_html( get_theme_mod( 'health_care_center_banner_button_text',
        $health_care_center_defaults['health_care_center_banner_button_text'] ) );

        $health_care_center_banner_rating_number = esc_html( get_theme_mod( 'health_care_center_banner_rating_number',
        $health_care_center_defaults['health_care_center_banner_rating_number'] ) );

        $health_care_center_banner_rating_text = esc_html( get_theme_mod( 'health_care_center_banner_rating_text',
        $health_care_center_defaults['health_care_center_banner_rating_text'] ) );

        $health_care_center_banner_team_image_1 = esc_url( get_theme_mod( 'health_care_center_banner_team_image_1',
        $health_care_center_defaults['health_care_center_banner_team_image_1'] ) );

        $health_care_center_banner_team_image_2 = esc_url( get_theme_mod( 'health_care_center_banner_team_image_2',
        $health_care_center_defaults['health_care_center_banner_team_image_2'] ) );

        $health_care_center_banner_team_image_3 = esc_url( get_theme_mod( 'health_care_center_banner_team_image_3',
        $health_care_center_defaults['health_care_center_banner_team_image_3'] ) );

        $health_care_center_banner_team_image_4 = esc_url( get_theme_mod( 'health_care_center_banner_team_image_4',
        $health_care_center_defaults['health_care_center_banner_team_image_4'] ) );

        // Debugging header slider status
        if ( ! $health_care_center_header_slider ) {
            error_log('Header slider is not enabled or has a falsy value.');
            return '';  // Exit early if no slider
        }

        $health_care_center_banner_background_image = get_theme_mod( 'health_care_center_banner_background_image', $health_care_center_defaults['health_care_center_banner_background_image'] );
        $health_care_center_header_banner_cat = get_theme_mod( 'health_care_center_header_banner_cat' );

        $banner_query = new WP_Query( array(
            'post_type' => 'post',
            'posts_per_page' => 4,
            'post__not_in' => get_option( 'sticky_posts' ),
            'category_name' => esc_html( $health_care_center_header_banner_cat ),
        ) );

        // Check if the query has posts
        if ( ! $banner_query->have_posts() ) {
            error_log('No posts found for the banner query.');
            return '';  // Exit early if no posts
        }

        ob_start();  // Start output buffering
        ?>
        <div id="site-content" class="main-banner">
            <div class="slider-box">
                <div class="wrapper">
                    <div class="main-slider">
                        <div class="content-box">
                            <div class="banner-image-box">
                                <?php if( $health_care_center_banner_background_image ){ ?>
                                    <img class="banner-image" src="<?php echo esc_url( $health_care_center_banner_background_image ); ?>">
                                <?php } ?>
                                <div class="banner-rating">
                                    <div class="rating-box">
                                        <?php if( $health_care_center_banner_rating_number ){ ?>
                                            <h6><?php echo esc_html( $health_care_center_banner_rating_number ); ?></h6>
                                        <?php } ?>
                                        <?php if( $health_care_center_banner_rating_text ){ ?>
                                            <p><?php echo esc_html( $health_care_center_banner_rating_text ); ?></p>
                                        <?php } ?>
                                    </div>
                                    <div class="team-image">
                                        <?php if( $health_care_center_banner_team_image_1 ){ ?>
                                            <img class="team-images" src="<?php echo esc_url( $health_care_center_banner_team_image_1 ); ?>">
                                        <?php } ?>
                                        <?php if( $health_care_center_banner_team_image_2 ){ ?>
                                            <img class="team-images" src="<?php echo esc_url( $health_care_center_banner_team_image_2 ); ?>">
                                        <?php } ?>
                                        <?php if( $health_care_center_banner_team_image_3 ){ ?>
                                            <img class="team-images" src="<?php echo esc_url( $health_care_center_banner_team_image_3 ); ?>">
                                        <?php } ?>
                                        <?php if( $health_care_center_banner_team_image_4 ){ ?>
                                            <img class="team-images" src="<?php echo esc_url( $health_care_center_banner_team_image_4 ); ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                            <div class="banner-content">
                                <?php if( $health_care_center_banner_short_heading ){ ?>
                                    <h4 class="short-heading"><?php echo esc_html( $health_care_center_banner_short_heading ); ?></h4>
                                <?php } ?>
                                <?php if( $health_care_center_banner_heading ){ ?>
                                    <h3 class="heading"><?php echo esc_html( $health_care_center_banner_heading ); ?></h3>
                                <?php } ?>
                                <?php if( $health_care_center_banner_content ){ ?>
                                    <p class="content"><?php echo esc_html( $health_care_center_banner_content ); ?></p>
                                <?php } ?>
                                <?php if( $health_care_center_banner_button_url || $health_care_center_banner_button_text ){ ?>
                                    <div class="button-banner">
                                        <a href="<?php echo esc_url( $health_care_center_banner_button_url ); ?>" class="banner-btn">
                                            <?php echo esc_html( $health_care_center_banner_button_text ); ?>
                                            <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6 .1 34zm192-34l-136-136c-9.4-9.4-24.6-9.4-33.9 0l-22.6 22.6c-9.4 9.4-9.4 24.6 0 33.9l96.4 96.4-96.4 96.4c-9.4 9.4-9.4 24.6 0 33.9l22.6 22.6c9.4 9.4 24.6 9.4 33.9 0l136-136c9.4-9.2 9.4-24.4 0-33.8z"/></svg>
                                        </a>
                                    </div>
                                <?php } ?>
                                <div class="banner-search-box">
                                    <?php get_search_form(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        wp_reset_postdata();
        $output = ob_get_clean();
        return $output;
    }

endif;


if( !function_exists( 'health_care_center_product_section' ) ) :

    function health_care_center_product_section(){ 

        $health_care_center_default = health_care_center_get_default_theme_options();
        $health_care_center_locations_post = get_theme_mod( 'health_care_center_locations_post', $health_care_center_default['health_care_center_locations_post'] );
        $health_care_center_locations_post_cat = get_theme_mod( 'health_care_center_locations_post_cat' );

        $health_care_center_team_section_subtitle = esc_html( get_theme_mod( 'health_care_center_team_section_subtitle',
        $health_care_center_default['health_care_center_team_section_subtitle'] ) );

        $health_care_center_about_us_section_short_title = esc_html( get_theme_mod( 'health_care_center_about_us_section_short_title',
        $health_care_center_default['health_care_center_about_us_section_short_title'] ) );

        $health_care_center_about_us_section_title = esc_html( get_theme_mod( 'health_care_center_about_us_section_title',
        $health_care_center_default['health_care_center_about_us_section_title'] ) );

        $health_care_center_about_us_list_text_1 = esc_html( get_theme_mod( 'health_care_center_about_us_list_text_1',
        $health_care_center_default['health_care_center_about_us_list_text_1'] ) );

        $health_care_center_about_us_list_text_2 = esc_html( get_theme_mod( 'health_care_center_about_us_list_text_2',
        $health_care_center_default['health_care_center_about_us_list_text_2'] ) );

        $health_care_center_about_us_list_text_3 = esc_html( get_theme_mod( 'health_care_center_about_us_list_text_3',
        $health_care_center_default['health_care_center_about_us_list_text_3'] ) );

        $health_care_center_team_section_button_text = esc_html( get_theme_mod( 'health_care_center_team_section_button_text',
        $health_care_center_default['health_care_center_team_section_button_text'] ) );

        $health_care_center_team_section_button_url = esc_url( get_theme_mod( 'health_care_center_team_section_button_url',
        $health_care_center_default['health_care_center_team_section_button_url'] ) );

        $health_care_center_about_us_image_1 = esc_url( get_theme_mod( 'health_care_center_about_us_image_1',
        $health_care_center_default['health_care_center_about_us_image_1'] ) );

        $health_care_center_about_us_image_2 = esc_url( get_theme_mod( 'health_care_center_about_us_image_2',
        $health_care_center_default['health_care_center_about_us_image_2'] ) );

        $health_care_center_about_us_image_3 = esc_url( get_theme_mod( 'health_care_center_about_us_image_3',
        $health_care_center_default['health_care_center_about_us_image_3'] ) );

        $health_care_center_about_doctor_image = esc_url( get_theme_mod( 'health_care_center_about_doctor_image',
        $health_care_center_default['health_care_center_about_doctor_image'] ) );

        $health_care_center_about_doctor_name = esc_html( get_theme_mod( 'health_care_center_about_doctor_name',
        $health_care_center_default['health_care_center_about_doctor_name'] ) );

        $health_care_center_about_doctor_designation = esc_html( get_theme_mod( 'health_care_center_about_doctor_designation',
        $health_care_center_default['health_care_center_about_doctor_designation'] ) );

        $health_care_center_locations_query = new WP_Query( array('post_type' => 'post', 'posts_per_page' => 6,'post__not_in' => get_option("sticky_posts"), 'category_name' => esc_html( $health_care_center_locations_post_cat ) ) );
            if( $health_care_center_locations_query->have_posts() ): ?>
            <div class="theme-product-block">
                <div class="wrapper">
                    <div class="services-box">
                        <div class="about-us-right">
                            <div class="image-box-1">
                                <?php if( $health_care_center_about_us_image_1 ){ ?>
                                    <img class="team-images" src="<?php echo esc_url( $health_care_center_about_us_image_1 ); ?>">
                                <?php } ?>
                            </div>
                            <div class="image-box-2">
                                <?php if( $health_care_center_about_us_image_2 ){ ?>
                                    <img class="about-us-2" src="<?php echo esc_url( $health_care_center_about_us_image_2 ); ?>">
                                <?php } ?>
                                <?php if( $health_care_center_about_us_image_3 ){ ?>
                                    <img class="about-us-3" src="<?php echo esc_url( $health_care_center_about_us_image_3 ); ?>">
                                <?php } ?>
                                <div class="about-doctor">
                                    <div class="doctor-image">
                                        <?php if( $health_care_center_about_doctor_image ){ ?>
                                            <img class="doctor-images" src="<?php echo esc_url( $health_care_center_about_doctor_image ); ?>">
                                        <?php } ?>
                                    </div>
                                    <div class="doctor-box">
                                        <?php if( $health_care_center_about_doctor_name ){ ?>
                                            <h6><?php echo esc_html( $health_care_center_about_doctor_name ); ?></h6>
                                        <?php } ?>
                                        <?php if( $health_care_center_about_doctor_designation ){ ?>
                                            <p><?php echo esc_html( $health_care_center_about_doctor_designation ); ?></p>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="about-us-left">
                            <div class="package-content">
                                <?php if( $health_care_center_about_us_section_short_title ){ ?>
                                    <h6><?php echo esc_html( $health_care_center_about_us_section_short_title ); ?></h6>
                                <?php } ?>
                                <?php if( $health_care_center_about_us_section_title ){ ?>
                                    <h4><?php echo esc_html( $health_care_center_about_us_section_title ); ?></h4>
                                <?php } ?>
                                <?php if( $health_care_center_team_section_subtitle ){ ?>
                                    <p><?php echo esc_html( $health_care_center_team_section_subtitle ); ?></p>
                                <?php } ?>
                                <ul class="about-list">
                                    <li><svg xmlns="http://www.w3.org/2000/svg" height="1.5em" viewBox="0 0 512 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zM227.3 387.3l184-184c6.2-6.2 6.2-16.4 0-22.6l-22.6-22.6c-6.2-6.2-16.4-6.2-22.6 0L216 308.1l-70.1-70.1c-6.2-6.2-16.4-6.2-22.6 0l-22.6 22.6c-6.2 6.2-6.2 16.4 0 22.6l104 104c6.2 6.2 16.4 6.2 22.6 0z"/></svg><?php echo esc_html( $health_care_center_about_us_list_text_1 ); ?></li>
                                    <li><svg xmlns="http://www.w3.org/2000/svg" height="1.5em" viewBox="0 0 512 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zM227.3 387.3l184-184c6.2-6.2 6.2-16.4 0-22.6l-22.6-22.6c-6.2-6.2-16.4-6.2-22.6 0L216 308.1l-70.1-70.1c-6.2-6.2-16.4-6.2-22.6 0l-22.6 22.6c-6.2 6.2-6.2 16.4 0 22.6l104 104c6.2 6.2 16.4 6.2 22.6 0z"/></svg><?php echo esc_html( $health_care_center_about_us_list_text_2 ); ?></li>
                                    <li><svg xmlns="http://www.w3.org/2000/svg" height="1.5em" viewBox="0 0 512 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zM227.3 387.3l184-184c6.2-6.2 6.2-16.4 0-22.6l-22.6-22.6c-6.2-6.2-16.4-6.2-22.6 0L216 308.1l-70.1-70.1c-6.2-6.2-16.4-6.2-22.6 0l-22.6 22.6c-6.2 6.2-6.2 16.4 0 22.6l104 104c6.2 6.2 16.4 6.2 22.6 0z"/></svg><?php echo esc_html( $health_care_center_about_us_list_text_3); ?></li>
                                </ul>
                            </div>
                            <div class="package-button">
                                <a class="package-btn" href="<?php echo esc_url( $health_care_center_team_section_button_url ); ?>"><?php echo esc_html( $health_care_center_team_section_button_text ); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
             <?php
            wp_reset_postdata();
            endif;
          ?>
    <?php }

endif;
if (!function_exists('health_care_center_post_format_icon')):

    // Post Format Icon.
    function health_care_center_post_format_icon() {

        $health_care_center_format = get_post_format(get_the_ID()) ?: 'standard';
        $health_care_center_icon = '';
        $health_care_center_title = '';
        if( $health_care_center_format == 'video' ){
            $health_care_center_icon = health_care_center_get_theme_svg( 'video' );
            $health_care_center_title = esc_html__('Video','health-care-center');
        }elseif( $health_care_center_format == 'audio' ){
            $health_care_center_icon = health_care_center_get_theme_svg( 'audio' );
            $health_care_center_title = esc_html__('Audio','health-care-center');
        }elseif( $health_care_center_format == 'gallery' ){
            $health_care_center_icon = health_care_center_get_theme_svg( 'gallery' );
            $health_care_center_title = esc_html__('Gallery','health-care-center');
        }elseif( $health_care_center_format == 'quote' ){
            $health_care_center_icon = health_care_center_get_theme_svg( 'quote' );
            $health_care_center_title = esc_html__('Quote','health-care-center');
        }elseif( $health_care_center_format == 'image' ){
            $health_care_center_icon = health_care_center_get_theme_svg( 'image' );
            $health_care_center_title = esc_html__('Image','health-care-center');
        } elseif( $health_care_center_format == 'link' ){
            $health_care_center_icon = health_care_center_get_theme_svg( 'link' );
            $health_care_center_title = esc_html__('Link','health-care-center');
        } elseif( $health_care_center_format == 'status' ){
            $health_care_center_icon = health_care_center_get_theme_svg( 'status' );
            $health_care_center_title = esc_html__('Status','health-care-center');
        } elseif( $health_care_center_format == 'aside' ){
            $health_care_center_icon = health_care_center_get_theme_svg( 'aside' );
            $health_care_center_title = esc_html__('Aside','health-care-center');
        } elseif( $health_care_center_format == 'chat' ){
            $health_care_center_icon = health_care_center_get_theme_svg( 'chat' );
            $health_care_center_title = esc_html__('Chat','health-care-center');
        }
        
        if (!empty($health_care_center_icon)) { ?>
            <div class="theme-post-format">
                <span class="post-format-icom"><?php echo health_care_center_svg_escape($health_care_center_icon); ?></span>
                <?php if( $health_care_center_title ){ echo '<span class="post-format-label">'.esc_html( $health_care_center_title ).'</span>'; } ?>
            </div>
        <?php }
    }

endif;

if ( ! function_exists( 'health_care_center_svg_escape' ) ):

    /**
     * Get information about the SVG icon.
     *
     * @param string $health_care_center_svg_name The name of the icon.
     * @param string $group The group the icon belongs to.
     * @param string $color Color code.
     */
    function health_care_center_svg_escape( $health_care_center_input ) {

        // Make sure that only our allowed tags and attributes are included.
        $health_care_center_svg = wp_kses(
            $health_care_center_input,
            array(
                'svg'     => array(
                    'class'       => true,
                    'xmlns'       => true,
                    'width'       => true,
                    'height'      => true,
                    'viewbox'     => true,
                    'aria-hidden' => true,
                    'role'        => true,
                    'focusable'   => true,
                ),
                'path'    => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'd'         => true,
                    'transform' => true,
                ),
                'polygon' => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'points'    => true,
                    'transform' => true,
                    'focusable' => true,
                ),
            )
        );

        if ( ! $health_care_center_svg ) {
            return false;
        }

        return $health_care_center_svg;

    }

endif;

if( !function_exists( 'health_care_center_sanitize_sidebar_option_meta' ) ) :

    // Sidebar Option Sanitize.
    function health_care_center_sanitize_sidebar_option_meta( $health_care_center_input ){

        $health_care_center_metabox_options = array( 'global-sidebar','left-sidebar','right-sidebar','no-sidebar' );
        if( in_array( $health_care_center_input,$health_care_center_metabox_options ) ){

            return $health_care_center_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'health_care_center_sanitize_pagination_meta' ) ) :

    // Sidebar Option Sanitize.
    function health_care_center_sanitize_pagination_meta( $health_care_center_input ){

        $health_care_center_metabox_options = array( 'Center','Right','Left');
        if( in_array( $health_care_center_input,$health_care_center_metabox_options ) ){

            return $health_care_center_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'health_care_center_sanitize_copyright_alignment_meta' ) ) :

    // Sidebar Option Sanitize.
    function health_care_center_sanitize_copyright_alignment_meta( $health_care_center_input ){

        $health_care_center_metabox_options = array( 'Default','Reverse','Center');
        if( in_array( $health_care_center_input,$health_care_center_metabox_options ) ){

            return $health_care_center_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'health_care_center_sanitize_pagination_type' ) ) :

    /**
     * Sanitize the pagination type setting.
     *
     * @param string $health_care_center_input The input value from the Customizer.
     * @return string The sanitized value.
     */
    function health_care_center_sanitize_pagination_type( $health_care_center_input ) {
        // Define valid options for the pagination type.
        $health_care_center_valid_options = array( 'numeric', 'newer_older' ); // Update valid options to include 'newer_older'

        // If the input is one of the valid options, return it. Otherwise, return the default option ('numeric').
        if ( in_array( $health_care_center_input, $health_care_center_valid_options, true ) ) {
            return $health_care_center_input;
        } else {
            // Return 'numeric' as the fallback if the input is invalid.
            return 'numeric';
        }
    }

endif;


// Sanitize the enable/disable setting for pagination
if( !function_exists('health_care_center_sanitize_enable_pagination') ) :
    function health_care_center_sanitize_enable_pagination( $health_care_center_input ) {
        return (bool) $health_care_center_input;
    }
endif;

if( !function_exists( 'health_care_center_sanitize_menu_transform' ) ) :

    // Sidebar Option Sanitize.
    function health_care_center_sanitize_menu_transform( $health_care_center_input ){

        $health_care_center_metabox_options = array( 'capitalize','uppercase','lowercase');
        if( in_array( $health_care_center_input,$health_care_center_metabox_options ) ){

            return $health_care_center_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'health_care_center_sanitize_page_content_alignment' ) ) :

    // Sidebar Option Sanitize.
    function health_care_center_sanitize_page_content_alignment( $health_care_center_input ){

        $health_care_center_metabox_options = array( 'left','center','right');
        if( in_array( $health_care_center_input,$health_care_center_metabox_options ) ){

            return $health_care_center_input;

        }else{

            return '';

        }
    }

endif;

if( !function_exists( 'health_care_center_sanitize_footer_widget_title_alignment' ) ) :

    // Footer Option Sanitize.
    function health_care_center_sanitize_footer_widget_title_alignment( $health_care_center_input ){

        $health_care_center_metabox_options = array( 'left','center','right');
        if( in_array( $health_care_center_input,$health_care_center_metabox_options ) ){

            return $health_care_center_input;

        }else{

            return '';

        }
    }

endif;

/**
 * Sidebar Layout Function
 */
function health_care_center_get_final_sidebar_layout() {
	$health_care_center_defaults       = health_care_center_get_default_theme_options();
	$health_care_center_global_layout  = get_theme_mod('health_care_center_global_sidebar_layout', $health_care_center_defaults['health_care_center_global_sidebar_layout']);
	$health_care_center_page_layout    = get_theme_mod('health_care_center_page_sidebar_layout', $health_care_center_global_layout);
	$health_care_center_post_layout    = get_theme_mod('health_care_center_post_sidebar_layout', $health_care_center_global_layout);
	$health_care_center_meta_layout    = get_post_meta(get_the_ID(), 'health_care_center_post_sidebar_option', true);

	if (!empty($health_care_center_meta_layout) && $health_care_center_meta_layout !== 'default') {
		return $health_care_center_meta_layout;
	}
	if (is_page() || (function_exists('is_shop') && is_shop())) {
		return $health_care_center_page_layout;
	}
	if (is_single()) {
		return $health_care_center_post_layout;
	}
	return $health_care_center_global_layout;
}