<?php
/**
 * Health Care Center functions and definitions
 * @package Health Care Center
 */

if ( ! function_exists( 'health_care_center_after_theme_support' ) ) :

	function health_care_center_after_theme_support() {
		
		add_theme_support( 'automatic-feed-links' );

		add_theme_support('woocommerce');
        add_theme_support('wc-product-gallery-zoom');
        add_theme_support('wc-product-gallery-lightbox');
        add_theme_support('wc-product-gallery-slider');
        add_theme_support('woocommerce', array(
            'gallery_thumbnail_image_width' => 300,
        ));

		add_theme_support(
			'custom-background',
			array(
				'default-color' => 'ffffff',
			)
		);

		load_theme_textdomain( 'health-care-center', get_template_directory() . '/languages' );

		$GLOBALS['content_width'] = apply_filters( 'health_care_center_content_width', 1140 );
		
		add_theme_support( 'post-thumbnails' );

		add_theme_support(
			'custom-logo',
			array(
				'height'      => 270,
				'width'       => 90,
				'flex-height' => true,
				'flex-width'  => true,
			)
		);
		
		add_theme_support( 'title-tag' );

		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'script',
				'style',
			)
		);

		add_theme_support( 'post-formats', array(
			'video',
			'audio',
			'gallery',
			'quote',
			'image',
			'link',
			'status',
			'aside',
			'chat',
		) );
		
		add_theme_support( 'align-wide' );
		add_theme_support( 'responsive-embeds' );
		add_theme_support( 'wp-block-styles' );

		require get_template_directory() . '/inc/metabox.php';
		require get_template_directory() . '/inc/homepage-setup/homepage-setup-settings.php';

		if (! defined( 'HEALTH_CARE_CENTER_DOCS_PRO' ) ){
		define('HEALTH_CARE_CENTER_DOCS_PRO',__('https://layout.omegathemes.com/steps/pro-storefront-eshop/','health-care-center'));
		}
		if (! defined( 'HEALTH_CARE_CENTER_BUY_NOW' ) ){
		define('HEALTH_CARE_CENTER_BUY_NOW',__('https://www.omegathemes.com/products/health-care-wordpress-theme','health-care-center'));
		}
		if (! defined( 'HEALTH_CARE_CENTER_SUPPORT_FREE' ) ){
		define('HEALTH_CARE_CENTER_SUPPORT_FREE',__('https://wordpress.org/support/theme/health-care-center/','health-care-center'));
		}
		if (! defined( 'HEALTH_CARE_CENTER_REVIEW_FREE' ) ){
		define('HEALTH_CARE_CENTER_REVIEW_FREE',__('https://wordpress.org/support/theme/health-care-center/reviews/#new-post/','health-care-center'));
		}
		if (! defined( 'HEALTH_CARE_CENTER_DEMO_PRO' ) ){
		define('HEALTH_CARE_CENTER_DEMO_PRO',__('https://layout.omegathemes.com/health-care-center/','health-care-center'));
		}
		if (! defined( 'HEALTH_CARE_CENTER_LITE_DOCS_PRO' ) ){
		define('HEALTH_CARE_CENTER_LITE_DOCS_PRO',__('https://layout.omegathemes.com/steps/free-digital-store/','health-care-center'));
		}
		if (! defined( 'HEALTH_CARE_CENTER_BUNDLE_BUTTON' ) ){
			define('HEALTH_CARE_CENTER_BUNDLE_BUTTON',__('https://www.omegathemes.com/products/wp-theme-bundle','health-care-center'));
		}

	}

endif;

add_action( 'after_setup_theme', 'health_care_center_after_theme_support' );

/**
 * Register and Enqueue Styles.
 */
function health_care_center_register_styles() {

	wp_enqueue_style( 'dashicons' );

    $theme_version = wp_get_theme()->get( 'Version' );
	$fonts_url = health_care_center_fonts_url();
    if( $fonts_url ){
    	require_once get_theme_file_path( 'lib/custom/css/wptt-webfont-loader.php' );
        wp_enqueue_style(
			'health-care-center-google-fonts',
			health_care_center_wptt_get_webfont_url( $fonts_url ),
			array(),
			$theme_version
		);
    }

    wp_enqueue_style( 'swiper', get_template_directory_uri() . '/lib/swiper/css/swiper-bundle.min.css');
	wp_enqueue_style( 'health-care-center-style', get_stylesheet_uri(), array(), $theme_version );

	wp_enqueue_style( 'health-care-center-style', get_stylesheet_uri() );
	require get_parent_theme_file_path( '/custom_css.php' );
	wp_add_inline_style( 'health-care-center-style',$health_care_center_custom_css );

	$health_care_center_css = '';

	if ( get_header_image() ) :

		$health_care_center_css .=  '
			.main-header{
				background-image: url('.esc_url(get_header_image()).');
				-webkit-background-size: cover !important;
				-moz-background-size: cover !important;
				-o-background-size: cover !important;
				background-size: cover !important;
			}';

	endif;

	wp_add_inline_style( 'health-care-center-style', $health_care_center_css );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}	

	wp_enqueue_script( 'imagesloaded' );
    wp_enqueue_script( 'masonry' );
	wp_enqueue_script( 'health-care-center-custom', get_template_directory_uri() . '/lib/custom/js/theme-custom-script.js', array('jquery'), '', 1);
	wp_enqueue_script( 'swiper', get_template_directory_uri() . '/lib/swiper/js/swiper-bundle.min.js', array('jquery'), '', 1);

    // Global Query
    if( is_front_page() ){

    	$posts_per_page = absint( get_option('posts_per_page') );
        $c_paged = ( get_query_var( 'page' ) ) ? absint( get_query_var( 'page' ) ) : 1;
        $posts_args = array(
            'posts_per_page'        => $posts_per_page,
            'paged'                 => $c_paged,
        );
        $posts_qry = new WP_Query( $posts_args );
        $max = $posts_qry->max_num_pages;

    }else{
        global $wp_query;
        $max = $wp_query->max_num_pages;
        $c_paged = ( get_query_var( 'paged' ) > 1 ) ? get_query_var( 'paged' ) : 1;
    }

    $health_care_center_default = health_care_center_get_default_theme_options();
    $health_care_center_pagination_layout = get_theme_mod( 'health_care_center_pagination_layout',$health_care_center_default['health_care_center_pagination_layout'] );
}

add_action( 'wp_enqueue_scripts', 'health_care_center_register_styles',200 );

function health_care_center_admin_enqueue_scripts_callback() {
    if ( ! did_action( 'wp_enqueue_media' ) ) {
    wp_enqueue_media();
    }
    wp_enqueue_script('health-care-center-uploaderjs', get_stylesheet_directory_uri() . '/lib/custom/js/uploader.js', array(), "1.0", true);
}
add_action( 'admin_enqueue_scripts', 'health_care_center_admin_enqueue_scripts_callback' );

/**
 * Register navigation menus uses wp_nav_menu in five places.
 */
function health_care_center_menus() {

	$health_care_center_locations = array(
		'health-care-center-primary-menu'  => esc_html__( 'Primary Menu', 'health-care-center' ),
	);

	register_nav_menus( $health_care_center_locations );
}

add_action( 'init', 'health_care_center_menus' );

add_filter('loop_shop_columns', 'health_care_center_loop_columns');
if (!function_exists('health_care_center_loop_columns')) {
	function health_care_center_loop_columns() {
		$health_care_center_columns = get_theme_mod( 'health_care_center_per_columns', 3 );
		return $health_care_center_columns;
	}
}

add_filter( 'loop_shop_per_page', 'health_care_center_per_page', 20 );
function health_care_center_per_page( $health_care_center_cols ) {
  	$health_care_center_cols = get_theme_mod( 'health_care_center_product_per_page', 9 );
	return $health_care_center_cols;
}

add_filter( 'woocommerce_output_related_products_args', 'health_care_center_products_args' );

function health_care_center_products_args( $health_care_center_args ) {

    $health_care_center_args['posts_per_page'] = get_theme_mod( 'health_care_center_custom_related_products_number', 6 );

    $health_care_center_args['columns'] = get_theme_mod( 'health_care_center_custom_related_products_number_per_row', 3 );

    return $health_care_center_args;
}

require get_template_directory() . '/inc/custom-header.php';
require get_template_directory() . '/classes/class-svg-icons.php';
require get_template_directory() . '/classes/class-walker-menu.php';
require get_template_directory() . '/inc/customizer/customizer.php';
require get_template_directory() . '/inc/custom-functions.php';
require get_template_directory() . '/inc/template-tags.php';
require get_template_directory() . '/classes/body-classes.php';
require get_template_directory() . '/inc/widgets/widgets.php';
require get_template_directory() . '/inc/pagination.php';
require get_template_directory() . '/lib/breadcrumbs/breadcrumbs.php';
require get_template_directory() . '/lib/custom/css/dynamic-style.php';


function health_care_center_remove_customize_register() {
    global $wp_customize;

    $wp_customize->remove_setting( 'display_header_text' );
    $wp_customize->remove_control( 'display_header_text' );

}

add_action( 'customize_register', 'health_care_center_remove_customize_register', 11 );


function health_care_center_radio_sanitize(  $health_care_center_input, $health_care_center_setting  ) {
	$health_care_center_input = sanitize_key( $health_care_center_input );
	$health_care_center_choices = $health_care_center_setting->manager->get_control( $health_care_center_setting->id )->choices;
	return ( array_key_exists( $health_care_center_input, $health_care_center_choices ) ? $health_care_center_input : $health_care_center_setting->default );
}
require get_template_directory() . '/inc/general.php';

function health_care_center_sticky_sidebar_enabled() {
	$health_care_center_sticky_sidebar = get_theme_mod('health_care_center_sticky_sidebar', true);
	if($health_care_center_sticky_sidebar == false) {
		echo '<style>.widget-area-wrapper {position: relative !important;}</style>';
	}
}

add_action('wp_head', 'health_care_center_sticky_sidebar_enabled');

// NOTICE FUNCTION

function health_care_center_admin_notice() { 
    global $pagenow;
    $theme_args = wp_get_theme();
    $meta = get_option( 'health_care_center_admin_notice' );
    $name = $theme_args->get( 'Name' );
    $current_screen = get_current_screen();

    if ( ! $meta ) {
        if ( is_network_admin() ) {
            return;
        }

        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        if ( $current_screen->base != 'appearance_page_healthcarecenter-wizard' ) {
            ?>
            <div class="notice notice-success notice-content">
                <h2><?php esc_html_e('Welcome! Thank you for choosing Health Care Center. Let’s Set Up Your Website!', 'health-care-center') ?> </h2>
                <p><?php esc_html_e('Before you dive into customization, let’s go through a quick setup process to ensure everything runs smoothly. Click below to start setting up your website in minutes!', 'health-care-center') ?> </p>
                <div class="info-link">
                    <a href="<?php echo esc_url( admin_url( 'themes.php?page=healthcarecenter-wizard' ) ); ?>"><?php esc_html_e('Get Started with Health Care Center', 'health-care-center'); ?></a>
                </div>
                <p class="dismiss-link"><strong><a href="?health_care_center_admin_notice=1"><?php esc_html_e( 'Dismiss', 'health-care-center' ); ?></a></strong></p>
            </div>
            <?php
        }
    }
}
add_action( 'admin_notices', 'health_care_center_admin_notice' );

if ( ! function_exists( 'health_care_center_update_admin_notice' ) ) :
/**
 * Updating admin notice on dismiss
 */
function health_care_center_update_admin_notice() {
    if ( isset( $_GET['health_care_center_admin_notice'] ) && $_GET['health_care_center_admin_notice'] == '1' ) {
        update_option( 'health_care_center_admin_notice', true );
    }
}
endif;
add_action( 'admin_init', 'health_care_center_update_admin_notice' );

// After Switch theme function
add_action( 'after_switch_theme', 'health_care_center_getstart_setup_options' );
function health_care_center_getstart_setup_options() {
    update_option( 'health_care_center_admin_notice', false );
}