<?php
/**
 * Custom page walker for this theme.
 *
 * @package Health Care Center
 */

if (!class_exists('Health_Care_Center_Walker_Page')) {
    /**
     * CUSTOM PAGE WALKER
     * A custom walker for pages.
     */
    class Health_Care_Center_Walker_Page extends Walker_Page
    {

        /**
         * Outputs the beginning of the current element in the tree.
         *
         * @param string $health_care_center_output Used to append additional content. Passed by reference.
         * @param WP_Post $page Page data object.
         * @param int $health_care_center_depth Optional. Depth of page. Used for padding. Default 0.
         * @param array $health_care_center_args Optional. Array of arguments. Default empty array.
         * @param int $current_page Optional. Page ID. Default 0.
         * @since 2.1.0
         *
         * @see Walker::start_el()
         */

        public function start_lvl( &$health_care_center_output, $health_care_center_depth = 0, $health_care_center_args = array() ) {
            $health_care_center_indent  = str_repeat( "\t", $health_care_center_depth );
            $health_care_center_output .= "$health_care_center_indent<ul class='sub-menu'>\n";
        }

        public function start_el(&$health_care_center_output, $page, $health_care_center_depth = 0, $health_care_center_args = array(), $current_page = 0)
        {

            if (isset($health_care_center_args['item_spacing']) && 'preserve' === $health_care_center_args['item_spacing']) {
                $t = "\t";
                $n = "\n";
            } else {
                $t = '';
                $n = '';
            }
            if ($health_care_center_depth) {
                $health_care_center_indent = str_repeat($t, $health_care_center_depth);
            } else {
                $health_care_center_indent = '';
            }

            $health_care_center_css_class = array('page_item', 'page-item-' . $page->ID);

            if (isset($health_care_center_args['pages_with_children'][$page->ID])) {
                $health_care_center_css_class[] = 'page_item_has_children';
            }

            if (!empty($current_page)) {
                $_current_page = get_post($current_page);
                if ($_current_page && in_array($page->ID, $_current_page->ancestors, true)) {
                    $health_care_center_css_class[] = 'current_page_ancestor';
                }
                if ($page->ID === $current_page) {
                    $health_care_center_css_class[] = 'current_page_item';
                } elseif ($_current_page && $page->ID === $_current_page->post_parent) {
                    $health_care_center_css_class[] = 'current_page_parent';
                }
            } elseif (get_option('page_for_posts') === $page->ID) {
                $health_care_center_css_class[] = 'current_page_parent';
            }

            /** This filter is documented in wp-includes/class-walker-page.php */
            $health_care_center_css_classes = implode(' ', apply_filters('page_css_class', $health_care_center_css_class, $page, $health_care_center_depth, $health_care_center_args, $current_page));
            $health_care_center_css_classes = $health_care_center_css_classes ? ' class="' . esc_attr($health_care_center_css_classes) . '"' : '';

            if ('' === $page->post_title) {
                /* translators: %d: ID of a post. */
                $page->post_title = sprintf(__('#%d (no title)', 'health-care-center'), $page->ID);
            }

            $health_care_center_args['link_before'] = empty($health_care_center_args['link_before']) ? '' : $health_care_center_args['link_before'];
            $health_care_center_args['link_after'] = empty($health_care_center_args['link_after']) ? '' : $health_care_center_args['link_after'];

            $health_care_center_atts = array();
            $health_care_center_atts['href'] = get_permalink($page->ID);
            $health_care_center_atts['aria-current'] = ($page->ID === $current_page) ? 'page' : '';

            /** This filter is documented in wp-includes/class-walker-page.php */
            $health_care_center_atts = apply_filters('page_menu_link_attributes', $health_care_center_atts, $page, $health_care_center_depth, $health_care_center_args, $current_page);

            $health_care_center_attributes = '';
            foreach ($health_care_center_atts as $attr => $health_care_center_value) {
                if (!empty($health_care_center_value)) {
                    $health_care_center_value = ('href' === $attr) ? esc_url($health_care_center_value) : esc_attr($health_care_center_value);
                    $health_care_center_attributes .= ' ' . $attr . '="' . $health_care_center_value . '"';
                }
            }

            $health_care_center_args['list_item_before'] = '';
            $health_care_center_args['list_item_after'] = '';
            $health_care_center_args['icon_rennder'] = '';
            // Wrap the link in a div and append a sub menu toggle.
            if (isset($health_care_center_args['show_toggles']) && true === $health_care_center_args['show_toggles']) {
                // Wrap the menu item link contents in a div, used for positioning.
                $health_care_center_args['list_item_after'] = '';
            }


            // Add icons to menu items with children.
            if (isset($health_care_center_args['show_sub_menu_icons']) && true === $health_care_center_args['show_sub_menu_icons']) {
                if (isset($health_care_center_args['pages_with_children'][$page->ID])) {
                    $health_care_center_args['icon_rennder'] = '';
                }
            }

            // Add icons to menu items with children.
            if (isset($health_care_center_args['show_toggles']) && true === $health_care_center_args['show_toggles']) {
                if (isset($health_care_center_args['pages_with_children'][$page->ID])) {

                    $toggle_target_string = '.page_item.page-item-' . $page->ID . ' > .sub-menu';

                    $health_care_center_args['list_item_after'] = '<button type="button" class="theme-aria-button submenu-toggle" data-toggle-target="' . $toggle_target_string . '" data-toggle-type="slidetoggle" data-toggle-duration="250"><span class="btn__content" tabindex="-1"><span class="screen-reader-text">' . __( 'Show sub menu', 'health-care-center' ) . '</span>' . health_care_center_get_theme_svg( 'chevron-down' ) . '</span></button>';
                }
            }

            if (isset($health_care_center_args['show_toggles']) && true === $health_care_center_args['show_toggles']) {

                $health_care_center_output .= $health_care_center_indent . sprintf(
                        '<li%s>%s%s<a%s>%s%s%s</a>%s%s',
                        $health_care_center_css_classes,
                        '<div class="submenu-wrapper">',
                        $health_care_center_args['list_item_before'],
                        $health_care_center_attributes,
                        $health_care_center_args['link_before'],
                        /** This filter is documented in wp-includes/post-template.php */
                        apply_filters('the_title', $page->post_title, $page->ID),
                        $health_care_center_args['link_after'],
                        $health_care_center_args['list_item_after'],
                        '</div>'
                    );

            }else{

                $health_care_center_output .= $health_care_center_indent . sprintf(
                        '<li%s>%s<a%s>%s%s%s%s</a>%s',
                        $health_care_center_css_classes,
                        $health_care_center_args['list_item_before'],
                        $health_care_center_attributes,
                        $health_care_center_args['link_before'],
                        /** This filter is documented in wp-includes/post-template.php */
                        apply_filters('the_title', $page->post_title, $page->ID),
                        $health_care_center_args['icon_rennder'],
                        $health_care_center_args['link_after'],
                        $health_care_center_args['list_item_after']
                    );

            }

            if (!empty($health_care_center_args['show_date'])) {
                if ('modified' === $health_care_center_args['show_date']) {
                    $health_care_center_time = $page->post_modified;
                } else {
                    $health_care_center_time = $page->post_date;
                }

                $health_care_center_date_format = empty($health_care_center_args['date_format']) ? '' : $health_care_center_args['date_format'];
                $health_care_center_output .= ' ' . mysql2date($health_care_center_date_format, $health_care_center_time);
            }
        }
    }
}