<?php
/**
 * Body Classes.
 * @package Health Care Center
 */

if (!function_exists('health_care_center_body_classes')) :

    function health_care_center_body_classes($health_care_center_classes)
    {
        $health_care_center_defaults = health_care_center_get_default_theme_options();
        $health_care_center_layout = health_care_center_get_final_sidebar_layout();

        // Adds a class of hfeed to non-singular pages.
        if (!is_singular()) {
            $health_care_center_classes[] = 'hfeed';
        }

        // Sidebar layout logic
        $health_care_center_classes[] = $health_care_center_layout;

        // Copyright alignment
        $copyright_alignment = get_theme_mod('health_care_center_copyright_alignment', 'Default');
        $health_care_center_classes[] = 'copyright-' . strtolower($copyright_alignment);

        return $health_care_center_classes;
    }

endif;

add_filter('body_class', 'health_care_center_body_classes');