<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @since	  1.0.0
 * @package	hayya
 * @author	 zintaThemes <>
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>


<div id="comments" class="comments-area">

	<div class="hb_separator duble-lines separator-mask">
		<div class="left-separator"></div>
		<h4><?php esc_html_e( 'Comments', 'hayya' );?></h4>
		<div class="right-separator"></div>
	</div>

	<?php

	if ( have_comments() ) : ?>

		<h3 class="comments-title">
			<?php
			$comment_count = get_comments_number();
			if ( 1 === $comment_count ) {
				printf(
					/* translators: 1: title. */
					esc_html_e( 'One thought on &ldquo;%1$s&rdquo;', 'hayya' ),
					'<span>' . esc_html(get_the_title()) . '</span>'
				);
			} else {
				printf( // WPCS: XSS OK.
					/* translators: 1: comment count number, 2: title. */
					esc_html( _nx( '%1$s thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', $comment_count, 'comments title', 'hayya' ) ),
					esc_html(number_format_i18n( $comment_count )),
					'<span>' . esc_html(get_the_title()) . '</span>'
				);
			}
			?>
		</h3><!-- .comments-title -->

		<?php
			wp_list_comments( [
				'callback' => 'hayya_commants',
			] );
		?>

		<?php

		HayyaThemeComments::pagination();

		// If comments are closed and there are comments, let's leave a little note, shall we?
		if ( ! comments_open() ) : ?>
			<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'hayya' ); ?></p>
		<?php
		endif;

	endif; // Check for have_comments().

	hayya_commants();
	?>

</div><!-- #comments -->
