<?php
/**
 * Template part for displaying full width single post layout
 *
 * @link    https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Hasium
 */
global $hasium_options;
?>
<?php while ( have_posts() ) : the_post(); ?>

<div class="row justify-content-center">
    <div class="col-lg-10">
        <div class="details-content pt-55 pb-55">

            <div class="entry-cover">
                <?php if ( has_post_thumbnail() ){ ?>
                    <?php the_post_thumbnail('hasium-single-fullwidth'); ?>
                <?php } else { ?>
                    <img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placehold/1170x605.png" alt="Post">
                <?php } ?>
            </div>

            <div class="entry-header">
                <div class="post-info-cat">
                    <?php
                        foreach((get_the_category()) as $category) {
                            echo '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '">' . esc_html( $category->cat_name ) . '</a> ';
                        }
                    ?>
			    </div>
                <h2 class="post-title"><?php the_title(); ?></h2>
                <hr class="title-break">
                <div class="post-detail">
                    <?php echo esc_html(get_the_time( get_option('date_format') )); ?>
                </div>
            </div>


            <?php the_content(); ?>

            <div class="meta pt-40 pb-15">
                <div class="tag-social">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="tag mt-15">
                                <?php
                                    if ( get_the_tag_list() ) {
                                        echo get_the_tag_list('<ul class="d-flex"><li>','</li><li>','</li></ul>');
                                    }
                                ?>
                            </div> <!-- tag -->
                        </div>
                        <div class="col-md-6">
                            <div class="social mt-15">
                                <ul class="d-flex justify-content-start justify-content-md-end">
                                    <li><a href="#"><span class="hasium-icon-instagram"></span></a></li>
                                    <li><a href="#"><span class="hasium-icon-pinterest"></span></a></li>
                                    <li><a href="#"><span class="hasium-icon-twitter"></span></a></li>
                                    <li><a href="#"><span class="hasium-icon-spotify"></span></a></li>
                                    <li><a href="#"><span class="hasium-icon-vimeo"></span></a></li>
                                </ul>
                            </div> <!-- social -->
                        </div>
                    </div> <!-- row -->
                </div> <!-- tag social -->
                <?php
                  hasium_content_nav();
                ?>
            </div> <!-- meta -->

            <?php
            // Show author box if enabled.
            if ( true === $hasium_options['single_enable_author_box'] ) {
               get_template_part( 'template-parts/author/author', 'box' );
            }
            ?>

        </div> <!-- details content -->

        <?php
        // If comments are open or we have at least one comment, load up the comment template
        if ( comments_open() || '0' != get_comments_number() )
            comments_template();
        ?>

    </div>
</div> <!-- row -->

<?php endwhile; ?>
