<?php
/**
 * Template part for displaying blog layout 4 posts
 *
 * @link    https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Hasium
 */
?>
<div class="col-lg-3 col-md-6">
    <div class="news-fore mt-30">
            <div class="news-fore-image">
                <?php if ( has_post_thumbnail() ){ ?>
                    <?php the_post_thumbnail('hasium-layout-4'); ?>
                <?php } else { ?>
                    <img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placehold/300x247.png" alt="" title="" />
                <?php } ?>
                <span><?php foreach((get_the_category()) as $category) { echo $category->cat_name . ' '; } ?></span>
            </div>
        <div class="news-fore-content pt-25">
            <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
            <p class="mt-10"><?php the_excerpt(); ?></p>
            <div class="author-name clearfix mt-20">
                <div class="name">
                    <ul>
                        <li><a href="#"><?php get_the_author(); ?></a></li>
                        <li><a href="#"><?php echo esc_html(get_the_time( get_option('date_format') )); ?></a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div> <!-- news fore -->
</div>
