<?php
/**
 * Template part for displaying blog layout 3 posts
 *
 * @link    https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Hasium
 */
?>
<div class="col-lg-4 col-md-6 col-md-6">
    <div class="news-one mt-30">
            <div class="one-image">
                <?php if ( has_post_thumbnail() ){ ?>
                    <?php the_post_thumbnail('hasium-layout-3'); ?>
                <?php } else { ?>
                    <img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placehold/300x247.png" alt="" title="" />
                <?php } ?>
            </div>
        <div class="one-content mt-25">
            <div class="post-info-cat">
                <?php
                    foreach((get_the_category()) as $category) {
                        echo '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '">' . esc_html( $category->cat_name ) . '</a> ';
                    }
                ?>
			</div>
            <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
            <hr class="title-break">
            <div class="post-detail">
                <?php echo esc_html(get_the_time( get_option('date_format') )); ?>
            </div>
            <p class="mt-10"><?php the_excerpt(); ?></p>
        </div>
    </div> <!-- news one -->
</div>

