<?php
/**
 * Template part for displaying blog layout 1 posts
 *
 * @link    https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Hasium
 */
?>
<div class="news-three pt-15">
    <div class="row">
        <div class="col-md-5">
            <div class="news-three-image mt-15">
            <?php if ( has_post_thumbnail() ){ ?>
                <?php the_post_thumbnail('hasium-layout-1'); ?>
            <?php } else { ?>
                    <img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/placehold/300x247.png" alt="" title="" />
            <?php } ?>
              <span><?php foreach((get_the_category()) as $category) { echo $category->cat_name . ' '; } ?></span>
            </div>
        </div>
        <div class="col-md-7">
            <div class="news-three-content mt-15">
                <ul>
                    <li><a href="#"><?php echo get_the_author(); ?></a></li>
                    <li><a href="#"><?php echo esc_html(get_the_time( get_option('date_format') )); ?></a></li>
                </ul>
                <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                <?php the_excerpt(); ?>
                <div class="more-share clearfix mt-10">
                    <div class="more">
                        <a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read More', 'hasium' ); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </div> <!-- row -->
</div> <!-- news three -->
