<?php
/**
 * Displays Social Medias
 *
 * @package Hasium
 */

global $hasium_options;
//Social media icons
$social_icons = $hasium_options['social_icons'];

if ( (isset($hasium_options['header_style'])) ) {
    if ('site-header-center' === $hasium_options['header_style']) {
        $social_class = 'justify-content-lg-start';
    }else if('site-header-left' === $hasium_options['header_style']){
        $social_class = 'justify-content-sm-end';
    }
}

?>

<div class="header-social pt-15 d-none d-sm-block">
    <?php

    if(empty( $social_icons )){
      $social_icons =  array(
          array(
              'social_icon' => 'ti-paper-plane',
              'social_url'  => '#',
          ),
          array(
              'social_icon' => 'ti-twitter',
              'social_url'  => '#',
          ),
          array(
              'social_icon' => 'ti-pinterest-logo',
              'social_url'  => '#',
          ),
      );
    }

    if ( ! empty( $social_icons ) && is_array( $social_icons ) ) :
        ?>

        <ul class="d-flex justify-content-center <?php echo esc_attr($social_class); ?>">
            <?php
            // Loop through each of the social links.
            foreach ( $social_icons as $social_icon ) {
                if ( ! empty( $social_icon['social_url'] ) ) :
                    ?>

                    <li>
                        <a href="<?php echo esc_url( $social_icon['social_url'] ); ?>">
                            <i class="<?php echo esc_attr( $social_icon['social_icon'] ); ?>"></i>
                        </a>
                    </li>

                    <?php
                endif;
            }
            ?>
        </ul>

    <?php endif; ?>
</div> <!-- header social -->
