<?php
/**
 * Displays off canvas menu
 *
 * @package Hasium
 */

global $hasium_options;
?>

<div id="side-canvas" class="side-canvas">
    <div class="canvas-close text-right">
        <button class="canvas-closebtn">
            <span></span>
            <span></span>
        </button>
    </div>
    <div class="canvas-menu pt-15">
        <div class="canvas-menu-side">
            <?php
            $walker = new Hasium_Nav_Walker;
            wp_nav_menu(array(
                'theme_location'  => 'off_canvas',
                'fallback_cb'     => false,
                'container'       => false,
                'walker' 		  => $walker
            ));
            ?>
        </div>
    </div> <!-- canvas Menu -->
    <div class="canvas-contact pt-80">
        <div class="canvas-social">
            <?php if ( ! empty( $hasium_options['social_icons']  ) && is_array( $hasium_options['social_icons']  ) ) : ?>
            <ul class="d-flex">
                <?php
                // Loop through each of the social links.
                foreach ( $hasium_options['social_icons'] as $social_icon ) {
                    if ( ! empty( $social_icon['social_url'] ) ) :
                        ?>

                        <li>
                            <a href="<?php echo esc_url( $social_icon['social_url'] ); ?>">
                                <i class="<?php echo esc_attr( $social_icon['social_icon'] ); ?>"></i>
                            </a>
                        </li>

                        <?php
                    endif;
                }
                ?>
            </ul>
            <?php endif; ?>
        </div>
        <div class="convas-info mt-20">
            <?php if ( ! empty( $hasium_options['footer_info_contact_phone'] ) ) : ?>
            <span><?php echo esc_html( $hasium_options['footer_info_contact_phone'] ); ?></span>
            <?php endif; ?>
            <p class="mt-20">
                <?php
                /* translators: 1: Current Year, 2: Theme Developer 3: WordPress. */
                printf( esc_html__( 'Copyright %1$s | Theme By %2$s. Proudly powered by %3$s', 'hasium' ), esc_attr( date( 'Y' ) ), 'WPHobby', '<a href="https://wordpress.org">WordPress</a>' );
                ?>
            </p>
        </div>
    </div> <!-- row -->
</div>
