<?php
/**
 * Header to show when style is center.
 *
 * @package    Hasium
 * @author     wphobby
 * @link       http://hasium.wphobby.com
 */
?>
<!--====== HEADER PART START ======-->

<header class="header-area">
    <div class="container">
        <div class="header-top pt-30 pb-25">
            <div class="row align-items-center">
                <div class="col-lg-3 d-sm-center-block">
                    <?php get_template_part( 'template-parts/menu/menu', 'social' ); ?>
                </div>
                <div class="col-lg-6 col-sm-8 header-logo-wrapper header-logo-center-wrapper">
                    <div class="header-logo pt-15 text-center header-logo-center">
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" >
                            <?php
                              $custom_logo_id = get_theme_mod('custom_logo');
                              if($custom_logo_id) {
                                  $custom_logo_image = wp_get_attachment_image_src($custom_logo_id, 'full');
                                  ?>
                                  <img src="<?php echo esc_url($custom_logo_image[0]); ?>" alt=""/>
                                  <?php
                              }else{
                                  bloginfo('name');
                              }
                            ?>
                        </a>
                    </div> <!-- header logo -->
                </div>
                <div class="col-lg-3 col-sm-4">
                    <div class="header-account pt-15 d-none d-sm-block d-sm-center-block">
                        <ul class="d-flex justify-content-end">
                            <li><a href="#search-box"><i class="ti-search"></i></a></li>
                            <li><a href="<?php echo esc_url(wp_login_url()); ?>"><i class="ti-user"></i></a></li>
                            <li><a href="#side-canvas"><i class="ti-menu"></i></a></li>
                        </ul>
                    </div> <!-- header account -->
                </div>
            </div> <!-- row -->
        </div> <!-- header top -->
        <div class="header-navigation">
            <div class="row">
                <div class="col-lg-12">
                <?php get_template_part( 'template-parts/menu/menu', 'primary' ); ?>
                </div>
            </div> <!-- row-->
        </div> <!-- header navigation -->
    </div> <!-- container -->

    <div class="header-sticky d-none d-lg-block">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">
                    <div class="header-logo pt-20">
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" >
                            <?php $custom_logo_id = get_theme_mod('custom_logo');
                            $custom_logo_image = wp_get_attachment_image_src( $custom_logo_id , 'full');
                            ?>
                            <img src="<?php echo esc_url($custom_logo_image[0]); ?>" alt="" />
                        </a>
                    </div> <!-- header logo -->
                </div>
                <div class="col-lg-6">
                    <?php get_template_part( 'template-parts/menu/menu', 'primary' ); ?>
                </div>
                <div class="col-lg-3">
                    <div class="header-account pt-15">
                        <ul class="d-flex justify-content-end">
                            <li><a href="#search-box"><i class="ti-search"></i></a></li>
                            <li><a href="<?php echo esc_url(wp_login_url()); ?>"><i class="ti-user"></i></a></li>
                            <li><a href="#side-canvas"><i class="ti-menu"></i></a></li>
                        </ul>
                    </div> <!-- header account -->
                </div>
            </div> <!-- row -->
        </div> <!-- container -->
    </div> <!-- header sticky -->

</header>

<!--====== HEADER PART ENDS ======-->

